@extends('backend.layouts.master')

@section('title')
  {{ __('Order Manage') . ' - ' . $title }}
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0"> {{ __('Goods') }} </h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{ route('home') }}">{{ __('Dashboard') }}</a>
            </li>
            @if(helper::roleAccess('proforma.invoice.list'))
              <li class="breadcrumb-item">
                <a href="{{ route('proforma.invoice.list') }}">{{ __('PI List') }}</a>
              </li>
            @endif
            <li class="breadcrumb-item active">
              <span>{{ $title }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">{{ $title }}</h3>
          <div class="card-tools">
            @if(helper::roleAccess('proforma.invoice.list'))
              <a class="btn btn-tool btn-default" href="{{ route('proforma.invoice.list') }}">
                <i class="fa fa-list"></i>
                <span>{{ __('PI List') }}</span>
              </a>
            @endif
            <span id="buttons"></span>
            <a class="btn btn-tool btn-default" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </a>
            <a class="btn btn-tool btn-default" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div><!-- /.card-header -->
        <div class="card-body d-flex justify-content-center">
          <div class="col-md-10" >
            <form class="needs-validation" method="POST" action="{{ route('proforma.invoice.store') }}" novalidate enctype="multipart/form-data" >
              @csrf
              <div class="form-row">
                <div class="col-md-6 mb-3">
                  <label for="piNumber">{{ __('PI Number * :') }}</label>
                  <input type="text" name="pi_number" class="form-control form-control-sm" id="piNumber" placeholder="PI Number" value="{{ old('pi_number') }}" required />
                  @error('pi_number')
                    <span class=" error text-red text-bold">{{ $message }}</span>
                  @enderror
                </div>
                <div class="col-md-6 mb-3">
                  <label for="orderID">{{ __('Order * :') }}</label>
                  <select class="form-control select2" name="order_id" id="orderID" required >
                    <option selected disabled value="">{{ __('--Select--') }}</option>
                    @foreach( $orders as $key => $order )
                      <option value="{{ $order->id }}">{{ '[' . $order->po_number . '] - ' . $order->buyer->name . ' - (' . $order->style_no . ')' }}</option>
                      <input type="hidden" name="buyer_id" value="{{ $order->buyer_id }}" />
                    @endforeach
                  </select>
                  @error('order_id')
                    <span class=" error text-red text-bold">{{ $message }}</span>
                  @enderror
                </div>
                <div class="col-md-6 mb-3">
                  <label for="piDate">{{ __('PI Date * :') }}</label>
                  <div class="input-group input-group-sm date" id="reservationdate1" data-target-input="nearest">
                    <input type="text" id="piDate" name="pi_date" data-toggle="datetimepicker" value="{{ old('pi_date', date('Y-m-d')) }}" class="form-control datetimepicker-input" data-target="#reservationdate1" />
                    <div class="input-group-append" data-target="#reservationdate1" data-toggle="datetimepicker">
                      <div class="input-group-text">
                        <i class="fa fa-calendar"></i>
                      </div>
                    </div>
                  </div>
                  @error('pi_date')
                    <span class=" error text-red text-bold">{{ $message }}</span>
                  @enderror
                </div>
                <div class="col-md-6 mb-3">
                  <label for="vatNumber">{{ __('VAT Number * :') }}</label>
                  <input type="text" name="vat_number" class="form-control form-control-sm" id="vatNumber" placeholder="Vat Number" value="{{ old('vat_number') }}" required />
                  @error('vat_number')
                    <span class=" error text-red text-bold">{{ $message }}</span>
                  @enderror
                </div>
              </div>
              <button class="btn btn-info" type="submit">
                <i class="fa fa-save"></i>
                <span>&nbsp; {{ __('Save') }}</span>
              </button>
            </form>
          </div>
        </div><!-- /.card-body -->
        <div class="card-footer"></div>
      </div>
    </div><!-- /.col-->
  </section>
@endsection

@section('scripts')
  <script>
    $(function () {
      bsCustomFileInput.init();
    });
  </script>

  <script>
    var imgInp = document.getElementById("thumbnail");
    var dummy = document.getElementById("dummy");
    imgInp.onchange = evt => {
      const [file] = imgInp.files
      if (file) {
        dummy.src = URL.createObjectURL(file)
      }
    }
  </script>
@endsection