@extends('backend.layouts.master')

@section('title')
  {{ __('Inventory') . ' - ' . $title }}
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0"> {{ __('Goods') }} </h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{route('home')}}">{{ __('Dashboard') }}</a>
            </li>
            @if(helper::roleAccess('inventorySetup.goods.index'))
              <li class="breadcrumb-item">
                <a href="{{ route('inventorySetup.goods.index') }}">{{ __('Goods List') }}</a>
              </li>
            @endif
            <li class="breadcrumb-item active">
              <span>{{ $title }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">{{ $title }}</h3>
          <div class="card-tools">
            @if(helper::roleAccess('inventorySetup.goods.index'))
              <a class="btn btn-tool btn-default" href="{{ route('inventorySetup.goods.index') }}">
                <i class="fa fa-list"></i>
                <span>{{ __('Goods List') }}</span>
              </a>
            @endif
            <span id="buttons"></span>
            <a class="btn btn-tool btn-default" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </a>
            <a class="btn btn-tool btn-default" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div><!-- /.card-header -->
        <div class="card-body">
          <form class="needs-validation" method="POST" action="{{ route('inventorySetup.goods.store') }}" novalidate enctype="multipart/form-data" >
            @csrf
            <div class="row">
              <div class="col-md-9">
                <div class="form-row">
                  <div class="col-md-12 mb-3">
                    <span class="bg-green" style="padding: 5px; font-weight : bold" for="validationCustom01">{{ __('Goods Code * :') }} {{ $goodsCode }}</span>
                    <input type="hidden" name="goodsCode" class="form-control" id="" value="{{ $goodsCode }}" />
                  </div>
                  <div class="col-md-6 mb-3">
                    <label for="validationCustom01">{{ __('Name * :') }}</label>
                    <input type="text" name="name" class="form-control form-control-sm" id="validationCustom01" placeholder="Name" value="{{ old('name') }}" />
                    @error('name')
                      <span class=" error text-red text-bold">{{ $message }}</span>
                    @enderror
                  </div>
                  <div class="col-md-6 mb-3">
                    <label for="validationCustom01">{{ __('Category Name * :') }}</label>
                    <select class="form-control select2" name="genre_id">
                      <option selected disabled value="">{{ __('--Select--') }}</option>
                      @foreach($genres as $key => $value)
                        <option value="{{$value->id}}">{{  $value->name}}</option>
                      @endforeach
                    </select>
                    @error('genre_id')
                      <span class=" error text-red text-bold">{{ $message }}</span>
                    @enderror
                  </div>
                  {{-- <div class="col-md-6 mb-3">
                    <label for="validationCustom01">{{ __('Unit Name * :') }}</label>
                    <select class="form-control select2" name="unit_id">
                      <option selected disabled value="">{{ __('--Select--') }}</option>
                      <option value="0">{{ __('Unit') }}</option>
                      @foreach($units as $key => $value)
                        <option value="{{$value->id}}">{{$value->name}}</option>
                      @endforeach
                    </select>
                    @error('unit_id')
                      <span class=" error text-red text-bold">{{ $message }}</span>
                    @enderror
                  </div> --}}
                  <div class="col-md-6 mb-3">
                    <label for="validationCustom01">{{ __('Purchases Price * :') }}</label>
                    <input type="number" class="form-control form-control-sm" name="purchases_price" />
                    @error('purchases_price')
                      <span class=" error text-red text-bold">{{ $message }}</span>
                    @enderror
                  </div>
                  <div class="col-md-6 mb-3">
                    <label for="validationCustom01">{{ __('Sale Price * :') }}</label>
                    <input type="number" class="form-control form-control-sm" name="sale_price" />
                    @error('sale_price')
                      <span class=" error text-red text-bold">{{ $message }}</span>
                    @enderror
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="col-md-12 mb-3">
                  <label for="exampleInputFile">{{ __('Thumbnail :') }}</label>
                  <div class="input-group input-group-sm">
                    <div class="custom-file">
                      <input type="file" name="thumbnail" class="custom-file-input" id="thumbnail" accept=".jpg, .jpeg, .png, .gif, .webp" />
                      <label class="custom-file-label" for="thumbnail" >{{ __('Choose file') }}</label>
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSHZqj-XReJ2R76nji51cZl4ETk6-eHRmZBRw&s" id="dummy" class="img-fluid w-100" height="165px" alt="Thumbnail" />
                </div>
              </div>
            </div>
            <button class="btn btn-info" type="submit">
              <i class="fa fa-save"></i>
              <span>&nbsp; {{ __('Save') }}</span>
            </button>
          </form>
        </div><!-- /.card-body -->
        <div class="card-footer"></div>
      </div>
    </div><!-- /.col-->
  </section>
@endsection

@section('scripts')
  <script>
    $(function () {
      bsCustomFileInput.init();
    });
  </script>

  <script>
    var imgInp = document.getElementById("thumbnail");
    var dummy = document.getElementById("dummy");
    imgInp.onchange = evt => {
      const [file] = imgInp.files
      if (file) {
        dummy.src = URL.createObjectURL(file)
      }
    }
  </script>
@endsection