<script type="text/javascript">
    let table = $('#systemDatatable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "{{ route('finished.goods.datagoods') }}",
            "dataType": "json",
            "type": "GET",
            "data": {
                "_token": "<?= csrf_token() ?>"
            }
        },
        "columns": [{
                "data": "id",
                "orderable": true
            },
            {
                "data": "date",
                "orderable": true
            },
            {
                "data": "order_voucher_id",
                "orderable": true
            },
            {
                "data": "invoice_no",
                "orderable": true
            },
            {
                "data": "total_qty",
                "orderable": true
            },
            {
                "data": "approve_qty",
                "orderable": true
            },
            {
                "data": "remarks_qty",
                "orderable": true
            },
            {
                "data": "status",
                "orderable": true
            },
            {
                "data": "action",
                "class": 'text-nowrap',
                "searchable": false,
                "orderable": false
            },
        ],

        "fnDrawCallback": function() {
            $("[name='my-checkbox']").bootstrapSwitch({
                size: "small",
                onColor: "success",
                offColor: "danger"
            });
        },

    });


    var buttons = new $.fn.dataTable.Buttons(table, {
        buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'print',
        ]
    }).container().appendTo($('#buttons'));
</script>
