@extends('backend.layouts.master')

@section('title', 'Accessories List')

@section('styles')
<style>
    .bootstrap-switch-large {
        width: 200px;
    }
</style>
@endsection

@section('navbar-content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6"></div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                    @if (helper::roleAccess('sale.sale.index'))
                        <li class="breadcrumb-item"><a href="{{ route('accesories.list') }}">Accessories</a></li>
                    @endif
                    <li class="breadcrumb-item active">Accessories List</li>
                </ol>
            </div>
        </div>
    </div>
</div>
@endsection

@section('admin-content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="p-2 d-flex justify-content-between ">
                <h3 class="card-title">Accessories List</h3>
                <div class="card-tools">
                    @if (helper::roleAccess('sale.sale.create'))
                        <a class="btn btn-default" href="{{ route('accesories.create') }}">
                            <i class="fas fa-plus"></i> Add New
                        </a>
                    @endif
                    <span id="buttons"></span>
                    <button class="btn btn-tool btn-default" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button class="btn btn-tool btn-default" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="systemDatatables" class="display table-hover table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>SL</th>
                                <th>Name</th>
                                <th>Unit</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($accesories as $sale)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $sale->name ?? 'N/A' }}</td>
                                    <td>{{ $sale->unit ?? 'N/A' }}</td>
                                    <td>
                                        <a href="{{ route('accesories.edit', $sale->id) }}" class="btn btn-primary ml-2">
                                            Edit
                                        </a>
                                    
                                        <form action="{{ route('accesories.delete', $sale->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger  ml-2">
                                                Delete
                                            </button>
                                        </form>
                                    
                                    </td>
                                    
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>SL</th>
                                <th>Name</th>
                                <th>Unit</th>
                                <th>Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <div class="card-footer">
                {{-- Optional footer --}}
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
@endsection