<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProformaInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('proforma_invoices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->unsigned();
            $table->foreignId('buyer_id')->unsigned();
            $table->string('pi_number', 15)->nullable();
            $table->string('vat_number', 15)->nullable();
            $table->timestamp('pi_date')->nullable();
            $table->text('note')->nullable();
            $table->foreignId('created_by')->nullable();
            $table->foreignId('updated_by')->nullable();
            // $table->enum('status', ['Pending', 'Approved', 'Rejected'])->default('Pending')->comment('set pending as default');
            // $table->enum('status', ['Pending', 'Confirm', 'Processing', 'Production', 'Packaging', 'Delivered', 'Completed'])->default('Pending')->comment('set pending as default');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('proforma_invoices');
    }
}
