<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('buyer_id')->unsigned();
            $table->string('order_code')->nullable();
            $table->foreignId('invoice_id')->unsigned();
            $table->string('style_no', 50);
            $table->string('po_number', 10);
            $table->timestamp('order_date')->nullable();
            $table->double('amount', 2)->nullable();
            $table->text('note')->nullable();
            $table->enum('status', ['Pending', 'Approved', 'Confirmed'])->default('Pending')->comment('set pending as default');
            $table->foreignId('progress_id')->unsigned()->default(1);
            $table->foreignId('approved_by')->unsigned();
            $table->foreignId('confirmed_by')->unsigned();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
