<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBuyersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('buyers', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100);
            $table->string('company_name')->nullable();
            $table->string('phone', 15)->unique();
            $table->string('email', 50)->unique();
            $table->integer('branch_id')->unsigned()->nullable();
            $table->string('avatar')->nullable();
            $table->string('address')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->enum('status', ['Approved', 'Rejected', 'Pending'])->default('Pending')->comment('default status set active , penidng status waiting for approbal');
            // $table->integer('updated_by')->nullable();
            // $table->integer('created_by')->nullable();
            // $table->integer('deleted_by')->nullable();
            $table->softDeletes();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('buyers');
    }
}
