<?php

namespace App\Repositories\InventorySetup;

use App\Helpers\Helper;
use Illuminate\Support\Facades\Auth;
use App\Models\Color;
use phpDocumentor\Reflection\PseudoTypes\False_;

class ColorRepositories {
    /**
     * @var user_id
     */
    private $user_id;
    /**
     * @var Color
     */
    private $color;
    /**
     * CourseRepository constructor.
     * @param color $color
     */
    public function __construct(Color $color) {
        $this->color = $color;
        //$this->middleware(function ($request, $next) {
        $this->user_id = 1; //auth()->user()->id;
        //  return $next($request);
        //});
    }

    /**
     * @param $request
     * @return mixed
     */
    public function getAllList() {
        $result = $this->color::latest()->get();
        return $result;
    }


    /**
     * @param $request
     * @return mixed
     */

    public function getList($request) {
        $columns = array(
            0 => 'id',
            1 => 'name',
        );

        $edit = Helper::roleAccess('inventorySetup.color.edit') ? 1 : 0;
        $delete = Helper::roleAccess('inventorySetup.color.destroy') ? 1 : 0;
        $view = Helper::roleAccess('inventorySetup.color.show') ? 0 : 0;
        $ced = $edit + $delete + $view;

        $totalData = $this->color::count();

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');

        if (empty($request->input('search.value'))) {
            $colors = $this->color::offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                //->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->color::count();
        } else {
            $search = $request->input('search.value');
            $colors = $this->color::where('name', 'like', "%{$search}%")
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                // ->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->color::where('name', 'like', "%{$search}%")->count();
        }



        $data = array();
        if ($colors) {
            foreach ($colors as $key => $color) {
                $nestedData['id'] = $key + 1;
                $nestedData['name'] = $color->name;
                if ($color->status == 'Display') :
                    $status = '<input class="status_row" status_route="' . route('inventorySetup.color.status', [$color->id, 'Hidden']) . '"   id="toggle-demo" type="checkbox" name="my-checkbox" checked data-bootstrap-switch data-off-color="danger" data-on-color="success">';
                else :
                    $status = '<input  class="status_row" status_route="' . route('inventorySetup.color.status', [$color->id, 'Display']) . '"  id="toggle-demo" type="checkbox" name="my-checkbox"  data-bootstrap-switch data-off-color="danger" data-on-color="success">';
                endif;
                $nestedData['status'] = $status;
                if ($ced != 0) :
                    if ($edit != 0)
                        $edit_data = '<a href="' . route('inventorySetup.color.edit', $color->id) . '" class="btn btn-xs btn-default"><i class="fa fa-edit" aria-hidden="true"></i></a>';
                    else
                        $edit_data = '';
                    if ($view != 0)
                        $view_data = '<a href="' . route('inventorySetup.color.show', $color->id) . '" class="btn btn-xs btn-default"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                    else
                        $view_data = '';
                    if ($delete != 0)
                        $delete_data = '<a delete_route="' . route('inventorySetup.color.destroy', $color->id) . '" delete_id="' . $color->id . '" title="Delete" class="btn btn-xs btn-default delete_row uniqueid' . $color->id . '"><i class="fa fa-times"></i></a>';
                    else
                        $delete_data = '';
                    $nestedData['action'] = $edit_data . ' ' . $view_data . ' ' . $delete_data;
                else :
                    $nestedData['action'] = '';
                endif;
                $data[] = $nestedData;
            }
        }
        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        return $json_data;
    }
    /**
     * @param $request
     * @return mixed
     */
    public function details($id) {
        $result = $this->color::find($id);
        return $result;
    }

    public function store($request) {
        $color = new $this->color();
        $color->name = $request->name;
        $color->colorCode = $this->reduceSpace(strtolower($request->name));
        $color->status = $request->status;
        $color->created_by = Auth::user()->id;
        $color->save();
        return $color;
    }

    public function update($request, $id) {
        $color = $this->color::findOrFail($id);
        $color->name = $request->name;
        $color->colorCode = $this->reduceSpace(strtolower($request->name));
        $color->status = $request->status;
        $color->updated_by = Auth::user()->id;
        $color->save();
        return $color;
    }

    public function statusUpdate($id, $status) {
        $color = $this->color::find($id);
        $color->status = $status;
        $color->save();
        return $color;
    }

    public function destroy($id) {
        $color = $this->color::find($id);
        $color->delete();
        return true;
    }

    protected function reduceSpace($string) {
        return preg_replace('/\s+/', ' ', $string);
    }
}
