<?php

namespace App\Http\Controllers\Backend\Hrm;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Attendance;
use App\Models\Employee;
use Rats\Zkteco\Lib\ZKTeco;

class AttendanceLogController extends Controller
{
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */

    public function index(Request $request)
    {
        $title = 'Attendance Log';
        session(['previous_url' => url()->current()]);
        $employees = Employee::all();
        if ($request->method() == "POST") {
            $attendances = Attendance::selectRaw('DATE(date) date,emplyee_id,sign_in,sign_out,id')->with('employe');
        
            if ($request->employee_id != 'all') {
                $attendances =  $attendances->where('emplyee_id', $request->employee_id);
            }

            if ($request->from && $request->to) {
                $attendances =  $attendances->where('date', '>=', $request->from);
                $attendances =  $attendances->where('date', '<=', $request->to);
            }

            $attendances = $attendances->get();
        
            $dayes = Attendance::selectRaw('DATE(date) date');
            if ($request->from && $request->to) {
                $dayes =  $dayes->where('date', '>=', $request->from);
                $dayes =  $dayes->where('date', '<=', $request->to);
            }
            $dayes = $dayes->groupBy('date')->get();
        }

        return view('backend.pages.hrm.attendance.attendance-log.index', get_defined_vars());
    }

    public function absent(Request $request)
    {
        $title = 'Attendance Absent';

        $attendances = Attendance::whereDate('date',date("Y-m-d"))->pluck("emplyee_id")->toArray();
        $employees = Employee::whereNotIn("id",$attendances)->get();
        return view('backend.pages.hrm.attendance.attendance-log.absent', compact("employees","title"));
    }
    public function newemployee(Request $request)
    {
        $title = 'New  Employee';

        $employees = Employee::whereMonth("created_at",date("m"))->whereYear("created_at",date("Y"))->get();

        return view('backend.pages.hrm.attendance.attendance-log.newemployee', compact("employees","title"));
    }
}
