<?php

use App\Models\Accounts;
use App\Models\AccountTransaction;
use App\Models\ChartOfAccount;
use App\Models\Transection;
use App\Models\Holiday;
use Carbon\Carbon;
use Carbon\CarbonImmutable;
use Carbon\CarbonPeriod;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;


define('MEDICAL_ALLOWANCE', 600);
define('TRAVEL_ALLOWANCE', 350);
define('FOOD_ALLOWANCE', 900);

function ALLOWANCE_AMOUNT()
{
    return MEDICAL_ALLOWANCE + TRAVEL_ALLOWANCE + FOOD_ALLOWANCE;
}

// GET THIS MONTH WORKING DAYS
// function MONTH_WORKING_DAY($month = null)
// {
//     $month = $month ? $month : date("Y-m");
//     $month = date("Y-m-d", strtotime($month . "-01"));

//     $carbonMonth = Carbon::parse($month);

//     $startOfMonth = Carbon::parse($month);
//     $endOfMonth = $carbonMonth->endOfMonth();
 
//     $CURRENT_MONTH_HOLIDAY = CarbonPeriod::create($startOfMonth, $endOfMonth)
//         ->filter(fn($date) => $date->isFriday()) 
//         ->count();

//     $TOTAL_DAT_OF_THIS_MONTH = $carbonMonth->daysInMonth;
//     $TOTAL_WORKING_DAY = $TOTAL_DAT_OF_THIS_MONTH - $CURRENT_MONTH_HOLIDAY;
//     return $TOTAL_WORKING_DAY;
// }


function MONTH_WORKING_DAY($month = null)
{
    // মাসের প্রথম ও শেষ তারিখ নির্ধারণ
    $startDate = date('Y-m-01', strtotime($month));
    $endDate = date('Y-m-t', strtotime($month));

    // মাসের সব দিন বের করি
    $totalDaysInMonth = (new DateTime($startDate))->diff(new DateTime($endDate))->days + 1;

    // কতগুলো দিন ছুটি ছিল সেটা বের করি (Holiday টেবিল থেকে)
    $holidayCount = Holiday::whereBetween('date', [$startDate, $endDate])->count();

    // মোট কর্মদিবস = মোট দিন - ছুটির দিন
    return $totalDaysInMonth - $holidayCount;
}


//GET EMPLOYEE WORKING DAYS
function EMPLOYEE_PRESENCE_DAY($EMPLOYEE_ID, $month)
{
    $ATTENDANCE = DB::table('attendances')->where('emplyee_id', $EMPLOYEE_ID)->whereMonth('date', $month ? date('m', strtotime($month)) : date('m'))->count();
    return $ATTENDANCE;
}

 function EMPLOYEE_OVER_TIME($EMPLOYEE_ID, $month){
    $OT = DB::table('attendances')->where('emplyee_id',$EMPLOYEE_ID)->whereMonth('date',$month ? date('m', strtotime($month)): date('m'))->sum('ot');
    return $OT;
 }

function OVERTIME_SALARY($EMPLOYEE, $month =null)
{
    if ($EMPLOYEE->over_time_is == "yes") {
        $ot_hours = EMPLOYEE_OVER_TIME($EMPLOYEE->id, $month); // ওভারটাইম ঘণ্টা
      $per_hour_rate = ($EMPLOYEE->salary/1000) * 5;         // প্রতি ঘণ্টায় ৫% বেতন
    
        $total_overtime_salary = $per_hour_rate * $ot_hours;

        return round($total_overtime_salary, 2);
    }

    return 0;
}

//GET EMPLOYEE LEAVE DAYS COUNT
function EMPLOYEE_ABSENCE_DAY($EMPLOYEE_ID, $month)
{
    $totalWorkingDays = MONTH_WORKING_DAY($month);
    $presentDays = EMPLOYEE_PRESENCE_DAY($EMPLOYEE_ID, $month);
    $absentDays = $totalWorkingDays - $presentDays;

    return $absentDays < 0 ? 0 : $absentDays;
}
function LATE_DAYS($EMPLOYEE_ID, $month=null)
{
    $LATE = DB::table('attendances')->where('emplyee_id',$EMPLOYEE_ID)->whereMonth('date',$month ? date('m', strtotime($month)): date('m'))->where('lateStatus','no')->count();
    return $LATE;
}
function LATE_DAYS_SALARY_DEDUCTION($EMPLOYEE_ID, $month=null)
{
    $LATECount = DB::table('attendances')->where('emplyee_id',$EMPLOYEE_ID)->whereMonth('date',$month ? date('m', strtotime($month)): date('m'))->where('lateCount',3)->count();
    return $LATECount;
}
//GET EMPLOYEE MAIN SALARY
function EMPLOYEE_BASIC_SALARY($EMPLOYEE_SALARY)
{
    $MAIN_SALARY = ($EMPLOYEE_SALARY - ALLOWANCE_AMOUNT()) / 1.5;
    $HALF_SALARY = $EMPLOYEE_SALARY * 0.5; // Calculate 50% of the salary

    return [
        'main_salary' => round($MAIN_SALARY),
        'half_salary' => round($HALF_SALARY),
    ];
}

//GET EMPLOYEE HOUSE RENT MAIN SALARY
function EMPLOYEE_HOUSE_RENT_SALARY($EMPLOYEE_SALARY)
{
    $HOUSE_RENT = EMPLOYEE_BASIC_SALARY($EMPLOYEE_SALARY)['half_salary'] / 2;
    return round($HOUSE_RENT);
}

function OVERTIME_HOURE($EMPLOYEE)
{
    $ATTENDANCES = DB::table('attendances')->where('emplyee_id', $EMPLOYEE->id)->whereMonth('date', date('m'))->get();
    $HOURE = 0;
    foreach ($ATTENDANCES as $ATTENDANCE) {
        if (strtotime($ATTENDANCE->sign_in) < strtotime($EMPLOYEE->last_in_time)) {
            $in = Carbon::parse($EMPLOYEE->last_in_time);
            $lastin = Carbon::parse($ATTENDANCE->sign_out);
        } else {
            $in = Carbon::parse($ATTENDANCE->sign_in);
            $lastin = Carbon::parse($ATTENDANCE->sign_out);
        }
        $signOutTime = strtotime($lastin);
        $officeEndTime = strtotime($in . ' +8 hours');

        if ($officeEndTime < $signOutTime) {
            $TOTAL_TIME = $in->diff($lastin->subHour(8));
            $HOURE += $TOTAL_TIME->h;
            if ($TOTAL_TIME->i >= 50) {
                $HOURE += 1;
            }
        }
    }

    return round($HOURE);
}



//GET EMPLOYEE LATE DAYS
// function LATE_DAYS($EMPLOYEE)
// {
//     $EMPLOYEE_LAST_IN_TIME = Carbon::parse($EMPLOYEE->last_in_time)->addMinutes(15)->format("H:i:s");
//     $LATE = DB::table('attendances')->where('emplyee_id', $EMPLOYEE->id)->whereMonth('date', date('m'))
//         ->whereTime('sign_in', ">", $EMPLOYEE_LAST_IN_TIME)->count();
//     return $LATE;
// }

function LATE_DAYS_SALARY_DEDUCT($EMPLOYEE)
{
    $EMPLOYEE_SALARY = $EMPLOYEE->salary;
    $DAYS = 26;
    $ONE_DAY_SALARY = $EMPLOYEE_SALARY / $DAYS;
    $TOTAL = 0;
    $LATE_COUNT = LATE_DAYS($EMPLOYEE);
    if ($LATE_COUNT > 3) {
        $TOTAL += $ONE_DAY_SALARY;
    }
    if ($LATE_COUNT > 6) {
        $TOTAL += $ONE_DAY_SALARY;
    }
    if ($LATE_COUNT > 9) {
        $TOTAL += $ONE_DAY_SALARY;
    }
    if ($LATE_COUNT > 12) {
        $TOTAL += $ONE_DAY_SALARY;
    }
    if ($LATE_COUNT > 15) {
        $TOTAL += $ONE_DAY_SALARY;
    }
    if ($LATE_COUNT > 18) {
        $TOTAL += $ONE_DAY_SALARY;
    }
    if ($LATE_COUNT > 21) {
        $TOTAL += $ONE_DAY_SALARY;
    }
    if ($LATE_COUNT > 24) {
        $TOTAL += $ONE_DAY_SALARY;
    }
    if ($LATE_COUNT > 27) {
        $TOTAL += $ONE_DAY_SALARY;
    }
    if ($LATE_COUNT > 30) {
        $TOTAL += $ONE_DAY_SALARY;
    }
    return round($TOTAL);
}


function EMPLOYEE_UNPAID_LEAVE_SALARY($EMPLOYEE)
{
    $DAYS = 26;
    $UNPAID_LEAVE = UNPAID_LEAVE_COUNT($EMPLOYEE);
    $EMPLOYEE_SALARY = $EMPLOYEE->salary;
    $ONE_DAY_SALARY = $EMPLOYEE_SALARY / $DAYS;
    $UNPAID_LEAVE_SALARY =  $ONE_DAY_SALARY * $UNPAID_LEAVE;
    return round($UNPAID_LEAVE_SALARY);
}

//GET EMPLOYEE PAYABLE SALARY
function EMPLOYEE_PAYABLE_SALARY($EMPLOYEE, $month)
{
    $LATE_DAYS_SALARY_DEDUCT = LATE_DAYS_SALARY_DEDUCT($EMPLOYEE);
    $DAYS = 26;
    $OVERTIME_SALARY = OVERTIME_SALARY($EMPLOYEE);
    $EMPLOYEE_SALARY = $EMPLOYEE->salary;
    $ONE_DAY_SALARY = $EMPLOYEE_SALARY / $DAYS;
    $UNPAID_LEAVE_SALARY = EMPLOYEE_UNPAID_LEAVE_SALARY($EMPLOYEE);
    $DEDUCT_SALARY = $ONE_DAY_SALARY * EMPLOYEE_ABSENCE_DAY($EMPLOYEE->id, $month);
    $PAYABLE_SALARY = ($EMPLOYEE_SALARY + $OVERTIME_SALARY) - ($DEDUCT_SALARY + $LATE_DAYS_SALARY_DEDUCT + $UNPAID_LEAVE_SALARY);
    return round($PAYABLE_SALARY);
}

function PAID_LEAVE_COUNT($EMPLOYEE)
{
    $LEAVES = DB::table('leave_applications')->where('employee_id', $EMPLOYEE->id)->where('payment_status', 'paid')->where('status', 'approved')->whereMonth('apply_date', date('m'))->get();
    $DAYS = 0;
    foreach ($LEAVES as $LEAVE) {
        $START = Carbon::parse($LEAVE->apply_date);
        $END = Carbon::parse($LEAVE->end_date);
        $DAYS += $START->diffInDays($END);
        if ($DAYS != 0)
            $DAYS += 1;
    }
    return $DAYS;
}

function UNPAID_LEAVE_COUNT($EMPLOYEE)
{
    $LEAVES = DB::table('leave_applications')->where('employee_id', $EMPLOYEE->id)->where('payment_status', 'non-paid')->where('status', 'approved')->whereMonth('apply_date', date('m'))->get();
    $DAYS = 0;
    foreach ($LEAVES as $LEAVE) {
        $START = Carbon::parse($LEAVE->apply_date);
        $END = Carbon::parse($LEAVE->end_date);
        $DAYS += $START->diffInDays($END);
        if ($DAYS != 0)
            $DAYS += 1;
    }
    return $DAYS;
}


function AccountBalance($id)
{
    $opening =  Transection::where('account_id', $id)->where('type', 1)->pluck('amount')->first() ?? 0;
    $debit = AccountTransaction::where('account_id', '=', $id)->sum('debit');
    $credit = AccountTransaction::where('account_id', '=', $id)->sum('credit');
    $total = ($debit - $credit) + $opening;

    $account = ChartOfAccount::findOrFail($id);

    // Calculate the opening balance as of the start date
    $debitSumBeforeStartDate = AccountTransaction::where('account_id', $id)

        ->sum('debit');

    $creditSumBeforeStartDate = AccountTransaction::where('account_id', $id)

        ->sum('credit');

    // Adjust opening balance based on the balance type
    if ($account->balance_type === 'debit') {
        $openingBalance = $account->opening_balance + $debitSumBeforeStartDate - $creditSumBeforeStartDate;
    } else {
        $openingBalance = -$account->opening_balance + $debitSumBeforeStartDate - $creditSumBeforeStartDate;
    }

    $runningBalance = $openingBalance;

    return $runningBalance;
}

function copyword($num, $syntexs)
{
    if ($num != 0) {
        $syntex = $syntexs;
        for ($i = 0; $i < $num; $i++) {
            $syntex .= $syntex;
        }
        return $syntex;
    }
    return "";
}

function getFirstAccount($id)
{
    $account_list = ChartOfAccount::find($id);
    if ($account_list) {
        $lastid = $id;
        if ($account_list->account) {
            $lastid = $account_list->account->id;
            return  getFirstAccount($lastid);
        }
        return $lastid;
    } else {
        return 0;
    }
}

function getUnderAccount($id, $today = null, $acType = true)
{
    $accounts = ChartOfAccount::getaccount($id)->get();
    $runningBalance = 0;

    foreach ($accounts as $account) {
        // Calculate the opening balance as of the start date
        $debitSumBeforeStartDate = AccountTransaction::where('account_id', $account->id);
        if ($today) {
            $debitSumBeforeStartDate =  $debitSumBeforeStartDate->whereDate('created_at',  $today);
        }
        $debitSumBeforeStartDate =  $debitSumBeforeStartDate->sum('debit');

        $creditSumBeforeStartDate = AccountTransaction::where('account_id', $account->id);
        if ($today) {
            $creditSumBeforeStartDate = $creditSumBeforeStartDate->whereDate('created_at', $today);
        }
        $creditSumBeforeStartDate = $creditSumBeforeStartDate->sum('credit');

        // Adjust opening balance based on the balance type
        if ($account->balance_type === 'debit') {
            $openingBalance = $account->opening_balance + $debitSumBeforeStartDate - $creditSumBeforeStartDate;
        } else {
            $openingBalance = -$account->opening_balance +  $creditSumBeforeStartDate - $debitSumBeforeStartDate;
        }
        $runningBalance += $openingBalance;
    }

    return $runningBalance;
}

function supplierDue($supplierid = 0)
{
    $supplier_id = $supplierid;
    $supplierLedger = AccountTransaction::where('account_id', "!=", 14)->selectRaw('SUM(debit) as debit,SUM(credit) as credit,account_id');

    $authcheck = auth()->user()->type;

    if ($authcheck != "Admin") {
        $supplierLedger =  $supplierLedger->where('created_by', auth()->id());
    }

    if ($supplier_id != 0) {
        $supplierLedger =  $supplierLedger->where('supplier_id', $supplier_id);
    } else {
        $supplierLedger =  $supplierLedger->whereNotNull('supplier_id');
    }
    $supplierLedger =  $supplierLedger->first();
    return $supplierLedger->debit - $supplierLedger->credit;
}

function customerDue($customer = 0)
{
    $accountIds = getOldAccount([getAccountByUniqueID(5)->id])->pluck('id');

    $customerLedger = AccountTransaction::whereIn('account_id', $accountIds)
        ->selectRaw('SUM(debit) as debit, SUM(credit) as credit')
        ->first();

    return  $customerLedger->debit - $customerLedger->credit ;
}



// function getSubAccount($id = [])
// {
//     $arraytoString = implode(',', $id);
//     $sql = "SELECT  id from `chart_of_accounts` where `parent_id` in ($arraytoString)";
//     $ids = DB::select($sql);
//     $data_array = array();
//     // Fetch data and store it in the array
//     foreach ($ids as $result) {
//         $data_array[] = $result->id;
//     }
//     $marge = array_merge($data_array, $id);
//     if (count($ids) > 0) {
//         return getOldAccount($marge);
//     }
//     return $id;
// }

// function getOldAccount($id = [])
// {
//     $arraytoString = getSubAccount($id);
//     $sql = "SELECT  id from `chart_of_accounts` where `parent_id` in ($arraytoString)";
//     $ids = DB::select($sql);
//     $data_array = array();
//     // Fetch data and store it in the array
//     foreach ($ids as $result) {
//         $data_array[] = $result->id;
//     }
//     $marge = array_merge($data_array, $id);
//     if (count($ids) > 0) {
//         return getOldAccount($marge);
//     }
//     return $id;
// }

function getTypeOfAccount($id = [], $oldIds = [])
{


    $ids = ChartOfAccount::whereIn('parent_id', $id)->pluck('id')->toArray();
    if ($ids) {
        $marge = array_merge($ids, $oldIds);
        return getTypeOfAccount($ids, $marge);
    }
    return $oldIds;
}

function getOldAccount($id = null)
{
    $id = getAccountByUniqueID($id)->id;
    $account_list =  ChartOfAccount::where('status', 'Active');
    if ($id) {
        $account_list = $account_list->whereIn('id', getTypeOfAccount([$id]))->orWhereIn("id", [$id]);
    }
    // $account_list = $account_list->where('company_id', auth()->user()->company_id);
    return $account_list;
}

function account_with_name($transaction)
{
    $name = "";

    $account =  ($transaction->account->account_name ?? "Opening Balance") . " " . $name;

    return $account;
}

function accountledger($id, $text)
{
    if ($id != 0) {
        $url = route('report.ledger.accountledger', ['account_id' => $id]);
        $a_tag = "<a href='$url'>$text</a>";
    } else {
        $a_tag = $text;
    }

    return $a_tag;
}

function rootvoucher($id, $text)
{
    if ($id != 0) {
        $url = route('report.ledger.accountledger', ['account_id' => $id]);
        $a_tag = "<a href='$url'>$text</a>";
    } else {
        $a_tag = $text;
    }

    return $a_tag;
}

function numf($number)
{
    $formate = $number;
    if (0 > $formate) {
        $abs = abs($formate);
        $formate = "(" . number_format($abs, 2) . ")";
    } else {
        $formate = number_format($formate, 2);
    }


    return $formate;
}


function getAllSubAccounts($parentId)
{
    $subAccounts = ChartOfAccount::where('parent_id', $parentId)->get();
    $allAccounts = [];

    foreach ($subAccounts as $subAccount) {
        $allAccounts[] = $subAccount;
        $allAccounts = array_merge($allAccounts, getAllSubAccounts($subAccount->id));
    }

    return $allAccounts;
}

function getAccountByUniqueID($uid)
{
    return ChartOfAccount::firstWhere('unique_identifier', $uid);
}


function getAccountIdsToArray()
{
    $args = func_get_args();

    // Initialize an array to hold account IDs
    $accountIds = [];

    // Loop through each argument
    foreach ($args as $uniqueID) {
        if (is_array($uniqueID)) {
            $accountIds =  array_merge($accountIds, $uniqueID);
        } elseif (is_int($uniqueID)) {
            $accountId = getAccountByUniqueID($uniqueID)->id;
            array_push($accountIds, $accountId);
        }
        // Retrieve the account ID based on the unique ID and add it to the array
    }
    return $accountIds;
}

// Helper function to calculate account balance
function calculateBalance($accountId, $startDate, $endDate)
{
    $openingBalance = DB::table('chart_of_accounts')
        ->where('id', $accountId)
        ->select('opening_balance', 'balance_type')
        ->first();

    $transactions = DB::table('account_transactions')
        ->where('account_id', $accountId)
        ->whereBetween('created_at', [$startDate, $endDate])
        ->select(DB::raw('SUM(debit) as total_debit'), DB::raw('SUM(credit) as total_credit'))
        ->first();

    $balance = ($transactions->total_credit ?? 0) - ($transactions->total_debit ?? 0);
    if ($openingBalance->balance_type == 'debit') {
        $balance += $openingBalance->opening_balance;
    } else {
        $balance -= $openingBalance->opening_balance;
    }

    return $balance;
}
