<?php

use Illuminate\Support\Facades\Route;


Route::group(['prefix' => 'admin', 'namespace' => 'Backend'], function () {
    // Sale setup crud start
    Route::group(['middleware' => ['web', 'auth'], 'namespace' => 'Production'], function () {
        //Sale crud operation start
        Route::get('/production-production-list', 'ProductionController@index')->name('production.production.index');
        Route::get('/dataProcessingProduction', 'ProductionController@dataProcessingProduction')->name('production.production.dataProcessingProduction');
        Route::get('/production-production-create', 'ProductionController@create')->name('production.production.create');
        Route::post('/production-production-store', 'ProductionController@store')->name('production.production.store');
        Route::get('/production-production-edit/{id}', 'ProductionController@edit')->name('production.production.edit');
        Route::get('/production-production-show/{id}', 'ProductionController@show')->name('production.production.show');
        Route::post('/production-production-update/{id}', 'ProductionController@update')->name('production.production.update');
        Route::get('/production-production-delete/{id}', 'ProductionController@destroy')->name('production.production.destroy');
        Route::get('/production-production-status/{id}/{status}', 'ProductionController@statusUpdate')->name('production.production.status');
        Route::get('/production-production-details', 'ProductionController@getProductionDetails')->name('production.production.getProductionDetails');

        // new production
        Route::get('/getProductListForThisBranchWise', 'ProductionController@getProductListForThisBranchWise')->name('production.production.getProductListForThisBranchWise');
        Route::get('/getCurrentStockAndRateofThisProduct', 'ProductionController@getCurrentStockAndRateofThisProduct')->name('production.production.getCurrentStockAndRateofThisProduct');
        Route::get('/getToProPrice', 'ProductionController@getToProPrice')->name('production.production.getToProPrice');
        Route::get('/purchaseDetailsByProduct', 'ProductionController@purchaseDetailsByProduct')->name('production.production.purchaseDetailsByProduct');


        //production crud operation start
        Route::get('/production-setup-list', 'ProductionSetupController@index')->name('production.setup.index');
        Route::get('/dataProcessingproductionsetup', 'ProductionSetupController@dataProcessin')->name('production.setup.dataProcessing');
        Route::get('/production-setup-create', 'ProductionSetupController@create')->name('production.setup.create');
        Route::post('/production-setup-store', 'ProductionSetupController@store')->name('production.setup.store');
        Route::get('/production-setup-edit/{id}', 'ProductionSetupController@edit')->name('production.setup.edit');
        Route::get('/production-setup-show/{id}', 'ProductionSetupController@show')->name('production.setup.show');
        Route::get('/production-setup-loadmanager', 'ProductionSetupController@loadmanager')->name('production.setup.loadmanager');
        Route::post('/production-setup-complete', 'ProductionSetupController@complete')->name('production.setup.complete');
        Route::post('/production-setup-update/{id}', 'ProductionSetupController@update')->name('production.setup.update');
        Route::get('/production-setup-delete/{id}', 'ProductionSetupController@destroy')->name('production.setup.destroy');
        Route::get('/production-setup-status/{id}/{status}', 'ProductionSetupController@statusUpdate')->name('production.setup.status');
        //production crud operation end

        //production  crud operation start
        Route::get('/production-requsition-list', 'ProductionRequsitionController@index')->name('production.requsition.index');
        Route::get('/dataProcessingproduction-requsition', 'ProductionRequsitionController@dataProcessin')->name('production.requsition.dataProcessing');
        Route::get('/production-requsition-create', 'ProductionRequsitionController@create')->name('production.requsition.create');
        Route::post('/production-requsition-store', 'ProductionRequsitionController@store')->name('production.requsition.store');
        Route::get('/production-requsition-edit/{id}', 'ProductionRequsitionController@edit')->name('production.requsition.edit');
        Route::get('/production-requsition-show/{id}', 'ProductionRequsitionController@show')->name('production.requsition.show');
        Route::get('/production-requsition-loadmanager', 'ProductionRequsitionController@loadmanager')->name('production.requsition.loadmanager');
        Route::post('/production-requsition-complete', 'ProductionRequsitionController@complete')->name('production.requsition.complete');
        Route::post('/production-requsition-update/{id}', 'ProductionRequsitionController@update')->name('production.requsition.update');
        Route::get('/production-requsition-delete/{id}', 'ProductionRequsitionController@destroy')->name('production.requsition.destroy');
        Route::get('/production-requsition-status/{id}/{status}', 'ProductionRequsitionController@statusUpdate')->name('production.requsition.status');
        Route::get('production/requsition/details', 'ProductionRequsitionController@getProductionDetails')->name('production.requsition.getProductionDetails');
        //production crud operation end


        //production  crud operation start
        Route::get('/production-requsition-list', 'ProductionRequsitionController@index')->name('production.requsition.index');
        Route::get('/dataProcessingproduction-requsition', 'ProductionRequsitionController@dataProcessin')->name('production.requsition.dataProcessing');
        Route::get('/production-requsition-create', 'ProductionRequsitionController@create')->name('production.requsition.create');
        Route::post('/production-requsition-store', 'ProductionRequsitionController@store')->name('production.requsition.store');
        Route::get('/production-requsition-edit/{id}', 'ProductionRequsitionController@edit')->name('production.requsition.edit');
        Route::get('/production-requsition-show/{id}', 'ProductionRequsitionController@show')->name('production.requsition.show');
        Route::get('/production-requsition-loadmanager', 'ProductionRequsitionController@loadmanager')->name('production.requsition.loadmanager');
        Route::post('/production-requsition-complete', 'ProductionRequsitionController@complete')->name('production.requsition.complete');
        Route::post('/production-requsition-update/{id}', 'ProductionRequsitionController@update')->name('production.requsition.update');
        Route::get('/production-requsition-delete/{id}', 'ProductionRequsitionController@destroy')->name('production.requsition.destroy');
        Route::get('/production-requsition-status/{id}/{status}', 'ProductionRequsitionController@statusUpdate')->name('production.requsition.status');
        Route::get('production/requsition/details', 'ProductionRequsitionController@getProductionDetails')->name('production.requsition.getProductionDetails');
        //production crud operation end

        //production  crud operation start
        Route::get('/production-requsition-approval-list', 'ProductionRequsitionApprovalController@index')->name('production.requsition.approval.index');
        Route::get('/dataProcessingproduction-requsition-approval', 'ProductionRequsitionApprovalController@dataProcessin')->name('production.requsition.approval.dataProcessing');
        Route::get('/production-requsition-approval-create', 'ProductionRequsitionApprovalController@create')->name('production.requsition.approval.create');
        Route::post('/production-requsition-approval-store', 'ProductionRequsitionApprovalController@store')->name('production.requsition.approval.store');
        Route::get('/production-requsition-approval-edit/{id}', 'ProductionRequsitionApprovalController@edit')->name('production.requsition.approval.edit');
        Route::get('/production-requsition-approval-show/{id}', 'ProductionRequsitionApprovalController@show')->name('production.requsition.approval.show');
        Route::get('/production-requsition-approval-loadmanager', 'ProductionRequsitionApprovalController@loadmanager')->name('production.requsition.approval.loadmanager');
        Route::post('/production-requsition-approval-complete', 'ProductionRequsitionApprovalController@complete')->name('production.requsition.approval.complete');
        Route::post('/production-requsition-approval-update/{id}', 'ProductionRequsitionApprovalController@update')->name('production.requsition.approval.update');
        Route::get('/production-requsition-approval-delete/{id}', 'ProductionRequsitionApprovalController@destroy')->name('production.requsition.approval.destroy');
        Route::get('/production-requsition-approval-status/{id}/{status}', 'ProductionRequsitionApprovalController@statusUpdate')->name('production.requsition.approval.status');
        Route::get('production/requsition/approval/details', 'ProductionRequsitionApprovalController@getProductionDetails')->name('production.requsition.approval.getProductionDetails');
        Route::post('production/requsition/approval/check-stock', 'ProductionRequsitionApprovalController@checkStock')->name('production.requsition.approvalcheck.stock');
        //production crud operation end

    });
});
