@extends('backend.layouts.master')

@section('title')
    Settings - {{ $title }}
@endsection


@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Inventory </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        @if (helper::roleAccess('sale.sale.index'))
                            <li class="breadcrumb-item"><a href="{{ route('sale.sale.index') }}">Category
                                    List</a></li>
                        @endif
                        <li class="breadcrumb-item active"><span>Edit Category</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Sale Return </h3>
                    <div class="card-tools">
                        @if (helper::roleAccess('sale.sale.create'))
                            {{-- <a class="btn btn-default" href="{{ route('sale.sale.create') }}"><i
                            class="fas fa-plus"></i>
                        Add New</a> --}}
                        @endif
                        <span id="buttons"></span>

                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <form class="needs-validation" method="POST" action="{{ route('sale.salereturn.store') }}" novalidate>
                        @csrf
                        <div class="form-row">
                            <div class="col-md-2 mb-3">
                                <label for="validationCustom01">Invoice Number :</label>
                                {{-- <input class=" form-control"
                                style="padding: 5px; font-weight : bold; width: 100%"
                                value="" for="validationCustom01">
                            <input type="hidden" name="invoice_no" class="form-control" id=""
                                value=""> --}}

                                <select name="invoice_no" class="form-control select2" id="invoiceNo">
                                    <option value="">Please Select Invoice No</option>
                                    @foreach ($sales as $sale)
                                        <option value="{{ $sale->id }}">{{ $sale->invoice_no }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-2 mb-3">
                                <label>Po Date:</label>
                                <div class="input-group date" id="reservationdate1" data-target-input="nearest">
                                    <input type="text" name="po_date" data-toggle="datetimepicker"
                                        value="{{ date('YYYY-mm-dd') }}" class="form-control datetimepicker-input"
                                        data-target="#reservationdate1" />
                                    <div class="input-group-append" data-target="#reservationdate1"
                                        data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                @error('date')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-2 mb-3">
                                <label>Date:</label>
                                <div class="input-group date" id="reservationdate" data-target-input="nearest">
                                    <input type="text" name="date" data-toggle="datetimepicker" value=""
                                        id="saleDate" readonly class="form-control datetimepicker-input"
                                        data-target="#reservationdate" />
                                    <div class="input-group-append" data-target="#reservationdate"
                                        data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                @error('date')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-2 mb-3">
                                <label for="validationCustom01">Branch * :</label>
                                @php
                                    $sub_branch = App\Models\Branch::get();
                                @endphp
                                <select class="form-control select2" id="branch_id" name="branch_id">
                                    <option selected disabled value="">--Select Branch--</option>
                                    @foreach ($branch as $key => $value)
                                        <option value="{{ $value->id }}">
                                            {{ $value->branchCode . ' - ' . $value->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('branch_id')
                                    <span class="error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-2 mb-3">
                                <label for="validationCustom02">Sub-Warehouse * :</label>
                                <select class="form-control select2" id="sub_warehouse_id" name="sub_warehouse_id">
                                    <option selected disabled value="">--Select Sub-Warehouse--</option>
                                    @foreach ($wearhouses as $key => $value)
                                        <option value="{{ $value->id }}">
                                            {{ $value->branchCode . ' - ' . $value->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <!-- Loading spinner -->
                                <div id="loadingSpinner" style="display:none;">
                                    <img src="https://i.pinimg.com/originals/5c/87/9a/5c879ab8cba794923686df4b950f497b.gif"
                                        alt="Loading..." width="10%" />
                                </div>
                                @error('sub_warehouse_id')
                                    <span class="error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>


                            <div class="col-md-2 mb-3">
                                <label for="ledger_id">Ledger * :


                                </label>
                                <input class="form-control " type="hidden" name="ledger_id" id="ledger_id" value="">
                                <input class="form-control " type="hidden" name="sale_id" id="saleId" value="">
                                <input class="form-control " type="text" readonly name="ledger_name" id="ledger_name"
                                    value="">

                                @error('ledger_id')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-2 mb-3">
                                <label for="validationCustom01">Payment Type * :</label>
                                <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                    <label class="btn bg-olive">
                                        <input type="radio" name="payment_type" value="Due"
                                            onchange="getCustomerBalance('Due')" checked id="option3" autocomplete="off"> Due
                                    </label>

                                </div>
                                <input type="hidden" id="paymentType">
                                <input type="hidden" id="expireData">
                                <input type="hidden" id="paymentypeValue" value="">
                            </div>
                            <table class=" table-responsive table table-bordered">
                                <tr>
                                    <td>
                                        <div class="col-md-9 float-left ">
                                            Sales Item
                                        </div>
                                        <div class="col-md-3 float-right">
                                            Payment Calculation
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px!important;" id="invoiceData">


                                    </td>
                                </tr>
                                <tr>

                                </tr>
                                <tr>
                                    <td>
                                        <div class="clearfix"></div>
                                        <div class="clearfix form-actions float-right">
                                            <div class="col-md-offset-1 col-md-10">
                                                <button class="btn btn-info" id="subMitButton" type="submit">
                                                    Save
                                                </button>
                                                &nbsp; &nbsp; &nbsp;

                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            </table>





                        </div>

                    </form>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>



    <script type="text/javascript">
        // Enhanced JavaScript solution for sales form with complete return calculation system
        // Handles quantity, total, subtotal, VAT, discounts, and all related calculations

        $(document).ready(function() {
            // Initialize calculations on page load
            initializeCalculations();

            // Handle return quantity changes
            $(document).on('input', '.new-qty', function() {
                handleReturnQuantityChange($(this));
            });

            // Handle return quantity blur event for validation
            $(document).on('blur', '.new-qty', function() {
                validateReturnQuantity($(this));
            });

            // Other existing handlers...
            $('#disCount').on('input', function() {
                discountCalculation($(this).val());
            });

            $('#carrying_cost').on('input', function() {
                carrying_cost_Calculation($(this).val());
            });

            $('#labor_bill').on('input', function() {
                labor_bill_Calculation($(this).val());
            });
        });

        // Initialize calculations on page load
        function initializeCalculations() {
            console.log('Initializing return calculations...');
            updateAllReturnCalculations();
            recalculateNetTotal();
        }

        // Enhanced return quantity change handler
        function handleReturnQuantityChange($input) {
            const $row = $input.closest('tr');
            const returnQty = parseFloat($input.val()) || 0;
            const originalQty = parseFloat($row.find('input[name="qty[]"]').val()) || 0;
            const unitPrice = parseFloat($row.find('input[name="unitprice[]"]').val()) || 0;
            const vatRate = parseFloat($row.find('input[name="vat[]"]').val()) || 0;

            // Validate return quantity
            if (returnQty > originalQty) {
                showAlert('Return quantity cannot be greater than original quantity', 'error');
                $input.val(originalQty);
                return;
            }

            if (returnQty < 0) {
                showAlert('Return quantity cannot be negative', 'error');
                $input.val(0);
                return;
            }

            // Calculate return values
            const returnCalculation = calculateReturnValues(returnQty, unitPrice, vatRate);

            // Calculate effective values (after return)
            const effectiveQty = originalQty - returnQty;
            const effectiveCalculation = calculateReturnValues(effectiveQty, unitPrice, vatRate);

            // Update row display
            updateRowReturnDisplay($row, {
                originalQty,
                returnQty,
                effectiveQty,
                unitPrice,
                vatRate,
                returnCalculation,
                effectiveCalculation
            });

            // Update the hidden input for the effective total (what customer actually pays)
            $row.find('input[name="price[]"]').val(effectiveCalculation.totalWithVat.toFixed(2));

            // Update the return total input
            $row.find('.grandQtytotal').val(returnCalculation.totalWithVat.toFixed(2));

            // Update all totals
            updateAllReturnCalculations();

            console.log('Return calculation completed:', {
                returnQty,
                returnSubtotal: returnCalculation.subtotal,
                returnVat: returnCalculation.vatAmount,
                returnTotal: returnCalculation.totalWithVat,
                effectiveQty,
                effectiveTotal: effectiveCalculation.totalWithVat
            });
        }

        // Calculate return values (subtotal, VAT, total)
        function calculateReturnValues(quantity, unitPrice, vatRate) {
            const subtotal = quantity * unitPrice;
            const vatAmount = (vatRate / 100) * subtotal;
            const totalWithVat = subtotal + vatAmount;

            return {
                subtotal: subtotal,
                vatAmount: vatAmount,
                totalWithVat: totalWithVat
            };
        }

        // Update row display with return information
        function updateRowReturnDisplay($row, data) {
            const {
                originalQty,
                returnQty,
                effectiveQty,
                unitPrice,
                vatRate,
                returnCalculation,
                effectiveCalculation
            } = data;

            // Update quantity display (assuming quantity is in 4th column)
            const $qtyCell = $row.find('td').eq(5);
            if (returnQty > 0) {
                $qtyCell.html(`
            <div class="qty-breakdown">
                <div class="original-qty">Original: <strong>${originalQty}</strong></div>
                <div class="return-qty text-danger">Return: <strong>${returnQty}</strong></div>
                <div class="effective-qty text-success">Effective: <strong>${effectiveQty}</strong></div>
            </div>
            <input type="hidden" name="qty[]" value="${originalQty}">
        `);
            } else {
                $qtyCell.html(`
            <strong>${originalQty}</strong>
            <input type="hidden" name="qty[]" value="${originalQty}">
        `);
            }

            // Update total display (assuming total is in 8th column)
            const $totalCell = $row.find('td').eq(9);
            if (returnQty > 0) {
                $totalCell.html(`
            <div class="total-breakdown">
                <div class="effective-total text-success">
                    Pay: <strong>${effectiveCalculation.totalWithVat.toFixed(2)}</strong>
                </div>
                <div class="return-total text-danger">
                    Return: <strong>${returnCalculation.totalWithVat.toFixed(2)}</strong>
                </div>
            </div>
            <input type="hidden" class="grandtotal" name="price[]" value="${effectiveCalculation.totalWithVat}">
            <input type="hidden" class="grandQtytotal" name="grandQtytotal[]" value="${returnCalculation.totalWithVat}">
        `);
            } else {
                const originalTotal = calculateReturnValues(originalQty, unitPrice, vatRate);
                $totalCell.html(`
            <strong>${originalTotal.totalWithVat.toFixed(2)}</strong>
            <input type="hidden" class="grandtotal" name="price[]" value="${originalTotal.totalWithVat}">
            <input type="hidden" class="grandQtytotal" name="grandQtytotal[]" value="0">
        `);
            }
        }

        // Validate return quantity
        function validateReturnQuantity($input) {
            const returnQty = parseFloat($input.val()) || 0;
            const $row = $input.closest('tr');
            const originalQty = parseFloat($row.find('input[name="qty[]"]').val()) || 0;

            if (returnQty > originalQty) {
                $input.val(originalQty);
                handleReturnQuantityChange($input);
            }
        }

        // Update all return calculations and totals
        function updateAllReturnCalculations() {
            console.log('Updating all return calculations...');

            const totals = {
                originalQty: 0,
                returnQty: 0,
                effectiveQty: 0,
                originalSubtotal: 0,
                returnSubtotal: 0,
                effectiveSubtotal: 0,
                originalVat: 0,
                returnVat: 0,
                effectiveVat: 0,
                originalTotal: 0,
                returnTotal: 0,
                effectiveTotal: 0
            };

            // Calculate totals for each row
            $('#show_item tbody tr').each(function() {
                const $row = $(this);
                const originalQty = parseFloat($row.find('input[name="qty[]"]').val()) || 0;
                const returnQty = parseFloat($row.find('.new-qty').val()) || 0;
                const unitPrice = parseFloat($row.find('input[name="unitprice[]"]').val()) || 0;
                const vatRate = parseFloat($row.find('input[name="vat[]"]').val()) || 0;

                if (originalQty > 0) {
                    const effectiveQty = originalQty - returnQty;

                    // Calculate for original, return, and effective quantities
                    const originalCalc = calculateReturnValues(originalQty, unitPrice, vatRate);
                    const returnCalc = calculateReturnValues(returnQty, unitPrice, vatRate);
                    const effectiveCalc = calculateReturnValues(effectiveQty, unitPrice, vatRate);

                    // Add to totals
                    totals.originalQty += originalQty;
                    totals.returnQty += returnQty;
                    totals.effectiveQty += effectiveQty;

                    totals.originalSubtotal += originalCalc.subtotal;
                    totals.returnSubtotal += returnCalc.subtotal;
                    totals.effectiveSubtotal += effectiveCalc.subtotal;

                    totals.originalVat += originalCalc.vatAmount;
                    totals.returnVat += returnCalc.vatAmount;
                    totals.effectiveVat += effectiveCalc.vatAmount;

                    totals.originalTotal += originalCalc.totalWithVat;
                    totals.returnTotal += returnCalc.totalWithVat;
                    totals.effectiveTotal += effectiveCalc.totalWithVat;
                }
            });

            // Update footer displays
            updateFooterTotals(totals);

            // Update grand totals
            updateGrandTotals(totals);

            // Recalculate net total
            recalculateNetTotal();

            console.log('Return calculations completed:', totals);

            return totals;
        }

        // Update footer totals
        function updateFooterTotals(totals) {
            // Update quantity footer
            const $qtyFooter = $('#show_item tfoot tr td:eq(5)');
            if (totals.returnQty > 0) {
                $qtyFooter.html(`
            <div class="footer-qty-summary">
                <div>Original: <strong>${totals.originalQty}</strong></div>
                <div class="text-danger">Return: <strong>${totals.returnQty}</strong></div>
                <div class="text-success">Effective: <strong>${totals.effectiveQty}</strong></div>
            </div>
        `);
            } else {
                $qtyFooter.html(`<strong>${totals.originalQty}</strong>`);
            }

            // Update total footer
            const $totalFooter = $('#show_item tfoot tr td:eq(9)');
            if (totals.returnTotal > 0) {
                $totalFooter.html(`
            <div class="footer-total-summary">
                <div class="text-success">Pay: <strong>${totals.effectiveTotal.toFixed(2)}</strong></div>
                <div class="text-danger">Return: <strong>${totals.returnTotal.toFixed(2)}</strong></div>
            </div>
            <input type="hidden" name="grandItemReturnTotal" value="${totals.returnTotal.toFixed(2)}" class="grandItemReturnTotal">
        `);
            } else {
                $totalFooter.html(`
            <strong class="grandItemTotal">${totals.originalTotal.toFixed(2)}</strong>
            <input type="hidden" name="grandItemReturnTotal" value="0" class="grandItemReturnTotal">
        `);
            }
        }

        // Update grand totals in the summary section
        function updateGrandTotals(totals) {
            // Update main total (what customer pays)
            $('#gtoal').text(totals.effectiveTotal.toFixed(2));
            $('.grandItemTotal').text(totals.effectiveTotal.toFixed(2));

            // Update return total
            $('.grandtotalReturn').text(totals.returnTotal.toFixed(2));
            $('input[name="grandtotalReturn"]').val(totals.returnTotal.toFixed(2));
        }

        // Recalculate net total with discounts and additional costs
        function recalculateNetTotal() {
            const grandTotal = parseFloat($('#gtoal').text()) || 0;
            const discount = parseFloat($('#disCount').val()) || 0;
            const carryingCost = parseFloat($('#carrying_cost').val()) || 0;
            const laborBill = parseFloat($('#labor_bill').val()) || 0;

            const netTotal = grandTotal - discount + carryingCost + laborBill;

            $('#ntotal').text(netTotal.toFixed(2));
            updateDueAmount(netTotal);

            console.log('Net total recalculated:', {
                grandTotal,
                discount,
                carryingCost,
                laborBill,
                netTotal
            });
        }

        // Update due amount
        function updateDueAmount(netTotal) {
            const payment = parseFloat($('#payment').val()) || 0;
            const totalDue = netTotal - payment;
            $('#totalDue').text(totalDue.toFixed(2));
            $('.finalDue').text(totalDue.toFixed(2));
        }

        // Get all return data for form submission
        function getAllReturnData() {
            const returnData = {
                items: [],
                totals: {
                    totalReturnQty: 0,
                    totalReturnAmount: 0,
                    totalEffectiveAmount: 0
                }
            };

            $('#show_item tbody tr').each(function() {
                const $row = $(this);
                const salesDetailsId = $row.find('input[name="sales_details_id[]"]').val();
                const originalQty = parseFloat($row.find('input[name="qty[]"]').val()) || 0;
                const returnQty = parseFloat($row.find('.new-qty').val()) || 0;
                const unitPrice = parseFloat($row.find('input[name="unitprice[]"]').val()) || 0;
                const vatRate = parseFloat($row.find('input[name="vat[]"]').val()) || 0;

                if (returnQty > 0) {
                    const returnCalc = calculateReturnValues(returnQty, unitPrice, vatRate);
                    const effectiveQty = originalQty - returnQty;
                    const effectiveCalc = calculateReturnValues(effectiveQty, unitPrice, vatRate);

                    returnData.items.push({
                        salesDetailsId: salesDetailsId,
                        originalQty: originalQty,
                        returnQty: returnQty,
                        effectiveQty: effectiveQty,
                        unitPrice: unitPrice,
                        vatRate: vatRate,
                        returnSubtotal: returnCalc.subtotal,
                        returnVat: returnCalc.vatAmount,
                        returnTotal: returnCalc.totalWithVat,
                        effectiveTotal: effectiveCalc.totalWithVat
                    });

                    returnData.totals.totalReturnQty += returnQty;
                    returnData.totals.totalReturnAmount += returnCalc.totalWithVat;
                    returnData.totals.totalEffectiveAmount += effectiveCalc.totalWithVat;
                }
            });

            return returnData;
        }

        // Enhanced discount calculation
        function discountCalculation(discountAmount) {
            const grandTotal = parseFloat($('#gtoal').text()) || 0;
            const discount = parseFloat(discountAmount) || 0;

            if (discount > grandTotal) {
                showAlert("Discount cannot be greater than total amount", 'error');
                $('#disCount').val(0);
                recalculateNetTotal();
                return;
            }

            if (discount < 0) {
                showAlert("Discount cannot be negative", 'error');
                $('#disCount').val(0);
                recalculateNetTotal();
                return;
            }

            recalculateNetTotal();
        }

        // Enhanced carrying cost calculation
        function carrying_cost_Calculation(amount) {
            const carryingCost = parseFloat(amount) || 0;

            if (carryingCost < 0) {
                showAlert("Carrying cost cannot be negative", 'error');
                $('#carrying_cost').val(0);
                recalculateNetTotal();
                return;
            }

            recalculateNetTotal();
        }

        // Enhanced labor bill calculation
        function labor_bill_Calculation(amount) {
            const laborBill = parseFloat(amount) || 0;

            if (laborBill < 0) {
                showAlert("Labor bill cannot be negative", 'error');
                $('#labor_bill').val(0);
                recalculateNetTotal();
                return;
            }

            recalculateNetTotal();
        }

        // Enhanced payment calculation
        function paymentCalculation(paymentAmount) {
            const payment = parseFloat(paymentAmount) || 0;
            const netTotal = parseFloat($('#ntotal').text()) || 0;

            if (payment < 0) {
                showAlert("Payment cannot be negative", 'error');
                $('#payment').val(0);
                updateDueAmount(netTotal);
                return;
            }

            updateDueAmount(netTotal);
        }

        // Show alert function
        function showAlert(message, type = 'info') {
            console.log(`[${type.toUpperCase()}] ${message}`);

            if (typeof alertMessage !== 'undefined') {
                switch (type) {
                    case 'error':
                        alertMessage.error(message);
                        break;
                    case 'success':
                        alertMessage.success(message);
                        break;
                    case 'warning':
                        alertMessage.warning(message);
                        break;
                    case 'info':
                    default:
                        alertMessage.info(message);
                        break;
                }
            } else {
                alert(message);
            }
        }

        // Form submission handler
        $(document).on('submit', 'form', function(e) {
            const returnData = getAllReturnData();

            if (returnData.items.length > 0) {
                console.log('Return data being submitted:', returnData);

                // Add return data to form
                $(this).append(`<input type="hidden" name="return_data" value='${JSON.stringify(returnData)}'>`);
            }
        });

        $(document).ready(function() {
            $('#invoiceNo').on('change', function() {
                var invoiceId = $(this).val();

                if (invoiceId) {
                    $.ajax({
                        url: "{{ url('/admin/get-sale-info') }}/" + invoiceId,
                        type: "GET",
                        dataType: "json",
                        success: function(response) {
                            let saleInfo = response.saleInfo;
                            $('#invoiceData').html(response.htmlData);
                            $('#tableFooter').html(response.htmlDataFooter);
                            $('#tableSubtotal').html(response.htmlDataSubtotal);
                            $('#ledger_name').val(response.ledger ? response.ledger
                                .account_name : '');
                            $('#ledger_id').val(response.ledger ? response.ledger.id : '');
                            $('#saleDate').val(saleInfo ? saleInfo.date : '');
                            $('#saleId').val(saleInfo ? saleInfo.id : '');


                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                }
            });
        });
    </script>
@endsection
