@extends('backend.layouts.master')

@section('title')
    Settings - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
           .table td, .table th {
        padding: 0 !important;
    }
    </style>
@endsection
@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Inventory </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        @if (helper::roleAccess('sale.sale.index'))
                            <li class="breadcrumb-item"><a href="{{ route('sale.sale.index') }}">Category
                                    List</a></li>
                        @endif
                        <li class="breadcrumb-item active"><span>Edit Category</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Sale Edit</h3>
                    <div class="card-tools">
                        @if (helper::roleAccess('sale.sale.create'))
                            <a class="btn btn-default" href="{{ route('sale.sale.create') }}"><i class="fas fa-plus"></i>
                                Add New</a>
                        @endif
                        <span id="buttons"></span>

                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <form class="needs-validation" method="POST" action="{{ route('sale.sale.update', $saletlist->id) }}"
                        novalidate>
                        @csrf
                        <div class="form-row">
                            <div class="col-md-2 mb-3">
                                <label for="validationCustom01">Invoice Number :</label>
                                <input class="bg-green form-control" readonly=""
                                    style="padding: 5px; font-weight : bold; width: 100%"
                                    value="{{ $saletlist->invoice_no }} " for="validationCustom01">
                                <input type="hidden" name="invoice_no" class="form-control" id=""
                                    value="{{ $saletlist->invoice_no }}">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label for="validationCustom01">Po Number :</label>
                                <input type="text" name="po_invoice" class="form-control"
                                    value="{{ $saletlist->po_invoice }}">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label>Po Date:</label>
                                <div class="input-group date" id="reservationdate1" data-target-input="nearest">
                                    <input type="text" name="po_date" data-toggle="datetimepicker"
                                        value="{{ date('YYYY-mm-dd') }}" class="form-control datetimepicker-input"
                                        data-target="#reservationdate1" />
                                    <div class="input-group-append" data-target="#reservationdate1"
                                        data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                @error('date')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-2 mb-3">
                                <label>Date:</label>
                                <div class="input-group date" id="reservationdate" data-target-input="nearest">
                                    <input type="text" name="date" data-toggle="datetimepicker"
                                        value="{{ $saletlist->date }}" class="form-control datetimepicker-input"
                                        data-target="#reservationdate" />
                                    <div class="input-group-append" data-target="#reservationdate"
                                        data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                @error('date')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-2 mb-3">
                                <label for="validationCustom01">Branch * :</label>
                                @php
                                    $sub_branch = App\Models\Branch::find($saletlist->branch_id);
                                @endphp
                                <select class="form-control select2" id="branch_id" name="branch_id">
                                    <option selected disabled value="">--Select Branch--</option>
                                    @foreach ($branch as $key => $value)
                                        <option value="{{ $value->id }}"
                                            {{ $sub_branch->parent_id == $value->id ? 'selected' : '' }}>
                                            {{ $value->branchCode . ' - ' . $value->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('branch_id')
                                    <span class="error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-2 mb-3">
                                <label for="validationCustom02">Sub-Warehouse * :</label>
                                <select class="form-control select2" id="sub_warehouse_id" name="sub_warehouse_id">
                                    <option selected disabled value="">--Select Sub-Warehouse--</option>
                                    @foreach ($subWarehouses as $subWarehouse)
                                        <option value="{{ $subWarehouse->id }}"
                                            {{ $subWarehouse->id == $saletlist->branch_id ? 'selected' : '' }}>
                                            {{ $subWarehouse->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <!-- Loading spinner -->
                                <div id="loadingSpinner" style="display:none;">
                                    <img src="https://i.pinimg.com/originals/5c/87/9a/5c879ab8cba794923686df4b950f497b.gif"
                                        alt="Loading..." width="10%" />
                                </div>
                                @error('sub_warehouse_id')
                                    <span class="error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>

                            {{-- <div class="col-md-2 mb-3">
                            <label for="validationCustom01">Customer * :</label>
                            <select class="form-control select2" name="customer_id" id="customer_id">
                                <option selected disabled value="">--Select Customer--</option>
                                @foreach ($customer as $key => $value)
                                <option {{ $saletlist->customer_id == $value->id ? 'selected' : '' }}
                                    value="{{ $value->id }}">
                                    {{ $value->customerCode . ' - ' . $value->co_name }}
                                </option>
                                @endforeach
                            </select>
                            @error('customer_id')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div> --}}
                            <div class="col-md-2 mb-3">
                                <label for="ledger_id">Ledger * :

                                    <button type="button" class="btn btn-sm btn-primary ml-2" data-toggle="modal"
                                        data-target="#addCustomerModel">
                                        +
                                    </button>
                                </label>
                                <select class="form-control select2" name="ledger_id" id="ledger_id">
                                    <option selected disabled value="">--Select Ledger--</option>
                                    <x-account :setAccounts="$ledgers" :selectVal="$saletlist->ledger_id" />
                                </select>
                                @error('ledger_id')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                             <div class="col-md-2 mb-3  mt-1">
                                <label for="project_name">Project Name
                                </label>
                                <input type="text" name="project_name" value="{{$saletlist->project_name}}" class="form-control">
                                @error('project_name')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-3 mb-3  mt-1 ">
                                <label for="project_address">Project Address
                                </label>
                                <input type="text" name="project_address" value="{{$saletlist->project_address}}" class="form-control">
                                @error('project_address')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-2 mb-3 mt-1">
                                <label for="validationCustom01">Balance * :</label>
                                <input type="text" id="customer_currentBalance" class="form-control" readonly>
                            </div>
                            <div class="col-md-2 mb-3">
                                <label for="validationCustom01">Payment Type * :</label>
                                <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                    {{-- <label class="btn bg-olive active">
                                    <input type="radio" name="payment_type" value="Cash"
                                        onchange="getCustomerBalance('Cash')" id="option1" {{$saletlist->payment_type ==
                                    "Cash" ? "checked":""}}> Cash
                                </label> --}}
                                    {{-- <label class="btn bg-olive">
                                    <input type="radio" name="payment_type" value="Deposit"
                                        onchange="getCustomerBalance('Deposit')" id="option2" autocomplete="off"
                                        {{$saletlist->payment_type == "Deposit" ? "checked":""}}>
                                    Deposit
                                </label> --}}
                                    <label class="btn bg-olive">
                                        <input type="radio" name="payment_type" value="Due"
                                            onchange="getCustomerBalance('Due')"
                                            {{ $saletlist->payment_type == 'Due' ? 'checked' : '' }}
                                            id="option3" autocomplete="off"> Due
                                    </label>
                                    {{-- <label class="btn bg-olive">
                                    <input type="radio" name="payment_type" value="Credit"
                                        onchange="getCustomerBalance('Credit')" id="option3" autocomplete="off"
                                        {{$saletlist->payment_type == "Credit" ? "checked":""}}> Credit
                                </label> --}}
                                </div>
                                <input type="hidden" id="paymentType">
                                <input type="hidden" id="expireData">
                                <input type="hidden" id="paymentypeValue" value="{{ $saletlist->payment_type }}">
                            </div>
                            <table class=" table-responsive table table-bordered">
                                <tr>
                                    <td>
                                        <div class="col-md-9 float-left ">
                                            Sales Item
                                        </div>
                                        <div class="col-md-3 float-right">
                                            Payment Calculation
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px!important;">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="col-md-12 float-left">
                                                    <div class="panel panel-default">
                                                        <div class="panel-body">

                                                            <table class="table table-bordered table-hover tableAddItem"
                                                                id="show_item">
                                                                <thead>
                                                                    <tr>
                                                                        <th nowrap align="center" id="">
                                                                            <strong>Product Category <span
                                                                                    style="color:red;">
                                                                                    *</span></strong>
                                                                        </th>
                                                                        <th nowrap align="center" id="">
                                                                            <strong>Product <span style="color:red;">
                                                                                    *</span></strong>
                                                                        </th>
                                                                        <!--<th nowrap align="center">-->
                                                                        <!--    <strong>Type <span style="color:red;">-->
                                                                        <!--            *</span></strong>-->
                                                                        <!--</th>-->

                                                             <td style="width:8%;" class="text-center">
                                                                        <strong>CCT</strong>
                                                                    </td>
                                                                    <td style="width:8%;" class="text-center">
                                                                        <strong>Wattage</strong>
                                                                    </td>
                                                                    <td style="width:8%;" class="text-center"><strong>Body
                                                                            Color</strong></td>

                                                                        <th nowrap style="width:10%" align="center">
                                                                            <strong>Quantity <span style="color:red;">
                                                                                    *</span></strong>
                                                                        </th>
                                                                        <!--<th nowrap style="width:11%" align="center">-->
                                                                        <!--    <strong>Vat <span style="color:red;"></span></strong>-->
                                                                        <!--</th>-->
                                                                        {{-- <th nowrap style="width:11%" align="center">
                                                                        <strong>Gas/Sp-qty <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th> --}}
                                                                        <th nowrap style="width:12%" align="center">
                                                                            <strong>Unit
                                                                                Price(BDT) <span style="color:red;">
                                                                                    *</span></strong>
                                                                        </th>
                                                                        <th nowrap style="width:13%" align="center">
                                                                            <strong>Total Price(BDT) <span
                                                                                    style="color:red;">
                                                                                    *</span></strong>
                                                                        </th>
                                                                        <th align="center" style="width:5%">
                                                                            <strong>Action</strong>
                                                                        </th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr>
                                                                        <td id="product_td">
                                                                            <select onchange="getProductList(this.value)"
                                                                                class="select2 form-control catName"
                                                                                id="form-field-select-3"
                                                                                data-placeholder="Search Category">
                                                                                <option disabled selected>--- Select
                                                                                    Category
                                                                                    ---</option>
                                                                                <?php foreach ($category_info as $eachInfo) : ?>
                                                                                <option catName="{{ $eachInfo->name }}"
                                                                                    value="{{ $eachInfo->id }}">
                                                                                    {{ $eachInfo->name }}</option>

                                                                                <?php endforeach; ?>
                                                                            </select>
                                                                        </td>
                                                                        <td id="product_td">
                                                                            <select class="select2 form-control proName"
                                                                                id="productID"
                                                                                data-placeholder="Search Product"
                                                                                onchange="getUnitPrice(this.value)">
                                                                                <option disabled selected>---Select
                                                                                    Product---
                                                                                </option>
                                                                            </select>
                                                                        </td>
                                                                    

                                                                    <td>
                                                                        <select name="" id=""
                                                                            class="form-control cct select2">

                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <select name="" id=""
                                                                            class="form-control wattage select2">

                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <select name="" id=""
                                                                            class="form-control  bodycolor select2">

                                                                        </select>
                                                                    </td>
                                                                        <td>
                                                                            <input type="text" readonly
                                                                                class="form-control  "
                                                                                style="height: 20px;" id="currentStock"
                                                                                placeholder="0">
                                                                            <input type="text" style="height: 20px;"
                                                                                class="form-control  qty" id="qty"
                                                                                onkeyup="qtyPriceCal();" placeholder="0">
                                                                        </td>
                                                                        {{-- <td>
                                                                        <input type="number" readonly
                                                                            class="form-control" min="0" value="0"
                                                                            id="gas_qty" placeholder="0">
                                                                    </td> --}}
                                                                        <td class="d-none">
                                                                            <input type="text"
                                                                                class="form-control text-right vat"
                                                                                id="vat" onkeyup="qtyPriceCal();"
                                                                                placeholder="0.00">
                                                                        </td>
                                                                        <td>
                                                                            <input type="text"
                                                                                class="form-control text-right  unitprice"
                                                                                id="unitpice" onkeyup="qtyPriceCal();"
                                                                                placeholder="0.00">
                                                                        </td>

                                                                        <td><input type="text"
                                                                                class="form-control text-right ttlamount total"
                                                                                id="total" placeholder="0.00"
                                                                                readonly="readonly"></td>
                                                                        <td>
                                                                            <a id="add_item"
                                                                                class="btn btn-info form-control"
                                                                                href="javascript:;" title="Add Item">
                                                                                <i class="fa fa-plus"></i>
                                                                            </a>
                                                                        </td>
                                                                    </tr>
@foreach ($saledetails as $key => $value)
    <tr class="new_item{{ $value->product_id }}">
        <td style="padding-left:15px;">
            {{  $value->category->name ?? 'N/A' }}
            <input type="hidden" name="catName[]" value="{{ $value->category_id }}">
        </td>
        <td align="right">
            {{ $value->product->raw_name ?? 'N/A' }}
            <input type="hidden" class="add_quantity" name="proName[]" value="{{ $value->product_id }}">
        </td>
  
        <td class="text-right">
            {{ $value->cct }}
            <input type="hidden" name="cct[]" value="{{ $value->cct }}">
        </td>
        <td class="text-right">
            {{ $value->wattage }}
            <input type="hidden" name="wattage[]" value="{{ $value->wattage }}">
        </td>
        <td class="text-right">
            {{ $value->body_color }}
            <input type="hidden" name="body_color[]" value="{{ $value->body_color }}">
        </td>
        
        <!-- EDITABLE QUANTITY FIELD -->
        <td align="right">
            <input type="number" 
                   class="form-control edit-qty ttlqty" 
                   name="qty[]" 
                   value="{{ $value->qty }}" 
                   min="1" 
                   step="1"
                   data-product-id="{{ $value->product_id }}"
                   data-original-qty="{{ $value->qty }}"
                   onchange="updateRowTotal(this)"
                   style="width: 80px; text-align: right;">
        </td>
        
        <td align="right" class="d-none">
            {{ $value->vat }}
            <input type="hidden" class="row-vat" name="vat[]" value="{{ $value->vat }}">
        </td>
        
        <!-- EDITABLE UNIT PRICE FIELD -->
        <td align="right">
            <input type="number" 
                   class="form-control edit-price ttlunitprice unitparice row-rate" 
                   name="unitprice[]" 
                   value="{{ $value->rate }}" 
                   min="0" 
                   step="0.01"
                   data-product-id="{{ $value->product_id }}"
                   data-original-price="{{ $value->rate }}"
                   onchange="updateRowTotal(this)"
                   style="width: 100px; text-align: right;">
        </td>
        
        @php
            $totale = $value->price;
        @endphp
        
        <!-- DYNAMIC TOTAL FIELD -->
        <td align="right">
            <span class="row-total-display">{{ $totale }}</span>
            <input type="hidden" class="grandtotal row-total" name="price[]" value="{{ $totale }}">
        </td>
        
        <td>
            <a del_id="{{ $key + 1 }}" class="delete_item btn form-control btn-danger" href="javascript:;" title="">
                <i class="fa fa-times"></i>
            </a>
        </td>
    </tr>
@endforeach

                                                                </tbody>
                                                                <tfoot>
                                                                    <tr>
                                                                        <td align="right" colspan="5"><strong>Sub-Total(BDT)</strong>
                                                                        </td>
                                                                        <!--<td align="right"><strong-->
                                                                        <!--        class=""></strong>-->
                                                                        <!--</td>-->
                                                                        <!--<td align="right"><strong-->
                                                                        <!--        class=""></strong>-->
                                                                        <!--</td>-->
                                                                        <td align="right">
                                                                            <strong
                                                                                class="ttlqty">{{ $saledetails->sum('qty') }}</strong>
                                                                        </td>
                                                                        <!--<td align="right"><strong-->
                                                                        <!--        class=""></strong>-->
                                                                        <!--</td>-->
                                                                        <td align="right"><strong
                                                                                class="ttlunitprice">{{ $saledetails->sum('rate') }}</strong>
                                                                        </td>
                                                                        <td align="right"><strong
                                                                                class="grandtotal">{{ $saledetails->sum('price') }}</strong>
                                                                        </td>
                                                                    </tr>
                                                                </tfoot>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-3 float-right">
                                                    <div class="panel  panel-default">
                                                        <div class="panel-body">

                                                            <table class="table table-bordered table-hover ">
                                                                <tbody>
                                                                    <tr>
                                                                        <td nowrap align="right"><strong>Total
                                                                            </strong>
                                                                        </td>
                                                                        <td align="right"> <strong id="gtoal"
                                                                                class="grandtotal">{{ $saledetails->sum('price') }}.00</strong>
                                                                        </td>
                                                                    </tr>
                                                            <tr>
                                                                                                <td nowrap align="right">
                                                                                                    <strong>Discount ( -
                                                                                                        )</strong>
                                                                                                </td>
                                                                                                <td>
                                                                                                    <div
                                                                                                        class="input-group">
                                                                                                        <input
                                                                                                            type="text"
                                                                                                            autocomplete="off"
                                                                                                            onkeyup="discountCalculation(this.value)"
                                                                                                            id="disCount"
                                                                                                            style="text-align: right"
                                                                                                            name="discount"
                                                                                                            value=""
                                                                                                            class="form-control"
                                                                                                            placeholder="0.00"
                                                                                                            oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                                                        <select
                                                                                                            id="discountType"
                                                                                                            class="form-control"
                                                                                                            name="discounttype"
                                                                                                            onchange="discountCalculation(document.getElementById('disCount').value)">
                                                                                                            <option
                                                                                                                value="flat">
                                                                                                                Flat
                                                                                                            </option>
                                                                                                            <option
                                                                                                                value="percentage">
                                                                                                                Percentage
                                                                                                            </option>
                                                                                                        </select>
                                                                                                    </div>
                                                                                                </td>
                                                                                            </tr>
                                                                    <tr>
                                                                        <td nowrap align="right">
                                                                            <strong>Carrying Cost ( + )
                                                                            </strong>
                                                                        </td>
                                                                        <td><input type="text" autocomplete="off"
                                                                                onkeyup="carrying_cost_Calculation(this.value)"
                                                                                id="carrying_cost"
                                                                                style="text-align: right"
                                                                                name="carrying_cost"
                                                                                value="{{ $saletlist->carrying_cost }}"
                                                                                class="form-control" placeholder="0.00"
                                                                                oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td nowrap align="right">
                                                                            <strong>Labor bill ( + )
                                                                            </strong>
                                                                        </td>
                                                                        <td><input type="text" autocomplete="off"
                                                                                onkeyup="labor_bill_Calculation(this.value)"
                                                                                id="labor_bill"
                                                                                value="{{ $saletlist->labor_bill }}"
                                                                                style="text-align: right"
                                                                                name="labor_bill" class="form-control"
                                                                                placeholder="0.00"
                                                                                oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                        </td>
                                                                    </tr>
                                                                    @php
                                                                        $discount =
                                                                            $saledetails->sum('price') -
                                                                            $saletlist->discount;
                                                                    @endphp
                                                                    <tr id="netTotal">
                                                                        <td nowrap align="right"><strong>Net
                                                                                Total</strong>
                                                                        </td>
                                                                        <td align="right"><strong id="ntotal"
                                                                                class="grandtotal">{{ $discount }}.00</strong>
                                                                        </td>
                                                                    </tr>
                                                                    <tr id="account_id">
                                                                        <td nowrap align="right">
                                                                            <strong>Account</strong>
                                                                        </td>
                                                                        <td>
                                                                            <select class="form-control account_id select2"
                                                                                name="account_id" require>
                                                                                <option>---- Select Account ----
                                                                                </option>
                                                                                @foreach ($account as $key => $value)
                                                                                    <option
                                                                                        {{ $transection->account_id ?? '0' == $value->id ? 'selected' : '' }}
                                                                                        value="{{ $value->id }}">
                                                                                        {{ $value->accountCode .
                                                                                            ' -
                                                                                                                                                                        ' .
                                                                                            $value->account_name }}
                                                                                    </option>
                                                                                @endforeach
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                    <tr class="partisals">
                                                                        <td nowrap align="right"><strong>Payment
                                                                                ( -
                                                                                )<span style="color:red;"> *
                                                                                </span></strong>
                                                                        </td>
                                                                        <td><input type="text" id="payment"
                                                                                onkeyup="paymentCalculation(this.value)"
                                                                                style="text-align: right"
                                                                                name="partialPayment" readonly
                                                                                value="{{ $saletlist->partialPayment }}"
                                                                                class="form-control" autocomplete="off"
                                                                                placeholder="0.00"
                                                                                oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                        </td>
                                                                        <!-- <input type="hidden" id="duePayment" style="text-align: right" name="duePayment" value="" readonly class="form-control" placeholder="0.00" /> -->
                                                                    </tr>

                                                                    <tr>
                                                                        <td nowrap align="right"><strong>Total
                                                                                Due</strong>
                                                                        </td>
                                                                        <td align="right"><strong id="totalDue"
                                                                                class="grandtotal finalDue">{{ $discount - $saletlist->partialPayment }}.00</strong>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-9 float-right">
                                                    <div class="panel">
                                                        <div class="panel-body">
                                                            <table class="table ">
                                                                <tr>
                                                                    <td>
                                                                        <textarea style="
                                                                                    border:none;"
                                                                            cols="157" class="form-control" name="narration" placeholder="Note......" type="text"></textarea>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>


                                            </div>
                                        </div>

                                    </td>
                                </tr>
                                <tr>

                                </tr>
                                <tr>
                                    <td>
                                        <div class="clearfix"></div>
                                        <div class="clearfix form-actions float-right">
                                            <div class="col-md-offset-1 col-md-10">
                                                <button class="btn btn-info" id="subMitButton" type="submit">
                                                    Save
                                                </button>
                                                &nbsp; &nbsp; &nbsp;

                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            </table>





                        </div>

                    </form>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>

    <div class="modal fade" id="addCustomerModel" tabindex="-1" role="dialog" aria-labelledby="addCustomerModelLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addCustomerModelLabel">Add Customer</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" id="addCustomerFOrm" action="{{ route('sale.sale.quiceAddCustomer') }}">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom01">Company Name *:</label>
                                    <input type="text" name="co_name" class="form-control" id="validationCustom01"
                                        placeholder="Company Name" value="{{ old('co_name') }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom01">Customer Group Name *:</label>
                                    <select name="customergroup_id" class="form-control select2">
                                        <option value="0">Not Applicable</option>
                                        @foreach ($customerGroup as $data)
                                            <option value="{{ $data->id }}">{{ $data->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom01">Contact Person:</label>
                                    <input type="text" name="name" class="form-control" id="validationCustom01"
                                        placeholder="Contact Person" value="{{ old('name') }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom02">E-mail:</label>
                                    <input type="text" name="email" class="form-control" id="validationCustom02"
                                        placeholder="E-mail" value="{{ old('email') }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom01">Phone:</label>
                                    <input type="text" name="phone" class="form-control" id="validationCustom01"
                                        placeholder="Phone" value="{{ old('phone') }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom02">Address:</label>
                                    <input name="address" class="form-control" id="validationCustom02"
                                        placeholder="Address" value="{{ old('address') }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom07">Bin:</label>
                                    <input name="bin" class="form-control" id="validationCustom07" placeholder="Bin"
                                        value="{{ old('bin') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save Customer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            
         // 1. First, update the product selection to properly populate dropdowns
$('.proName').on('change', function() {
    let selectedProductID = $(this).val();
    $('#productID').val(selectedProductID);

    // Clear previous values
    $('.cct').html('<option selected value="0">--Select CCT--</option>');
    $('.wattage').html('<option selected value="0">--Select Wattage--</option>');
    $('.bodycolor').html('<option selected value="0">--Select Body Color--</option>');
    $('#currentStock').val('0');
    $('#unitpice').val('');

    if (!selectedProductID || selectedProductID === '0') {
        return;
    }

    $.ajax({
        url: '{{ route('find.cct') }}',
        type: 'GET',
        data: {
            product_id: selectedProductID
        },
        success: function(response) {
            let cctOptions = '<option selected value="0">--Select CCT--</option>';
            let wattageOptions = '<option selected value="0">--Select Wattage--</option>';
            let bodyColorOptions = '<option selected value="0">--Select Body Color--</option>';

            // Get unique values
            let uniqueCCT = [...new Set(response.details.map(item => item.cct).filter(Boolean))];
            let uniqueWattage = [...new Set(response.details.map(item => item.wattage).filter(Boolean))];
            let uniqueBodyColor = [...new Set(response.details.map(item => item.body_color).filter(Boolean))];

            uniqueCCT.forEach(function(cct) {
                cctOptions += `<option value="${cct}">${cct}</option>`;
            });

            uniqueWattage.forEach(function(wattage) {
                wattageOptions += `<option value="${wattage}">${wattage}</option>`;
            });

            uniqueBodyColor.forEach(function(bodyColor) {
                bodyColorOptions += `<option value="${bodyColor}">${bodyColor}</option>`;
            });

            $('.cct').html(cctOptions);
            $('.wattage').html(wattageOptions);
            $('.bodycolor').html(bodyColorOptions);

            // Trigger select2 update if you're using it
            $('.cct, .wattage, .bodycolor').trigger('change.select2');
        },
        error: function(xhr, status, error) {
            console.error('Error fetching product details:', error);
        }
    });
});

// 2. Fixed event listeners for CCT, Wattage, and Body Color
$(document).on('change', '.cct', function() {
    console.log('CCT changed to:', $(this).val());
    checkAndUpdateStock();
});

$(document).on('change', '.wattage', function() {
    console.log('Wattage changed to:', $(this).val());
    checkAndUpdateStock();
});

$(document).on('change', '.bodycolor', function() {
    console.log('Body Color changed to:', $(this).val());
    checkAndUpdateStock();
});

// 3. Function to check if all values are selected and update stock
function checkAndUpdateStock() {
    let productId = $('#productID').val();
    let cct = $('.cct').val();
    let wattage = $('.wattage').val();
    let bodyColor = $('.bodycolor').val();

    console.log('Checking values:', {
        productId: productId,
        cct: cct,
        wattage: wattage,
        bodyColor: bodyColor
    });

    // Reset fields if product not selected
    if (!productId || productId === '0') {
        $('#currentStock').val('0');
        $('#unitpice').val('');
        return;
    }

    // Check if all dropdowns have valid selections
    if (cct && cct !== '0' && wattage && wattage !== '0' && bodyColor && bodyColor !== '0') {
        console.log('All values selected, fetching stock and price...');
        getStockAndPrice(productId, cct, wattage, bodyColor);
    } else {
        console.log('Not all values selected yet');
        $('#currentStock').val('0');
        // Don't clear unit price if only some values are selected
    }
}

// 4. Updated function to get stock and price
function getStockAndPrice(productId, cct, wattage, bodyColor) {
    let branch_id = $('#branch_id').val();
    let sub_branch_id = $('#sub_warehouse_id').val();
    let purchasetype = $('.purchasetype').val();

    console.log('Fetching stock with params:', {
        productId: productId,
        cct: cct,
        wattage: wattage,
        bodyColor: bodyColor,
        branch_id: branch_id,
        sub_branch_id: sub_branch_id,
        purchasetype: purchasetype
    });

    // Get unit price
    $.ajax({
        url: "{{ route('sale.sale.saleunitPrice') }}",
        type: "GET",
        cache: false,
        data: {
            "_token": "{{ csrf_token() }}",
            'productId': productId,
            'cct': cct,
            'wattage': wattage,
            'body_color': bodyColor
        },
        success: function(data) {
            console.log('Unit price response:', data);
            $("#unitpice").val(data.sale_price == 0 ? '' : data.sale_price);
            if (data.lastPurchasePrice) {
                $(".purchaseprice").html("Last PP: " + data.lastPurchasePrice);
            }
        },
        error: function(xhr, status, error) {
            console.error('Error fetching unit price:', error);
            console.error('Response:', xhr.responseText);
        }
    });

    // Get stock quantity
    $.ajax({
        url: "{{ route('sale.sale.getProductStock') }}",
        type: "GET",
        cache: false,
        data: {
            "_token": "{{ csrf_token() }}",
            productId: productId,
            type: purchasetype,
            branch_id: branch_id,
            sub_branch_id: sub_branch_id,
            cct: cct,
            wattage: wattage,
            body_color: bodyColor
        },
        success: function(data) {
            console.log('Stock response:', data);
            $("#currentStock").val(data);
        },
        error: function(xhr, status, error) {
            console.error('Error fetching stock:', error);
            console.error('Response:', xhr.responseText);
            $("#currentStock").val('0');
        }
    });
}

// 5. Alternative approach if the above doesn't work - direct event binding after dropdown population
function bindDropdownEvents() {
    $('.cct, .wattage, .bodycolor').off('change.stockCheck').on('change.stockCheck', function() {
        console.log('Dropdown changed:', $(this).attr('class'), $(this).val());
        setTimeout(checkAndUpdateStock, 100); // Small delay to ensure all values are updated
    });
}

// 6. Update the original proName change event to include the new binding
$('.proName').on('change', function() {
    let selectedProductID = $(this).val();
    $('#productID').val(selectedProductID);

    // Clear previous values
    $('.cct').html('<option selected value="0">--Select CCT--</option>');
    $('.wattage').html('<option selected value="0">--Select Wattage--</option>');
    $('.bodycolor').html('<option selected value="0">--Select Body Color--</option>');
    $('#currentStock').val('0');
    $('#unitpice').val('');

    if (!selectedProductID || selectedProductID === '0') {
        return;
    }

    $.ajax({
        url: '{{ route('find.cct') }}',
        type: 'GET',
        data: {
            product_id: selectedProductID
        },
        success: function(response) {
            let cctOptions = '<option selected value="0">--Select CCT--</option>';
            let wattageOptions = '<option selected value="0">--Select Wattage--</option>';
            let bodyColorOptions = '<option selected value="0">--Select Body Color--</option>';

            // Get unique values
            let uniqueCCT = [...new Set(response.details.map(item => item.cct).filter(Boolean))];
            let uniqueWattage = [...new Set(response.details.map(item => item.wattage).filter(Boolean))];
            let uniqueBodyColor = [...new Set(response.details.map(item => item.body_color).filter(Boolean))];

            uniqueCCT.forEach(function(cct) {
                cctOptions += `<option value="${cct}">${cct}</option>`;
            });

            uniqueWattage.forEach(function(wattage) {
                wattageOptions += `<option value="${wattage}">${wattage}</option>`;
            });

            uniqueBodyColor.forEach(function(bodyColor) {
                bodyColorOptions += `<option value="${bodyColor}">${bodyColor}</option>`;
            });

            $('.cct').html(cctOptions);
            $('.wattage').html(wattageOptions);
            $('.bodycolor').html(bodyColorOptions);

            // Rebind events after populating dropdowns
            bindDropdownEvents();

            // Trigger select2 update if you're using it
            if ($.fn.select2) {
                $('.cct, .wattage, .bodycolor').trigger('change.select2');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error fetching product details:', error);
        }
    });
});

// 7. Initialize on document ready
$(document).ready(function() {
    bindDropdownEvents();
});

// 8. Debug function to check current values
function debugCurrentValues() {
    console.log('Current values:');
    console.log('Product ID:', $('#productID').val());
    console.log('CCT:', $('.cct').val());
    console.log('Wattage:', $('.wattage').val());
    console.log('Body Color:', $('.bodycolor').val());
    console.log('Current Stock:', $('#currentStock').val());
    console.log('Unit Price:', $('#unitpice').val());
}
            // Supplier  Create
            $('#addCustomerFOrm').on('submit', function(e) {
                e.preventDefault();
                const formData = $(this).serialize();
                $.ajax({
                    url: $(this).attr('action'),
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        if (response.success) {
                            $('#addCustomerModel').modal('hide');
                            $('select[name="ledger_id"]').append(
                                `<option value="${response.accounts.id}" selected>${response.accounts.account_name}</option>`
                            );
                        } else {
                            alert('Error adding Unit');
                        }
                    },
                    error: function(error) {
                        alert('An error occurred');
                    }
                });
                $("button[type='submit']").prop('disabled', false);
            });
        });


        $(document).ready(function() {
            $('#cty_size, #qty').on('input', function() {
                let ctyval = $('#cty_size').val();
                let qty = $('#qty').val();
                let gas_qty = ctyval * qty;
                $('#gas_qty').val(gas_qty);
            })

            var findqtyamount = function() {

                var ttlqty = 0;
                $.each($('.ttlqty'), function() {
                    qty = $(this).val();
                    qty = Number(qty);
                    ttlqty += qty;
                });
                $('.ttlqty').text(parseFloat(ttlqty).toFixed(2));

            };

            var findunitamount = function() {
                var ttlunitprice = 0;
                $.each($('.ttlunitprice'), function() {
                    unitprice = $(this).val();
                    unitprice = Number(unitprice);
                    ttlunitprice += unitprice;
                });
                $('.ttlunitprice').text(parseFloat(ttlunitprice).toFixed(2));
            };

            var findgrandtottal = function() {
                var grandtotal = 0;
                $.each($('.grandtotal'), function() {
                    total = $(this).val();
                    total = Number(total);
                    grandtotal += total;
                });
                $('.grandtotal').text(parseFloat(grandtotal).toFixed(2));
                var paymentType = $('input[name="payment_type"]:checked').val();
                if (paymentType == "Cash") {
                    $('#payment').val(parseFloat(grandtotal).toFixed(2));
                    paymentCalculation(parseFloat(grandtotal));
                }
            };

     $("#add_item").click(function() {
                // Get selected product ID
                let selectedProductID = $('#productID option:selected').val();
                let existingRow = $('tbody').find(`.new_item${selectedProductID}`).length;

                // if (existingRow > 0) {
                //     alertMessage.error('This product already exists');
                //     return;
                // }

                // Collect form values
                let cct = $('.cct').val();
                let wattage = $('.wattage').val();
                let bodyColor = $('.bodycolor').val();

                let purchaseTypeVal = $('.purchasetype').find('option:selected').val();
                let purchaseTypeText = $('.purchasetype').find('option:selected').text();

                let catId = $('.catName').val();
                let catName = $(".catName option:selected").attr('catName');

                let proId = $('.proName').val();
                let proName = $(".proName option:selected").attr('proName');

                let unit = $('.unit').val();
                let qty = $('.qty').val();
                let vat = parseFloat($('#vat').val()) || '';

                let paymentType = $('input[name="payment_type"]:checked').val();
                let customer_id = $('#customer_id').val();

                let unitPrice = $('.unitprice').val();
                let total = $('.total').val();

                // Validation
                if (!catId) {
                    alertMessage.error("Category can't be empty.");
                    return;
                }
                if (!proId) {
                    alertMessage.error("Product can't be empty.");
                    return;
                }
                if (!qty || qty == 0) {
                    alertMessage.error("Quantity can't be empty or zero.");
                    return;
                }

                if (!paymentType) {
                    alertMessage.error("Please select Payment Type.");
                    return;
                }

                // Add row to table
                $("#show_item tbody").append(`
        <tr class="new_item${proId}">
            <td style="padding-left:15px;">
                ${catName}
                <input type="hidden" name="catName[]" value="${catId}">
            </td>
            <td align="right">
                ${proName}
                <input type="hidden" class="add_quantity" name="proName[]" value="${proId}">
            </td>
            <td class="text-right">${cct}<input type="hidden" name="cct[]" value="${cct}"></td>
            <td class="text-right">${wattage}<input type="hidden" name="wattage[]" value="${wattage}"></td>
            <td class="text-right">${bodyColor}<input type="hidden" name="body_color[]" value="${bodyColor}"></td>
            <td align="right">${qty}<input type="hidden" class="ttlqty" name="qty[]" value="${qty}"></td>

            <td align="right">${unitPrice}<input type="hidden" class="ttlunitprice unitparice" name="unitprice[]" value="${unitPrice}"></td>
            <td align="right">${total}<input type="hidden" class="grandtotal" name="total[]" value="${total}"></td>
            <td>
                <a del_id="${proId}" class="delete_item btn form-control btn-danger" href="javascript:;" title="">
                    <i class="fa fa-times"></i>
                </a>
            </td>
        </tr>
    `);

                // Reset fields
                $(".catName").val(null).trigger("change");
                $(".proName").val(null).trigger("change");
                $("#currentStock, #qty, #cty_size, #gas_qty").val("");
                $(".unitprice, .ttlamount").val("");

                // Recalculate totals
                findqtyamount();
                findunitamount();
                findgrandtottal();
                checkDepositAndCreditBalance();
            });

// Alternative approach - if you want to use a more reliable method
$(document).on('click', '.delete_item_alt', function() {
    let deleteitem = () => {
        // Simply remove the closest table row
        $(this).closest('tr').remove();
        
        // Recalculate all totals
        findqtyamount();
        findunitamount();
        findgrandtottal();
        checkDepositAndCreditBalance();
        
        // Update the footer totals
        updateFooterTotals();
    }
    
    if (typeof alertMessage !== 'undefined' && alertMessage.confirm) {
        alertMessage.confirm('You want to remove this', deleteitem);
    } else {
        if (confirm("Are you sure you want to remove this item?")) {
            deleteitem();
        }
    }
});


$(document).on('click', '.delete_item', function() {
    let deleteitem = () => {
        var id = $(this).attr("del_id");
        var $row = $(this).closest('tr');
        
        // Handle both dynamically added rows and existing rows
        if ($row.hasClass('new_item' + id)) {
            // For dynamically added rows
            $('.new_item' + id).remove();
        } else {
            // For existing rows from database
            $row.remove();
        }
        
        // Recalculate all totals
        findqtyamount();
        findunitamount();
        findgrandtottal();
        checkDepositAndCreditBalance();
        
        // Also recalculate using the new function if it exists
        if (typeof recalculateAllTotals === 'function') {
            recalculateAllTotals();
        }
    }
    
    // Use your existing alert confirmation
    if (typeof alertMessage !== 'undefined' && alertMessage.confirm) {
        alertMessage.confirm('You want to remove this', deleteitem);
    } else {
        // Fallback to standard confirm
        if (confirm("Are you sure you want to remove this item?")) {
            deleteitem();
        }
    }
});

        });



        function checkDepositAndCreditBalance() {

            var paymentType = $("#paymentType").val();

            if (paymentType == '') {
                paymentType = 'Cash';
            }

            console.log(paymentType);
            var customer_currentBalance = $("#customer_currentBalance").val();
            // var totalDue = document.getElementById("totalDue").innerText;

            var totalDue = $("#totalDue").text();
            var expireDatas = $("#expireData").val();


            var todaysDate = new Date().toISOString().slice(0, 10);

            if (expireDatas == '') {
                expireDatas = todaysDate;
            }
            var btn = document.getElementById('subMitButton');
            if (paymentType == 'Cash') {
                console.log('3');
                btn.disabled = false;
            } else {
                console.log('4');
                btn.disabled = false;
            }

        }
    </script>


    <script>
              function gamount() {
            var gtoal = parseFloat(document.getElementById("gtoal").innerText);
            var carrying_cost = parseFloat($("#carrying_cost").val());
            var discount = parseFloat($("#disCount").val());
            var labor_bill = parseFloat($("#labor_bill").val());
            var vat = parseFloat($("#vat_per").val() / 100) * ((gtoal || 0) + (carrying_cost || 0)) - (discount || 0);

            return ((gtoal || 0) + (carrying_cost || 0) + (vat || 0)) - (discount || 0);
        }

        function discountCalculation(amount) {
            var gtoal = parseFloat(document.getElementById("gtoal").innerText);
            var discountType = document.getElementById("discountType").value;
            var discount = parseFloat(amount) || 0; // Parse the discount value, default to 0

            // Calculate discount based on type
            if (discountType === "percentage") {
                if (discount > 100) {
                    alertMessage.error("Percentage discount cannot exceed 100%");
                    $('#disCount').val('');
                    $('#ntotal').text(gtoal.toFixed(2));
                    $('#totalDue').text(gtoal.toFixed(2));
                    return;
                }
                discount = (gtoal * discount) / 100; // Convert percentage to amount
            }

            if (discount > gtoal) {
                alertMessage.error("Discount cannot be greater than the total amount");
                $('#disCount').val('');
                $('#ntotal').text(gtoal.toFixed(2));
                $('#totalDue').text(gtoal.toFixed(2));
                return;
            }

            var carrying_cost = parseFloat($("#carrying_cost").val()) || 0;
            var afterDiscount = gtoal - discount + carrying_cost;

            $('#ntotal').text(afterDiscount.toFixed(2));
            $('#totalDue').text(afterDiscount.toFixed(2));

            var paymentType = $('input[name="payment_type"]:checked').val();
            if (paymentType === "Cash") {
                $('#payment').val(afterDiscount.toFixed(2));
                paymentCalculation(afterDiscount);
            }
        }


// Update carrying cost and labor bill calculations
function carrying_cost_Calculation(amount) {
    updateNetTotal();
}

function labor_bill_Calculation(amount) {
    updateNetTotal();
}

// Initialize on page load
$(document).ready(function() {
    // Recalculate totals when page loads
    recalculateAllTotals();
    
    // Style the input fields
    $('.edit-qty, .edit-price').css({
        'border': '1px solid #ddd',
        'padding': '5px',
        'border-radius': '4px',
        'background-color': '#f9f9f9'
    });
    
    // Add focus styling
    $('.edit-qty, .edit-price').focus(function() {
        $(this).css('background-color', '#fff');
    }).blur(function() {
        $(this).css('background-color', '#f9f9f9');
    });
    
    // Add real-time calculation on input
    $('.edit-qty, .edit-price').on('input', function() {
        updateRowTotal(this);
    });
});

        function carrying_cost_Calculation(amount) {

            var gtoal = document.getElementById("gtoal").innerText;
            var discount = $("#disCount").val();
            var afterCarryingCost = gamount();
            $('#ntotal').text(parseFloat(afterCarryingCost).toFixed(2));
            $('#totalDue').text(parseFloat(afterCarryingCost).toFixed(2));

        }

        function labor_bill_Calculation(amount) {
            var gtoal = document.getElementById("gtoal").innerText;
            var afterLaborBill = gamount();

            $('#ntotal').text(parseFloat(afterLaborBill).toFixed(2));
            $('#totalDue').text(parseFloat(afterLaborBill).toFixed(2));
        }

        function paymentCalculation(payamount) {
            var ntotal = document.getElementById("ntotal").innerText;
            var totalDue = ntotal - payamount;
            $('.finalDue').text(parseFloat(totalDue).toFixed(2));
        }

        function qtyPriceCal() {
            var qty = $('#qty').val();
            var unitpice = $('#unitpice').val();
            var vat = parseFloat($('#vat').val()) || 0;
            var currentStock = $('#currentStock').val();
            if (parseFloat(qty) > currentStock) {
                $('.ttlamount').val('');
                $('#qty').val('');
                // lert('The desired product stock is not available');
                alertMessage.error('The desired product stock is not available.');
            } else {
                var totalWithoutVAT = unitpice * qty;
                var vatAmount = (vat > 0) ? (vat / 100) * totalWithoutVAT : 0;
                var totalWithVAT = totalWithoutVAT + vatAmount;
                var ttlqtys = document.getElementById('total').value = totalWithVAT.toFixed(2);
            }
        }

        function getProductList(cat_id) {

            var branch_id = $('#branch_id').val();

            if (branch_id == null) {
                alertMessage.error('Branch Are not selected');
                return;
            }
            $.ajax({
                "url": "{{ route('sale.sale.getProductListForSale') }}",
                "type": "GET",
                cache: false,
                data: {
                    "_token": "{{ csrf_token() }}",
                    cat_id: cat_id,
                    branch_id: branch_id
                },
                success: function(data) {
                    $('#productID').select2();
                    $('#productID option').remove();
                    $('#productID').append($(data));
                    $("#productID").trigger("select2:updated");
                }
            });
        }

        function getCustomerBalance(payment_type) {
            var customer_id = $('#customer_id').val();
            $("#paymentType").val(payment_type);

            if (payment_type == 'Cash') {
                $('#account_id').show();
                $('#netTotal').show();
                $('.partisals').show();
                calculatetotal();
            } else {
                calculatetotal();
                var discount = $('#disCount').val();
                discountCalculation(discount);
                $('.partisals').css('display', 'none');
                $('#account_id').css('display', 'none');
                $('#netTotal').css('display', 'none');
            }

            $.ajax({
                "url": "{{ route('sale.sale.getCustomerBalance') }}",
                "type": "GET",
                cache: false,
                dataType: "json",
                data: {
                    "_token": "{{ csrf_token() }}",
                    customer_id: customer_id,
                    payment_type: payment_type
                },
                success: function(data) {

                    if (payment_type == 'Cash') {
                        $("#customer_currentBalance").val('');
                    } else {
                        $("#customer_currentBalance").val(data.finalBalance);
                        $("#expireData").val(data.expireData);
                    }

                }
            });
        }

        var calculatetotal = function() {
            var grandtotal = 0;
            $.each($('.grandtotal'), function() {
                total = $(this).val();
                total = Number(total);
                grandtotal += total;
            });

            if (parseFloat(grandtotal) > 0) {
                $('.grandtotal').text(parseFloat(grandtotal).toFixed(2));
                var paymentType = $('input[name="payment_type"]:checked').val();
                if (paymentType == "Cash") {
                    $('#payment').val(parseFloat(grandtotal).toFixed(2));
                    paymentCalculation(parseFloat(grandtotal));
                }
            }
        };

        var payTypeID = $('#paymentypeValue').val();
        getCustomerBalance(payTypeID);

function updateRowTotal(input) {
    var row = $(input).closest('tr');
    var qty = parseFloat(row.find('.edit-qty').val()) || 0;
    var rate = parseFloat(row.find('.edit-price, .row-rate').val()) || 0;
    var vat = parseFloat(row.find('.row-vat').val()) || 0;
    
    // Ensure minimum values
    if (qty < 1) {
        row.find('.edit-qty').val(1);
        qty = 1;
        alertMessage.error('Quantity must be at least 1');
    }
    
    if (rate < 0) {
        row.find('.edit-price, .row-rate').val(0);
        rate = 0;
        alertMessage.error('Price cannot be negative');
    }
    
    // Calculate total without VAT
    var totalWithoutVAT = qty * rate;
    
    // Calculate VAT amount
    var vatAmount = (vat > 0) ? (vat / 100) * totalWithoutVAT : 0;
    
    // Calculate total with VAT
    var totalWithVAT = totalWithoutVAT + vatAmount;
    
    // Update the display and hidden input
    row.find('.row-total-display').text(totalWithVAT.toFixed(2));
    row.find('.row-total').val(totalWithVAT.toFixed(2));
    
    // Update the rate hidden input if it exists
    if (row.find('.row-rate').length && !row.find('.edit-price').length) {
        row.find('.row-rate').val(rate);
    }
    
    // Recalculate all totals
    recalculateAllTotals();
}

// Updated function to recalculate all totals
function recalculateAllTotals() {
    var totalQty = 0;
    var totalUnitPrice = 0;
    var totalPrice = 0;
    
    // Calculate totals from all visible rows (both existing and new)
    $('#show_item tbody tr').each(function() {
        // Skip the input row
        if ($(this).find('.catName').length > 0) return;
        
        var qty = 0;
        var unitPrice = 0;
        var price = 0;
        
        // Handle editable rows (existing products)
        if ($(this).find('.edit-qty').length > 0) {
            qty = parseFloat($(this).find('.edit-qty').val()) || 0;
            unitPrice = parseFloat($(this).find('.edit-price, .row-rate').val()) || 0;
            price = parseFloat($(this).find('.row-total').val()) || 0;
        } else {
            // Handle new rows
            qty = parseFloat($(this).find('input[name="qty[]"]').val()) || 0;
            unitPrice = parseFloat($(this).find('input[name="unitprice[]"]').val()) || 0;
            price = parseFloat($(this).find('input[name="total[]"], input[name="price[]"]').val()) || 0;
        }
        
        totalQty += qty;
        totalUnitPrice += unitPrice;
        totalPrice += price;
    });
    
    // Update footer displays
    $('tfoot .ttlqty').text(totalQty.toFixed(0));
    $('tfoot .ttlunitprice').text(totalUnitPrice.toFixed(2));
    $('tfoot .grandtotal').text(totalPrice.toFixed(2));
    $('#gtoal').text(totalPrice.toFixed(2));
    
    // Update net total calculations
    updateNetTotal();
}


// Add validation for price input
$(document).on('input change', '.edit-price', function() {
    var price = parseFloat($(this).val()) || 0;
    
    // Ensure price is not negative
    if (price < 0) {
        $(this).val(0);
        alertMessage.error('Price cannot be negative');
        return;
    }
    
    // Update the row total
    updateRowTotal(this);
});


// Enhanced validation for quantity input
$(document).on('input change', '.edit-qty', function() {
    var qty = parseFloat($(this).val()) || 0;
    var originalQty = parseFloat($(this).data('original-qty')) || 0;
    var productId = $(this).data('product-id');
    
    // Ensure minimum quantity is 1
    if (qty < 1) {
        $(this).val(1);
        alertMessage.error('Quantity must be at least 1');
        return;
    }
    
    // You can add stock validation here if needed
    // var currentStock = getCurrentStock(productId);
    // if (qty > currentStock) {
    //     $(this).val(originalQty);
    //     alertMessage.error('Insufficient stock available');
    //     return;
    // }
    
    // Update the row total
    updateRowTotal(this);
});


function updateNetTotal() {
    var grandTotal = parseFloat($('#gtoal').text()) || 0;
    var discount = parseFloat($('#disCount').val()) || 0;
    var discountType = $('#discountType').val();
    var carryingCost = parseFloat($('#carrying_cost').val()) || 0;
    var laborBill = parseFloat($('#labor_bill').val()) || 0;
    
    // Calculate discount
    var discountAmount = 0;
    if (discountType === "percentage") {
        discountAmount = (grandTotal * discount) / 100;
    } else {
        discountAmount = discount;
    }
    
    var netTotal = grandTotal - discountAmount + carryingCost + laborBill;
    $('#ntotal').text(netTotal.toFixed(2));
    
    // Update payment calculations
    var paymentType = $('input[name="payment_type"]:checked').val();
    if (paymentType == "Cash") {
        $('#payment').val(netTotal.toFixed(2));
        paymentCalculation(netTotal);
    } else {
        var payment = parseFloat($('#payment').val()) || 0;
        var totalDue = netTotal - payment;
        $('#totalDue').text(totalDue.toFixed(2));
    }
}

// Updated existing functions to work with editable quantities
var findqtyamount = function() {
    var ttlqty = 0;
    
    // Calculate from both new items and existing editable items
    $('.ttlqty').each(function() {
        var qty = parseFloat($(this).val()) || 0;
        ttlqty += qty;
    });
    
    // Also include editable quantities
    $('.edit-qty').each(function() {
        var qty = parseFloat($(this).val()) || 0;
        ttlqty += qty;
    });
    
    // Update the footer total quantity display
    $('tfoot .ttlqty').text(ttlqty.toFixed(0));
};

var findunitamount = function() {
    var ttlunitprice = 0;
    
    $('.ttlunitprice').each(function() {
        var unitprice = parseFloat($(this).val()) || 0;
        ttlunitprice += unitprice;
    });
    
    // Also include rates from editable rows
    $('.row-rate').each(function() {
        var rate = parseFloat($(this).val()) || 0;
        ttlunitprice += rate;
    });
    
    // Update the footer total unit price display
    $('tfoot .ttlunitprice').text(ttlunitprice.toFixed(2));
};

var findgrandtottal = function() {
    var grandtotal = 0;
    
    // Calculate from both new items and existing editable items
    $('.grandtotal').each(function() {
        var total = parseFloat($(this).val()) || 0;
        grandtotal += total;
    });
    
    // Also include totals from editable rows
    $('.row-total').each(function() {
        var total = parseFloat($(this).val()) || 0;
        grandtotal += total;
    });
    
    // Update the footer grand total display
    $('tfoot .grandtotal').text(grandtotal.toFixed(2));
    
    // Update main total display
    $('#gtoal').text(grandtotal.toFixed(2));
    
    var paymentType = $('input[name="payment_type"]:checked').val();
    if (paymentType == "Cash") {
        $('#payment').val(grandtotal.toFixed(2));
        paymentCalculation(grandtotal);
    }
};

// Add validation for quantity input
$(document).on('input change', '.edit-qty', function() {
    var qty = parseFloat($(this).val()) || 0;
    var originalQty = parseFloat($(this).data('original-qty')) || 0;
    var productId = $(this).data('product-id');
    
    // Ensure minimum quantity is 1
    if (qty < 1) {
        $(this).val(1);
        alertMessage.error('Quantity must be at least 1');
        return;
    }
    
    // Update the row total
    updateRowTotal(this);
});

// Initialize on page load
$(document).ready(function() {
    // Recalculate totals when page loads
    recalculateAllTotals();
    
    // Style the quantity input fields
    $('.edit-qty').css({
        'border': '1px solid #ddd',
        'padding': '5px',
        'border-radius': '4px',
        'background-color': '#f9f9f9'
    });
    
    // Add focus styling
    $('.edit-qty').focus(function() {
        $(this).css('background-color', '#fff');
    }).blur(function() {
        $(this).css('background-color', '#f9f9f9');
    });
});

// Alternative simpler approach - just update the specific functions
var calculatetotal = function() {
    var grandtotal = 0;
    
    // Calculate from regular grandtotal inputs
    $('.grandtotal').each(function() {
        var total = parseFloat($(this).val()) || 0;
        grandtotal += total;
    });
    
    // Calculate from editable row totals
    $('.row-total').each(function() {
        var total = parseFloat($(this).val()) || 0;
        grandtotal += total;
    });

    if (grandtotal > 0) {
        $('.grandtotal').last().text(grandtotal.toFixed(2));
        $('#gtoal').text(grandtotal.toFixed(2));
        
        var paymentType = $('input[name="payment_type"]:checked').val();
        if (paymentType == "Cash") {
            $('#payment').val(grandtotal.toFixed(2));
            paymentCalculation(grandtotal);
        }
    }
};


// Function to update footer totals
function updateFooterTotals() {
    var totalQty = 0;
    var totalUnitPrice = 0;
    var totalPrice = 0;
    
    // Calculate totals from all visible rows
    $('#show_item tbody tr').each(function() {
        // Skip the input row
        if ($(this).find('.catName').length > 0) return;
        
        var qty = parseFloat($(this).find('input[name="qty[]"]').val()) || 0;
        var unitPrice = parseFloat($(this).find('input[name="unitprice[]"]').val()) || 0;
        var price = parseFloat($(this).find('input[name="total[]"], input[name="price[]"]').val()) || 0;
        
        totalQty += qty;
        totalUnitPrice += unitPrice;
        totalPrice += price;
    });
    
    // Update footer displays
    $('tfoot .ttlqty').text(totalQty.toFixed(0));
    $('tfoot .ttlunitprice').text(totalUnitPrice.toFixed(2));
    $('tfoot .grandtotal').text(totalPrice.toFixed(2));
    $('#gtoal').text(totalPrice.toFixed(2));
    
    // Update net total calculations
    var discount = parseFloat($('#disCount').val()) || 0;
    var carryingCost = parseFloat($('#carrying_cost').val()) || 0;
    var laborBill = parseFloat($('#labor_bill').val()) || 0;
    
    var netTotal = totalPrice - discount + carryingCost + laborBill;
    $('#ntotal').text(netTotal.toFixed(2));
    
    // Update payment calculations
    var paymentType = $('input[name="payment_type"]:checked').val();
    if (paymentType == "Cash") {
        $('#payment').val(netTotal.toFixed(2));
        paymentCalculation(netTotal);
    }
}
$(document).on('change', '.cct, .wattage, .bodycolor', function() {
    let productId = $('#productID').val();
    let cct = $('.cct option:selected').val();
    let wattage = $('.wattage option:selected').val();
    let bodyColor = $('.bodycolor option:selected').val();

    // Debug logging
    console.log('Product ID:', productId);
    console.log('CCT:', cct);
    console.log('Wattage:', wattage);
    console.log('Body Color:', bodyColor);

    // Call only if all values are selected and not default values
    if (productId && cct && cct !== '0' && wattage && wattage !== '0' && bodyColor && bodyColor !== '0') {
        getUnitPrice(productId, cct, wattage, bodyColor);
    }
});

// Also update the getUnitPrice function to handle the additional parameters
function getUnitPrice(productId, cct, wattage, bodyColor) {
    let branch_id = $('#branch_id option:selected').val();
    let sub_branch_id = $('#sub_warehouse_id option:selected').val();
    let purchasetype = $('.purchasetype option:selected').val();
    
    // Get unit price
    $.ajax({
        "url": "{{ route('sale.sale.saleunitPrice') }}",
        "type": "GET",
        cache: false,
        data: {
            "_token": "{{ csrf_token() }}",
            'productId': productId,
            'cct': cct,
            'wattage': wattage,
            'body_color': bodyColor
        },
        success: function(data) {
            console.log('Unit price data:', data);
            $("#unitpice").val(data.sale_price == 0 ? '' : data.sale_price);
            $(".purchaseprice").html("Last PP :" + data.lastPurchasePrice);
        },
        error: function(xhr, status, error) {
            console.error('Error fetching unit price:', error);
        }
    });

    // Get stock quantity
    $.ajax({
        "url": "{{ route('sale.sale.getProductStock') }}",
        "type": "GET",
        cache: false,
        data: {
            "_token": "{{ csrf_token() }}",
            productId: productId,
            type: purchasetype,
            branch_id: branch_id,
            sub_branch_id: sub_branch_id,
            cct: cct,
            wattage: wattage,
            body_color: bodyColor
        },
        success: function(data) {
            console.log('Stock data:', data);
            $("#currentStock").val(data);
        },
        error: function(xhr, status, error) {
            console.error('Error fetching stock:', error);
        }
    });
}

// Alternative approach: If you want to trigger on each individual change
$(document).on('change', '.cct', function() {
    checkAndGetPrice();
});

$(document).on('change', '.wattage', function() {
    checkAndGetPrice();
});

$(document).on('change', '.bodycolor', function() {
    checkAndGetPrice();
});

function checkAndGetPrice() {
    let productId = $('#productID').val();
    let cct = $('.cct option:selected').val();
    let wattage = $('.wattage option:selected').val();
    let bodyColor = $('.bodycolor option:selected').val();

    console.log('Checking values:', {productId, cct, wattage, bodyColor});

    if (productId && cct && cct !== '0' && wattage && wattage !== '0' && bodyColor && bodyColor !== '0') {
        getUnitPrice(productId, cct, wattage, bodyColor);
    }
}
    </script>
@endsection
