@extends('backend.layouts.master')
@section('title')
    Report - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
@endsection
@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Report </h1>
                </div><!-- /.col -->

            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">

        <div class="col-md-12">
            @if ($errors->any())
                <div class="card">
                    <div class="card-body">
                        <div class="text-danger">
                            <h4><i style="color:rgb(255, 0, 0)" class="fa fa-regular fa-bell"></i> {{ $errors->first() }}
                            </h4>
                        </div>
                    </div>
                </div>
            @endif

            <form action="{{ route('report.prodcution.repo') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card card-outline card-info no-print">
                    <div class="card-body">
                        <div class="row  no-print">
                            <div class="box-header with-border" style="cursor: pointer;">
                                <h6 class="box-title">
                                    <i class="fa fa-filter" aria-hidden="true"></i> Filters
                                </h6>
                            </div>
                        </div>

                        <div class="row no-print">
                            {{-- @dd('ff'); --}}
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Project </label>
                                    <select class="form-control select2 " name="project_id">
                                        <option value="0" selected>Select A Project</option>
                                        @foreach ($project as $key => $value)
                                            <option {{ $project_id == $value->id ? 'selected' : '' }}
                                                value="{{ $value->id }}">
                                                {{ $value->projectCode . ' - ' . $value->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('branch_id')
                                        <span class="error text-red text-bold"> {{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            @php

                            @endphp

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>&nbsp;</label><br>
                                    <button type="submit" class="btn btn-sm btn-success"><i class="fa fa-search"></i>
                                        Search</button>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div id="load_data"></div>
            </form>
        </div>
        @php
            // dd($projectDetails);
            $productAmount = 0;
        @endphp
        @if (isset($projectDetails) && !empty($projectDetails))
            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-header no-print">
                        <h3 class="card-title">Production Report</h3>
                        <a onclick="window.print()" target="_blank" class="btn btn-default float-right my-2 no-print"><i
                                class="fas fa-print"></i>
                            Print</a>
                        <div id="tableActions" class=" float-right my-2 no-print"></div>
                    </div>

                    <div class="card-body">

                        <div class="invoice p-3 mb-3">
                            <div class="row">
                                <div class="col-12 table-responsive">

                                    <table id="datatablexcel" class="table  table-striped  table-bordered">
                                        <thead>
                                            <tr>
                                                <td colspan="5"><b>
                                                        <i class="fa fa-bullseye" aria-hidden="true"></i>
                                                        Production Production Require
                                                    </b></td>
                                            </tr>
                                            <tr>
                                                <th>Product</th>
                                                <th>CCT</th>
                                                <th>Wattage</th>
                                                <th>Body Color</th>
                                                <th>Required Quantity</th>
                                            </tr>
                                        </thead>
                                        @if (!$productionDetails->isEmpty())
                                            <tbody>
                                                <tr>
                                                    <td colspan="5">
                                                        <b>
                                                            <i class="fa fa-bullseye" aria-hidden="true"></i>
                                                            Products details
                                                        </b>
                                                    </td>
                                                </tr>
                                                @php
                                                    $productAmount = 0;
                                                @endphp

                                                @foreach ($productionDetails as $val)
                                                    <tr>
                                                        <td>{{ $val->product->name ?? '' }}</td>
                                                        <td>{{ $val->cct ?? '' }}</td>
                                                        <td>{{ $val->wattage ?? '' }}</td>
                                                        <td>{{ $val->body_color ?? '' }}</td>
                                                        <td>{{ $val->quantity ?? '' }}</td>
                                                    </tr>
                                                @endforeach


                                            </tbody>
                                        @endif
                                    </table>

                                </div>
                                <br>
                                <div class="col-12 table-responsive">
                                    <table id="datatablexcel" class="table  table-striped  table-bordered">
                                        <thead>
                                            <tr>
                                                <td colspan="5"><b>
                                                        <i class="fa fa-bullseye" aria-hidden="true"></i>Goods
                                                        Requisition</b></td>
                                            </tr>
                                            <tr>
                                                <th>Requisition Invoice</th>
                                                <th>Goods</th>
                                                <th>qty</th>
                                            </tr>
                                        </thead>

                                        @if (!$productionrequsitonDetails->isEmpty())
                                            <tbody>
                                                <tr>
                                                    <td colspan="5">
                                                        <b>
                                                            <i class="fa fa-bullseye" aria-hidden="true"></i>
                                                            Goods details
                                                        </b>
                                                    </td>
                                                </tr>
                                                @php
                                                    $productAmount = 0;
                                                @endphp

                                                @foreach ($productionrequsitonDetails as $val)
                                                    <tr>
                                                        <td>RQ000 {{$val->production_requsition_id ?? '' }}</td>
                                                        <td>{{ $val->goods->name ?? '' }}</td>
                                                        <td>{{ $val->qty ?? '' }}</td>
                                                    </tr>
                                                @endforeach


                                            </tbody>
                                        @endif
                                    </table>
                                </div>
                                <br>
                                <div class="col-12 table-responsive">
                                    <table id="datatablexcel" class="table  table-striped  table-bordered">
                                        <thead>
                                            <tr>
                                                <td colspan="5"><b>
                                                        <i class="fa fa-bullseye" aria-hidden="true"></i>Goods Stock</b></td>
                                            </tr>
                                            <tr>
                                                <th>Goods</th>
                                                <th>Available qty</th>
                                            </tr>
                                        </thead>

                                        @if (!$stocks->isEmpty())
                                            <tbody>
                                                <tr>
                                                    <td colspan="5">
                                                        <b>
                                                            <i class="fa fa-bullseye" aria-hidden="true"></i>
                                                            Goods
                                                        </b>
                                                    </td>
                                                </tr>
                                                @php
                                                    $productAmount = 0;
                                                @endphp

                                                @foreach ($stocks as $val)
                                                    <tr>
                                                        <td>{{ $val->goods->name ?? '' }}</td>
                                                        <td>{{ $val->qty ?? '' }}</td>
                                                    </tr>
                                                @endforeach


                                            </tbody>
                                        @endif
                                    </table>
                                </div>

                                <div class="col-md-4  float-left">
                                    <br>
                                    <br>

                                    <p>Prepared By:_____________<br />
                                        Date:____________________
                                    </p>
                                </div>
                                <div class="col-md-6 text-center">
                                </div>
                                <div class="col-md-2  ">
                                    <br>
                                    <br>
                                    <p>Approved By:________________<br />
                                        Date:_________________</p>
                                </div>

                                <hr>


                                <div class="col-md-12 bg-success" style="text-align: center">
                                    Thank you for choosing {{ $companyInfo->company_name ?? 'N/A' }} products.
                                    We believe you will be satisfied by our services.
                                </div>
                                <!-- /.col -->



                            </div>
                            <!-- Table row -->

                        </div>

                    </div>
                </div>
            </div>

        @endif
        <!-- /.col-->
    </div>
@endsection

@section('scripts')
    <script>
        $(function() {

            //-------------
            //- DONUT CHART -
            //-------------
            // Get context with jQuery - using jQuery's .get() method.
            var donutChartCanvas = $('#donutChart').get(0).getContext('2d')
            var donutData = {
                labels: [
                    'Complete',
                    'InComplete',

                ],
                datasets: [{
                    data: [{{ $compleate ?? 0 }}, {{ $incomplate ?? 0 }}],
                    backgroundColor: ['#00a65a', '#f56954'],
                }]
            }
            var donutOptions = {
                maintainAspectRatio: false,
                responsive: true,
            }
            //Create pie or douhnut chart
            // You can switch between pie and douhnut using the method below.
            new Chart(donutChartCanvas, {
                type: 'doughnut',
                data: donutData,
                options: donutOptions
            })
            //-------------
            //- PIE CHART -
            //-------------
            // Get context with jQuery - using jQuery's .get() method.
            var pieChartCanvas = $('#pieChart').get(0).getContext('2d')
            var pieData = donutData;
            var pieOptions = {
                maintainAspectRatio: false,
                responsive: true,
            }
            //Create pie or douhnut chart
            // You can switch between pie and douhnut using the method below.
            new Chart(pieChartCanvas, {
                type: 'pie',
                data: pieData,
                options: pieOptions
            })



        })

        $(function() {
            var datasets = [{
                label: "Profit/Loss",
                data: ["{{ $curentprofit ?? 0 }}", "{{ $buject ?? 0 }}"],
                backgroundColor: ["#3F88C5"] // 配列にしておく必要がある
            }];

            // 各棒グラフの値がプラスかマイナスかによって色分け
            for (var i = 0; i < datasets[0].data.length; i++) {
                if (datasets[0].data[i] > 0) {
                    datasets[0].backgroundColor[i] = "#3F88C5"; // 値がプラスの場合は青
                } else {
                    datasets[0].backgroundColor[i] = "#FF5E5B"; // 値がマイナスの場合は赤
                }
            }

            /* ーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーー
              グラフ描画
            ーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーー */

            var ctx = document.getElementById("myChart");
            var myChart = new Chart(ctx, {
                type: "bar",
                data: {
                    labels: [
                        "{{ $projectDetails->pname ?? '' }}",
                    ],
                    datasets: datasets
                }
            });


        })
    </script>
    @include('backend.pages.reports.excel')
@endsection
