<input type="hidden" name="production_setup_id" value="{{ $production->production_setup_id }}">
<table class="table table-bordered mt-3">
    <thead>
        <tr>
            <th width="5%">Sl</th>
            <th width="20%">Warehouse</th>
            <th width="20%">Goods Name</th>
            <th width="10%">Requested Qty</th>
            <th width="10%">Pending Qty</th>
            <th width="10%">Received Qty</th>

        </tr>
    </thead>
    <tbody>
        @php

            $groupedDetails = $production->details->groupBy('good_id')->map(function ($group) {
                $first = $group->first(); // Get one instance for access to related data
                return (object) [
                    'good_id' => $first->good_id,
                    'goods' => $first->goods,
                    'production_requsition_id' => $first->production_requsition_id,
                    'qty' => $group->sum('qty'),
                ];
            });

        @endphp
        @foreach ($groupedDetails as $key => $details)
        @php
            $stock = App\Models\ProductionStock::where("production_requsiton_id", $details->production_requsition_id)
                        ->where("goods_id", $details->good_id)
                        ->first();
    
            $pendingQty = $details->qty - ($stock->qty ?? 0);
        @endphp
    
        @if($pendingQty > 0)
            <tr>
                <td>{{ $key + 1 }}</td>
                <td>
                    <select name="warehouse[]" class="form-control warehouse-select" data-good-id="{{ $details->good_id }}"
                        data-qty="{{ $details->qty }}">
                        <option value="">Select</option>
                        @foreach ($warehouse as $ware)
                            <option value="{{ $ware->id }}">{{ $ware->name }}</option>
                        @endforeach
                    </select>
                    <small class="text-info stock-status"></small>
                </td>
                <td>{{ $details->goods->name ?? '' }} <input type="hidden" name="goods_id[]" value="{{ $details->good_id }}"> </td>
                <td>{{ $details->qty ?? '' }} <input type="hidden" name="requested_qty[]" value="{{ $details->qty }}"> </td>
                <td>{{ $pendingQty }} <input type="hidden" name="qty[]" value="{{ $pendingQty }}"> </td>
                <td>{{ $stock->qty ?? 0 }} <input type="hidden" name="recived_qty[]" value="{{ $stock->qty ?? 0 }}"> </td>
            </tr>
        @endif
    @endforeach
    
    </tbody>
</table>

<script>
    $(document).ready(function() {
        $('.warehouse-select').on('change', function() {
            let warehouseId = $(this).val();
            let goodId = $(this).data('good-id');
            let qty = $(this).data('qty');
            let statusEl = $(this).siblings('.stock-status');

            if (!warehouseId) return;

            $.ajax({
                url: "{{ route('production.requsition.approvalcheck.stock') }}", // Define this route
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    warehouse_id: warehouseId,
                    good_id: goodId,
                    required_qty: qty
                },
                success: function(res) {
                    if (res.status === 'available') {
                        statusEl.text('Available in stock').removeClass('text-danger')
                            .addClass('text-success');
                    } else {
                        statusEl.text('Only ' + res.available_qty +
                                ' available. Need to purchase ' + res.missing_qty)
                            .removeClass('text-success').addClass('text-danger');
                    }
                },
                error: function() {
                    statusEl.text('Error checking stock').removeClass('text-success')
                        .addClass('text-danger');
                }
            });
        });
    });
</script>
