@extends('backend.layouts.master')
@section('title')
    Production - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
@endsection

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Inventory </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        @if (helper::roleAccess('production.requsition.index'))
                            <li class="breadcrumb-item"><a href="{{ route('production.requsition.index') }}">Production</a>
                            </li>
                        @endif
                        <li class="breadcrumb-item active"><span>Requsition List</span></li>
                        <li class="breadcrumb-item active"><span>Invoice</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">

            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Product use Invoice</h3>

                </div>
                <div class="card-body">
                    <div class="row no-print">
                        <div class="col-12">
                            <a onclick="window.print()" target="_blank" class="btn btn-default float-right my-2"><i
                                    class="fas fa-print"></i>
                                Print</a>
                        </div>
                    </div>
                    <div class="invoice p-3 mb-3">

                        <!-- info row -->
                        <div class="row invoice-info">
                            <div class="col-sm-12 ">
                                @if (isset($companyInfo->invoice_logo))
                                    <a href="{{ route('home') }}">
                                        <img width="200px"
                                            src="{{ asset('/backend/invoicelogo/' . $companyInfo->invoice_logo) }}"
                                            style="" alt="">
                                    </a>
                                @endif
                            </div>
                            <div class="col-sm-6 mt-5 invoice-col" style="text-align: left">
                                <b style="font-size : 20px">{{ $companyInfo->company_name ?? 'N/A' }}</b>
                                <address>
                                    Address : <strong><em>{{ $companyInfo->address ?? 'N/A' }}</em></strong><br>
                                    Phone : <strong>{{ $companyInfo->phone ?? 'N/A' }}</strong><br>
                                    Email: <strong>{{ $companyInfo->email ?? 'N/A' }}</strong>
                                </address>
                            </div>
                            <!-- /.col -->
                            <!-- /.col -->
                            <div class="col-sm-6 mt-5 invoice-col" style="text-align:right">
                                <b style="text-decoration: underline">Receive Invoice </b><br>
                                <b>Date : {{ $invoice->created_at ?? 'N/A' }} </b><br>
                                <b>Invoice : {{ $invoice->invoice ?? 'N/A' }}</b><br>

                            </div>
                            <!-- /.col -->
                        </div><br>
                        <!-- /.row -->

                        <!-- /.row -->

                        <!-- Table row -->
                        <div class="row">
                            <div class="col-12 table-responsive">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>SL</th>
                                            <th>Product</th>
                                            <th>Goods</th>
                                            <th>Qty</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                             $qty = 0;
                                        @endphp
                                        @foreach ($invoice->details as $key => $details)
                                            @php
                                                $qty += $details->qty;
                                            @endphp
                                            <tr>
                                                <td>{{ $key ?? '' }}</td>
                                                <td>{{ $details->product->name ?? '' }}</td>
                                                <td>{{ $details->goods->name ?? '' }}</td>
                                                <td>{{ $details->qty ?? '' }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td align="right"><b>Total:</b></td>
                                            <td></td>
                                            <td></td>
                                            <td>{{$qty}}</td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>



                            <div class="col-md-4 text-center float-left">
                                <br>
                                <br>

                                <p>Received by:_____________<br />
                                    Date:____________________
                                </p>
                            </div>
                            <div class="col-md-4 text-center">
                            </div>
                            <div class="col-md-4 text-center float-right">
                                <br>
                                <br>
                                <p>Authorized by:________________<br />
                                    Date:_________________</p>
                            </div>

                            <hr>


                            <div class="col-md-12 bg-success" style="text-align: center">
                                Thank you for choosing {{ $companyInfo->company_name ?? 'N/A' }} products.
                                We believe you will be satisfied by our services.
                            </div>
                            <!-- /.col -->
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->

                        <!-- this row will not appear when printing -->

                    </div>
                </div>

            </div>
        </div>
        <!-- /.col-->
    </div>
@endsection
@section('scripts')
@endsection
