@extends('backend.layouts.master')

@section('title')
Production - {{ $title }}
@endsection


@section('navbar-content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">
                    Production </h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                    @if (helper::roleAccess('production.production.index'))
                    <li class="breadcrumb-item"><a href="{{ route('production.production.index') }}">Production List</a>
                    </li>
                    @endif
                    <li class="breadcrumb-item active"><span>Edit Production</span></li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
@endsection

@section('admin-content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <h4>Edit Production Setup</h4>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('production.setup.update', $productionSetup->id) }}">
                @csrf

                <div class="mb-3">
                    <label>Setup Name</label>
                    <input type="text" name="name" class="form-control" value="{{ $productionSetup->name }}" required>
                </div>
                <div class="mb-3">
                    <label>Setup Date</label>
                    <input type="date" name="setup_date" class="form-control" value="{{ $productionSetup->setup_date }}" required>
                </div>

                <div id="products-wrapper">
                    @foreach ($productionSetup->products as $i => $item)
                        <div class="row mb-2 product-entry">
                            <div class="col-md-6">
                                <select name="products[{{ $i }}][product_id]" class="form-control">
                                    @foreach ($products as $product)
                                        <option value="{{ $product->id }}" {{ $item->id == $product->id ? 'selected' : '' }}>
                                            {{ $product->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4">
                                <input type="number" name="products[{{ $i }}][quantity]" class="form-control" value="{{ $item->pivot->quantity ?? 0 }}"  required>
                            </div>
                            <div class="col-md-2">
                                @if ($i > 0)
                                    <button type="button" class="btn btn-danger btn-sm remove-entry">Remove</button>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>

                <div class="d-flex justify-content-between mt-3">
                    <button type="submit" class="btn btn-success">Update Setup</button>
                    <button type="button" id="add-more" class="btn btn-secondary">+ Add Another Product</button>
                </div>
            </form>
        </div>
    </div>
</div>


<script>
    let index = 1;
    document.getElementById('add-more').addEventListener('click', function () {
        const wrapper = document.getElementById('products-wrapper');
        const div = document.createElement('div');
        div.classList.add('row', 'mb-2', 'product-entry');
        div.innerHTML = `
            <div class="col-md-6">
                <select name="products[${index}][product_id]" class="form-control">
                    @foreach ($products as $product)
                        <option value="{{ $product->id }}">{{ $product->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4">
                <input type="number" name="products[${index}][quantity]" class="form-control" placeholder="Quantity" min="1" required>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-danger btn-sm remove-entry">Remove</button>
            </div>
        `;
        wrapper.appendChild(div);
        index++;
    });

    document.addEventListener('click', function (e) {
        if (e.target && e.target.classList.contains('remove-entry')) {
            e.target.closest('.product-entry').remove();
        }
    });
</script>
@endsection
