<table class="table table-bordered mt-3">
    <thead>
        <tr>
            <th width="5%">Sl</th>
            <th width="20%">Product Name</th>
            <th width="0%">CCt</th>
            <th width="0%">Wattage</th>
            <th width="0%">Body Color</th>
            <th width="10%">Qty</th>
            <th width="50%">Goods</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($production->products as $key => $details)
            <tr>
                <td>{{ $key + 1 }}</td>
                <td>{{ $details->name }}</td>
                <td>{{ $details->pivot->cct ?? '' }}</td>
                <td>{{ $details->pivot->wattage ?? '' }}</td>
                <td>{{ $details->pivot->body_color ?? '' }}</td>
                <td>{{ $details->pivot->quantity ?? '' }}</td>
                <td>
                    <input type="hidden" name="products[{{ $key }}][product_id]" value="{{ $details->id }}">

                    <table class="table goodsTable">
                        <tbody>
                            <tr class="goodsRow">
                                <td>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label>Goods</label>
                                            <select name="products[{{ $key }}][goods][0][good_id]"
                                                class="select2 form-control">
                                                @foreach ($goods as $good)
                                                    <option value="{{ $good->id }}">{{ $good->goodsCode }} - {{ $good->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-4">
                                            <label>Qty</label>
                                            <input type="number" name="products[{{ $key }}][goods][0][qty]"
                                                class="form-control" min="1" value="1">
                                        </div>
                                        <div class="col-md-2">
                                            <div class="input-group-append mt-4">
                                                <button class="btn btn-success btn-plus" type="button"
                                                    id="increaseQty">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>

<script>
$(document).ready(function () {
    // Add new row on clicking plus button
    $('.goodsTable').on('click', '.btn-plus', function () {
        // Get parent context
        var table = $(this).closest('.goodsTable');
        var productIndex = table.closest('tr').index(); // Index of the main product row

        // Count current goods rows to set index
        var rowCount = table.find('.goodsRow').length;

        // Clone the first row
        var newRow = table.find('.goodsRow:first').clone();

        // Reset values
        newRow.find('select').val('');
        newRow.find('input[type="number"]').val(1);

        // Update name attributes with dynamic index
        newRow.find('select').attr('name', `products[${productIndex}][goods][${rowCount}][good_id]`);
        newRow.find('input[type="number"]').attr('name', `products[${productIndex}][goods][${rowCount}][qty]`);

        // Add remove button if not already there
        if (newRow.find('.btn-remove').length === 0) {
            newRow.find('.col-md-2').append(`
                <button class="btn btn-danger btn-remove mt-2" type="button">
                    <i class="fas fa-trash"></i>
                </button>
            `);
        }

        // Append the cloned row
        table.find('tbody').append(newRow);
    });

    // Remove the row on clicking the remove button
    $('.goodsTable').on('click', '.btn-remove', function () {
        $(this).closest('tr').remove();
    });
});

</script>
