@extends('backend.layouts.master')
@section('title')
    Production - {{ $title }}
@endsection
@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"> Production </h1>
                </div>
                <!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        @if (helper::roleAccess('production.requsition.index'))
                            <li class="breadcrumb-item"><a href="{{ route('production.requsition.index') }}">Production
                                    List</a>
                            </li>
                        @endif
                        <li class="breadcrumb-item active"><span>Add New Production</span></li>
                    </ol>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
@endsection
@section('admin-content')
    <div class="card">
        <div class="card-header">
            <h4>Create Production Setup</h4>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('production.requsition.store') }}">
                @csrf
                <div class="row">
                    <div class="col-md-6">
                        <label>Production List</label>
                        <select name="production_id" id="productionList" class="form-control select2">
                            <option disabled selected>---Select---</option>
                            @foreach ($productions as $production)
                                <option value="{{ $production->id }}">{{ $production->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-12">
                        <div id="productionDetails"></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <button class="btn btn-info mt-3" type="submit">Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('#productionList').on('change', function() {
                var productionId = $(this).val(); // Get selected production ID

                if (productionId) {
                    $.ajax({
                        url: '{{ route('production.requsition.getProductionDetails') }}', // Your route
                        type: 'GET',
                        data: {
                            id: productionId
                        },
                        success: function(response) {
                            // Insert the returned HTML into #productionDetails div
                            $('#productionDetails').html(response);
                        },
                        error: function() {
                            alert('Failed to fetch data');
                        }
                    });
                }
            });
        });


    </script>
@endsection
