@extends('backend.layouts.master')
@section('title')
    Production - {{ $title }}
@endsection
@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"> Production </h1>
                </div>
                <!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        @if (helper::roleAccess('production.setup.index'))
                            <li class="breadcrumb-item"><a href="{{ route('production.setup.index') }}">Production
                                    List</a>
                            </li>
                        @endif
                        <li class="breadcrumb-item active"><span>Add New Production</span></li>
                    </ol>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
@endsection
@section('admin-content')
    <div class="card">
        <div class="card-header">
            <h4>Create Production Setup</h4>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('production.setup.store') }}">
                @csrf
                <div class="mb-3">
                    <label>Setup Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label>Setup Date</label>
                    <input type="date" name="setup_date" class="form-control" required>
                </div>

                <div id="products-wrapper">
                    <div class="row mb-2 product-entry">
                        <div class="col-md-3">
                            <select name="products[0][product_id]" class="form-control proName">
                                @foreach ($products as $product)
                                    <option value="{{ $product->id }}">{{ $product->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select name="products[0][cct]" id="" class="form-control cct select2">

                            </select>
                        </div>
                        <div class="col-md-2">
                            <select name="products[0][wattage]" id="" class="form-control wattage select2">

                            </select>
                        </div>
                        <div class="col-md-2">
                            <select name="products[0][body_color]" id="" class="form-control  bodycolor select2">

                            </select>
                        </div>

                        <div class="col-md-2">
                            <input type="number" name="products[0][quantity]" class="form-control" placeholder="Quantity"
                                min="1" required>
                        </div>
                        <div class="col-md-2">
                            <!-- Empty for first entry -->
                        </div>
                    </div>
                </div>
                <div class="d-flex justify-content-between mt-3">
                    <button type="submit" class="btn btn-success">Save Setup</button>
                    <button type="button" id="add-more" class="btn btn-secondary">+ Add Another Product</button>
                </div>

            </form>
        </div>
    </div>

    <script>
        let index = 1;
        document.getElementById('add-more').addEventListener('click', function() {
            const wrapper = document.getElementById('products-wrapper');
            const div = document.createElement('div');
            div.classList.add('row', 'mb-2', 'product-entry');
            div.innerHTML = `
            <div class="col-md-3">
                <select name="products[${index}][product_id]" class="form-control proName">
                    @foreach ($products as $product)
                        <option value="{{ $product->id }}">{{ $product->name }}</option>
                    @endforeach
                </select>
            </div>
                 <div class="col-md-3">
                            <select name="products[${index}][cct]" id="" class="form-control cct select2">

                            </select>
                        </div>
                        <div class="col-md-2">
                            <select name="products[${index}][wattage]" id="" class="form-control wattage select2">

                            </select>
                        </div>
                        <div class="col-md-2">
                            <select name="products[${index}][body_color]" id="" class="form-control  bodycolor select2">

                            </select>
                        </div>
            <div class="col-md-2">
                <input type="number" name="products[${index}][quantity]" class="form-control" placeholder="Quantity" min="1" required>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-danger btn-sm remove-entry">Remove</button>
            </div>
        `;
            wrapper.appendChild(div);
            index++;
        });

        document.addEventListener('click', function(e) {
            if (e.target && e.target.classList.contains('remove-entry')) {
                e.target.closest('.product-entry').remove();
            }
        });


    </script>
    <script>
               $(document).ready(function() {
            $(document).on('change', ".proName", function() {
                let selectedProductID = $(this).val();
                let self = $(this);
                $.ajax({
                    url: '{{ route('find.cct') }}',
                    type: 'GET',
                    data: {
                        product_id: selectedProductID
                    },
                    success: function(response) {
                        console.log('product +', response);


                        let cctOptions = `<option selected value="0">--Select CCT--</option>`;
                        let wattageOptions =
                            `<option selected value="0">--Select Wattage--</option>`;
                        let bodyColorOptions =
                            `<option selected value="0">--Select Body Color--</option>`;

                        response.details.forEach(function(item) {
                            if (item.cct) {
                                cctOptions +=
                                    `<option value="${item.cct}">${item.cct}</option>`;
                            }
                            if (item.wattage) {
                                wattageOptions +=
                                    `<option value="${item.wattage}">${item.wattage}</option>`;
                            }
                            if (item.body_color) {
                                bodyColorOptions +=
                                    `<option value="${item.body_color}">${item.body_color}</option>`;
                            }
                        });

                        self.closest(".row").find('.cct').html(cctOptions);
                        self.closest(".row").find('.wattage').html(wattageOptions);
                        self.closest(".row").find('.bodycolor').html(bodyColorOptions);
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', error);
                    }
                });
            });
        })
    </script>
@endsection
