<h5 class="text-center" style="    margin-top: 20px;
    background: #209161;
    color: #fff;">Available Goods</h5>
<div class="row justify-content-center mt-3">

    @foreach ($productionstocks as $details)
        <div class="col-md-4">
            <div class="card shadow rounded-3">
                <div class="card-body text-center">
                    <h5 class="card-title"> <b> Product Name: </b> {{ $details->goods->name ?? '' }}</h5>
                    <p class="card-text mb-0">
                        <strong>Quantity:</strong>
                        <span class="available-qty" data-good-id="{{ $details->goods_id }}">
                            {{ $details->qty ?? '' }}
                        </span>
                    </p>
                </div>
            </div>
        </div>
    @endforeach

</div>

<table class="table table-bordered mt-3">
    <thead>
        <tr>
            <th width="5%">Sl</th>
            <th width="20%">Product Name</th>
            <th width="10%">Qty</th>
            <th width="50%">Use Goods</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($production->products as $key => $details)
            <tr>
                <td>{{ $key + 1 }}</td>
                <td>{{ $details->name }}
                    <br>
                    <b>CCt:</b> {{ $details->pivot->cct ?? '' }} <br>

                    <b>Body Color:</b> {{ $details->pivot->body_color ?? '' }} <br>
                    <b>Wattage :</b> {{ $details->pivot->wattage ?? '' }}

                    <input type="hidden" name="cct[]" value="{{ $details->pivot->cct ?? '' }}">
                    <input type="hidden" name="body_color[]" value="{{ $details->pivot->body_color ?? '' }}">
                    <input type="hidden" name="wattage[]" value="{{ $details->pivot->wattage ?? '' }}">
                </td>
                <td>
                    @php
                        $local =
                            $finisshingDetails->where('product_id', $details->pivot->product_id)->sum('product_qty') ??
                            0;
                        $stock = $details->pivot->quantity - $local;
                    @endphp

                    @if (!($stock <= 0))
                        Remaining: {{ $details->pivot->quantity - $local ?? '' }}
                        <input type="text" name="make_qty[]" placeholder="Make Qty" class="form-control">
                    @endif
                    <p style="color: #209161"> Make:  {{ $local }}</p>
                </td>
                <td>
                    <input type="hidden" name="products[{{ $key }}][product_id]"
                        value="{{ $details->id }}">

                    <table class="table goodsTable">
                        <tbody>
                            <tr class="goodsRow">
                                <td>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label>Goods</label>
                                            <select name="products[{{ $key }}][goods][0][good_id]"
                                                class="form-control good-select">
                                                @foreach ($goods as $good)
                                                    <option value="{{ $good->id }}">{{ $good->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-4">
                                            <label>Qty</label>
                                            <input type="number" name="products[{{ $key }}][goods][0][qty]"
                                                class="form-control use-qty" value="0">
                                        </div>
                                        <div class="col-md-2">
                                            <div class="input-group-append mt-4">
                                                <button class="btn btn-success btn-plus" type="button"
                                                    id="increaseQty">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>

<script>
    $(document).ready(function() {
        // Add new row on clicking plus button
        $('.goodsTable').on('click', '.btn-plus', function() {
            // Get parent context
            var table = $(this).closest('.goodsTable');
            var productIndex = table.closest('tr').index(); // Index of the main product row

            // Count current goods rows to set index
            var rowCount = table.find('.goodsRow').length;

            // Clone the first row
            var newRow = table.find('.goodsRow:first').clone();

            // Reset values
            newRow.find('select').val('');
            newRow.find('input[type="number"]').val(1);

            // Update name attributes with dynamic index
            newRow.find('select').attr('name',
                `products[${productIndex}][goods][${rowCount}][good_id]`);
            newRow.find('input[type="number"]').attr('name',
                `products[${productIndex}][goods][${rowCount}][qty]`);

            // Add remove button if not already there
            if (newRow.find('.btn-remove').length === 0) {
                newRow.find('.col-md-2').append(`
                <button class="btn btn-danger btn-remove mt-2" type="button">
                    <i class="fas fa-trash"></i>
                </button>
            `);
            }

            // Append the cloned row
            table.find('tbody').append(newRow);
        });

        // Remove the row on clicking the remove button
        $('.goodsTable').on('click', '.btn-remove', function() {
            $(this).closest('tr').remove();
        });
    });
</script>

<script>
    let goodsUsageMap = {};

    function updateAvailableQty() {
        // Reset all available quantities
        $('.available-qty').each(function() {
            const goodId = $(this).data('good-id');
            const originalQty = $(this).data('original'); // We'll set this next
            $(this).text(originalQty); // Reset to original
        });

        // Loop over all selected goods and their qtys
        goodsUsageMap = {};

        $('.goodsTable .goodsRow').each(function() {
            const goodId = $(this).find('.good-select').val();
            const qty = parseInt($(this).find('.use-qty').val()) || 0;

            if (goodId) {
                goodsUsageMap[goodId] = (goodsUsageMap[goodId] || 0) + qty;
            }
        });

        // Now subtract from available
        for (const goodId in goodsUsageMap) {
            const usedQty = goodsUsageMap[goodId];
            const $available = $(`.available-qty[data-good-id="${goodId}"]`);
            const originalQty = $available.data('original');
            $available.text(originalQty - usedQty);
        }
    }

    $(document).ready(function() {
        // Store original qty
        $('.available-qty').each(function() {
            $(this).data('original', parseInt($(this).text()));
        });

        // Event listener for qty or good select changes
        $('.goodsTable').on('input change', '.use-qty, .good-select', function() {
            updateAvailableQty();
        });

        // After adding new row, reattach events
        $('.goodsTable').on('click', '.btn-plus', function() {
            // Your existing code for cloning the row...

            setTimeout(() => {
                updateAvailableQty();
            }, 100); // Slight delay to allow DOM to update
        });

        // On removing row, also update
        $('.goodsTable').on('click', '.btn-remove', function() {
            $(this).closest('.goodsRow').remove();
            updateAvailableQty();
        });
    });

    $('.goodsTable').on('input change', '.use-qty, .good-select', function() {
        const $row = $(this).closest('.goodsRow');
        const goodId = $row.find('.good-select').val();
        const $input = $row.find('.use-qty');

        if (goodId) {
            const $available = $(`.available-qty[data-good-id="${goodId}"]`);
            const originalQty = parseInt($available.data('original')) || 0;

            // Calculate total used for this good (excluding current input for revalidation)
            let totalUsed = 0;
            $('.goodsTable .goodsRow').each(function() {
                const rowGoodId = $(this).find('.good-select').val();
                const rowQty = parseInt($(this).find('.use-qty').val()) || 0;
                if (rowGoodId === goodId && this !== $row[0]) {
                    totalUsed += rowQty;
                }
            });

            const remaining = originalQty - totalUsed;
            let inputVal = parseInt($input.val()) || 0;

            if (inputVal < 1) {
                $input.val(0);
                inputVal = 0;
            }

            if (inputVal > remaining) {
                $input.val(remaining > 0 ? remaining : 0);
            }
        }

        updateAvailableQty();
    });
</script>
