@extends('backend.layouts.master')

@section('title')
  {{ __('Goods') . ' - ' . $title}}
@endsection

@section('styles')
  <style>
    .bootstrap-switch-large { width: 200px; }
  </style>
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ __('Goods') }} </h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{route('home') }}">{{ __('Dashboard') }}</a>
            </li>
            @if(helper::roleAccess('inventorySetup.goods.index'))
              <li class="breadcrumb-item">
                <a href="{{route('inventorySetup.goods.index') }}">{{ __('Goods') }}</a>
              </li>
            @endif
            <li class="breadcrumb-item active">
              <span>{{ $title }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">{{ $title }}</h3>
          <div class="card-tools">
            @if(helper::roleAccess('inventorySetup.goods.create'))
              <a class="btn btn-tool btn-default" href="{{ route('inventorySetup.goods.create') }}">
                <i class="fas fa-plus"></i>
                <span>{{ __('Add New') }}</span>
              </a>
            @endif
            <a class="btn btn-tool btn-default" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </a>
            <a class="btn btn-tool btn-default" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div><!-- /.card-header -->
        <div class="card-body">
          <span id="buttons"></span>
          <div class="table-responsive mt-2">
            <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
              <thead>
                <tr>
                  <th>{{ __('SL') }}</th>
                  <th>{{ __('Goods Name') }}</th>
                  <th>{{ __('Goods Code') }}</th>
                  <th>{{ __('Category Name') }}</th>
                  {{-- <th>{{ __('Unit Name') }}</th> --}}
                  <!--<th>{{ __('Purchases Price') }}</th>-->
                  <!--<th>{{ __('Sale Price') }}</th>-->
                  <th>{{ __('Status') }}</th>
                  <th>{{ __('Action') }}</th>
                </tr>
              </thead>
              <tbody></tbody>
              <tfoot>
                <tr>
                  <th>{{ __('SL') }}</th>
                  <th>{{ __('Goods Name11') }}</th>
                  <th>{{ __('Goods Code') }}</th>
                  <th>{{ __('Category Name') }}</th>
                  {{-- <th>{{ __('Unit Name') }}</th> --}}
                  <!--<th>{{ __('Purchases Price') }}</th>-->
                  <!--<th>{{ __('Sale Price') }}</th>-->
                  <th>{{ __('Status') }}</th>
                  <th>{{ __('Action') }}</th>
                </tr>
              </tfoot>
            </table>
          </div>
        </div><!-- /.card-body -->
        <div class="card-footer"></div>
      </div>
    </div><!-- /.col-->
  </section>
@endsection
@section('scripts')
@include('backend.pages.inventories.goods.script')
@endsection