@extends('backend.layouts.master')

@section('title')
  {{ __('Inventory') . ' - ' . $title}}
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{('Inventory')}} </h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{ route('home') }}">{{ __('Dashboard') }}</a>
            </li>
            @if(helper::roleAccess('inventorySetup.goods.index'))
              <li class="breadcrumb-item">
                <a href="{{route('inventorySetup.goods.index')}}">{{ __('Goods List') }}</a>
              </li>
            @endif
            <li class="breadcrumb-item active">
              <span>{{ $title }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  @php
    $editInfo->attributeSkip = true;
  @endphp

  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">{{ __('Goods List') }}</h3>
          <div class="card-tools">
            @if(helper::roleAccess('inventorySetup.goods.create'))
              <a class="btn btn-default" href="{{ route('inventorySetup.goods.create') }}">
                <i class="fas fa-plus"></i>
                <span>{{ __('Add New') }}</span>
              </a>
            @endif
            <span id="buttons"></span>
            <a class="btn btn-tool btn-default" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </a>
            <a class="btn btn-tool btn-default" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div><!-- /.card-header -->
        <div class="card-body">
          <form class="needs-validation" method="POST" action="{{ route('inventorySetup.goods.update',$editInfo->id) }}" novalidate enctype="multipart/form-data" >
            @csrf
            <div class="row">
              <div class="col-md-9">
                <div class="form-row">

                 <div class="col-md-12 mb-3">
                    <label for="validationCustom01">{{ __('Goods Code * :') }}</label>
                    <input type="text" name="goodsCode" class="form-control" id="" value="{{ $editInfo->goodsCode }}" />
                  </div>
                  <div class="col-md-6 mb-3">
                    <label for="validationCustom01">{{ __('Name * :') }}</label>
                    <input type="text" name="name" class="form-control form-control-sm" id="validationCustom01" placeholder="Name" value="{{  $editInfo->name }}" />
                    @error('name')
                      <span class=" error text-red text-bold">{{ $message }}</span>
                    @enderror
                  </div>
                  <div class="col-md-6 mb-3">
                    <label for="validationCustom01">{{ __('Category Name * :') }}</label>
                    <select name="genre_id" id="" class="form-control select2">
                      @foreach($genres as $key => $value)
                        <option @if($editInfo->genre_id == $value->id) selected @endif value="{{$value->id}}">{{ $value->name}}</option>
                      @endforeach
                    </select>
                    @error('genre_id')
                      <span class=" error text-red text-bold">{{ $message }}</span>
                    @enderror
                  </div>
                  {{-- <div class="col-md-6 mb-3">
                    <label for="validationCustom01">{{ __('Unit Name * :') }}</label>
                    <select name="unit_id" id="" class="form-control select2">
                      @foreach($units as $key => $value)
                        <option @if($editInfo->unit_id == $value->id) selected @endif value="{{$value->id}}">{{$value->name}}</option>
                      @endforeach
                    </select>    
                    @error('unit_id')
                      <span class=" error text-red text-bold">{{ $message }}</span>
                    @enderror
                  </div> --}}
                  <div class="col-md-6 mb-3 d-none">
                    <label for="validationCustom01">{{ __('Purchases Price * :') }}</label>
                    <input type="number" class="form-control form-control-sm" value="{{$editInfo->purchases_price}}" name="purchases_price">
                    @error('purchases_price')
                      <span class=" error text-red text-bold">{{ $message }}</span>
                    @enderror
                  </div>
                  <div class="col-md-6 mb-3 d-none">
                    <label for="validationCustom01">{{ __('Sale Price * :') }}</label>
                    <input type="number" class="form-control form-control-sm"  value="{{$editInfo->sale_price}}" name="sale_price" />
                    @error('sale_price')
                      <span class=" error text-red text-bold">{{ $message }}</span>
                    @enderror
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="col-md-12 mb-3">
                  <label for="exampleInputFile">{{ __('Thumbnail :') }}</label>
                  <div class="input-group input-group-sm">
                    <div class="custom-file">
                      <input type="file" name="thumbnail" class="custom-file-input" id="exampleInputFile" accept=".jpg, .jpeg, .png, .gif, .webp" />
                      <label class="custom-file-label" for="exampleInputFile">{{ __('Choose file') }}</label>
                    </div>
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="card">
                    <div class="card-body position-relative px-1 py-1">
                      <img src="{{ $editInfo->thumbnail != null ? asset('uploads/goods/'. $editInfo->thumbnail) : 'https://via.placeholder.com/230x165' }}" class="img-fluid w-100" height="165px" alt="Thumbnail" />
                      <button type="button" class="btn btn-sm btn-danger rounded-circle position-absolute unlink" id="unlink" style="margin-left: -8px; margin-top: -15px;" unlink-route="{{ route('inventorySetup.product.deleteThumbnail', $editInfo->id) }}" >
                        <i class="fas fa-times"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            {{-- <div class="form-row mt-3">
              <div class="col-md-12 text-right">
                <button class="btn btn-info addProduct" type="button">
                  <i class="fas fa-plus"></i>
                  <span>{{ __('Add Sub Product') }}</span>
                </button> 
              </div>
              <div class="col-md-12 mb-3">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th scope="col">{{ __('Name') }}</th>
                      <th scope="col">{{ __('Purchases Price') }}</th>
                      <th scope="col">{{ __('Sale Price') }}</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach ($editInfo->subproduct as $value)
                      @php
                        $value->attributeSkip = true;
                      @endphp
                      <tr>
                        <td>
                          <input type="hidden" class="form-control form-control-sm" value="{{$value->id}}" name="product_id_old[]" />
                          <input type="text" class="form-control form-control-sm" value="{{$value->name}}" name="product_name_old[]" />
                        </td>
                        <td>
                          <input type="number" class="form-control form-control-sm" value="{{$value->purchases_price}}" name="purchases_price_old[]">
                        </td>
                        <td>
                          <input type="number" class="form-control form-control-sm" value="{{$value->sale_price}}" name="sale_price_old[]" />
                        </td>
                      </tr>
                    @endforeach
                  </tbody>
                </table>
              </div>
            </div> --}}
            <button class="btn btn-info" type="submit">
              <i class="fa fa-save"></i>
              <span>&nbsp; {{ __('Update') }}</span>
            </button>
          </form>
        </div><!-- /.card-body -->
        <div class="card-footer"></div>
      </div>
    </div><!-- /.col-->
  </section>
@endsection


@section('scripts')
  {{-- <script>
    $(document).ready(function(){
      $(document).on('click','.addProduct',function(){
        let html =`<tr>
          <td>
            <input type="text" class="form-control form-control-sm" value="" name="product_name[]" />
          </td>
          <td>
            <input type="number" class="form-control form-control-sm" name="purchases_price[]" />
          <td>
            <input type="number" class="form-control form-control-sm" name="sale_price[]" />
          </td>              
        </tr>`;
        $('tbody').append(html);
      })
      $(document).on('click','.removeProduct',function(){
        if(confirm('Are You Sure')){
          $(this).closest('tr').remove();
        }
      })
    })
        
  </script> --}}
@endsection