@extends('backend.layouts.master')
@section('title')
    Settings - {{ $title }}
@endsection

@section('styles')
<style>
    .bootstrap-switch-large {
        width: 200px;
    }
    .toggle-switch {
        position: relative;
        display: inline-block;
        width: 60px;
        height: 34px;
    }
    .toggle-switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }
    .slider {
        position: absolute;
        cursor: pointer;
        top: 0; left: 0; right: 0; bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 34px;
    }
    .slider:before {
        position: absolute;
        content: "";
        height: 26px; width: 26px;
        left: 4px; bottom: 4px;
        background-color: white;
        transition: .4s;
        border-radius: 50%;
    }
    input:checked + .slider {
        background-color: #2196F3;
    }
    input:checked + .slider:before {
        transform: translateX(26px);
    }
</style>
@endsection

@section('navbar-content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6"><h1 class="m-0">Employee Manage</h1></div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                    @if (helper::roleAccess('hrm.employee.index'))
                    <li class="breadcrumb-item"><a href="{{ route('hrm.employee.index') }}">Employee</a></li>
                    @endif
                    <li class="breadcrumb-item active"><span id="page-title">Employee List</span></li>
                </ol>
            </div>
        </div>
    </div>
</div>
@endsection

@section('admin-content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <h3 class="card-title" id="card-title">Employee List</h3>
                <div class="card-tools">
                  

                    <a class="btn btn-default" href="{{ route('hrm.employee.create') }}">
                        <i class="fas fa-plus"></i> Add New
                    </a>
                    <span id="buttons"></span>
                    <a class="btn btn-tool btn-default" data-card-widget="collapse"><i class="fas fa-minus"></i></a>
                    <a class="btn btn-tool btn-default" data-card-widget="remove"><i class="fas fa-times"></i></a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="userTable" class="display table-hover table table-bordered table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>SL</th>
                                <th>Name</th>
                                <th>ID Card</th>
                                <th>Phone</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($users as $data)
                            <tr>
                                <td>{{ $loop->index + 1 }}</td>
                                <td>{{ $data->name }}</td>
                                <td>{{ $data->id_card }}</td>
                                <td>{{ $data->personal_phone }}</td>
                                <td>
                                    <!-- Soft Delete button -->
                                    {{-- <button type="button" class="btn btn-danger btn-xs delete-btn" data-id="{{ $data->id }}" title="Delete">
                                        <i class="fas fa-trash-alt"></i>
                                    </button> --}}

                                    <!-- Restore button (only show if user is deleted) -->
                                    @if($data->deleted_at)
                                     @if(helper::roleAccess('hrm.employee.restore'))
                                    <button type="button" class="btn btn-success btn-xs restore-btn" data-id="{{ $data->id }}" title="Restore">
                                        <i class="fas fa-undo"></i>
                                    </button>
                                    @endif
                                    <!-- Force Delete button -->
                                     @if(helper::roleAccess('hrm.employee.force-delete'))
                                    <button type="button" class="btn btn-danger btn-xs force-delete-btn" data-id="{{ $data->id }}" title="Permanent Delete">
                                        <i class="fas fa-times"></i>
                                    </button>
                                    @endif
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                 <th>SL</th>
                                <th>Name</th>
                                <th>ID Card</th>
                                <th>Phone</th>
                                <th>Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <div class="card-footer"></div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    let showDeleted = false;

    // Initialize DataTable with export buttons
    var table = $('#userTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
        order: [],
    });

    // Append buttons container
    table.buttons().container().appendTo('#buttons');


   

    // Restore User
    $(document).on('click', '.restore-btn', function() {
        let userId = $(this).data('id');
        let restoreRoute = "{{ url('admin/hrm-employe-restore') }}/" + userId;

        Swal.fire({
            title: 'Restore User?',
            text: "This user will be restored and made active again.",
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, restore it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: restoreRoute,
                    type: 'get',
                    data: {_token: '{{ csrf_token() }}'},
                    success: function(response) {
                        if(response.success){
                            Swal.fire('Restored!', response.message, 'success');
                            location.reload();
                        } else {
                            Swal.fire('Error!', response.message, 'error');
                        }
                    },
                    error: function(xhr){
                        Swal.fire('Error!', 'Something went wrong.', 'error');
                    }
                });
            }
        });
    });

    // Force Delete User (Permanent)
    $(document).on('click', '.force-delete-btn', function() {
        let userId = $(this).data('id');
        let forceDeleteRoute = "{{ url('admin/hrm-employe-forceDelete') }}/" + userId;

        Swal.fire({
            title: 'Permanently Delete?',
            text: "This action cannot be undone! The user will be permanently deleted from the database.Also Delete All transcation Under this customer",
            icon: 'error',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete permanently!',
            input: 'text',
            inputPlaceholder: 'Type "DELETE" to confirm',
            preConfirm: (inputValue) => {
                if(inputValue !== 'DELETE'){
                    Swal.showValidationMessage('You need to type "DELETE" to confirm!');
                    return false;
                }
                return true;
            }
        }).then((result) => {
            if(result.isConfirmed){
                $.ajax({
                    url: forceDeleteRoute,
                    type: 'DELETE',
                    data: {_token: '{{ csrf_token() }}'},
                 success: function(response) {
    Swal.fire({
        icon: response.success ? 'success' : 'error',
        title: response.message,
        timer: 2000,
        showConfirmButton: false
    }).then(() => {
        if (response.success) {
            location.reload();
        }
    });
},
error: function(xhr) {
    let message = 'An error occurred!';
    if (xhr.responseJSON && xhr.responseJSON.message) {
        message = xhr.responseJSON.message;
    }
    Swal.fire({
        icon: 'error',
        title: message,
        timer: 2500,
        showConfirmButton: false
    });
}

                });
            }
        });
    });
});
</script>
@endsection
