@extends('backend.layouts.master')
@section('title')
Hrm - {{$title}}
@endsection

@section('styles')
<style>
    .bootstrap-switch-large {
        width: 200px;
    }

    table.dataTable>thead>tr>th:not(.sorting_disabled), table.dataTable>thead>tr>td:not(.sorting_disabled)

 {
    padding-right: 16px;
}
</style>
@endsection

@section('navbar-content')

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">
                    Hrm </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home') }}">Dashboard</a></li>
                    @if(helper::roleAccess('inventorySetup.adjust.index'))
                    <li class="breadcrumb-item"><a href="{{route('hrm.employee.index') }}">Hrm</a>
                    </li>
                    @endif
                    <li class="breadcrumb-item active"><span>Employee List</span></li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
@endsection

@section('admin-content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <h3 class="card-title">Employee List</h3>
               
                <div class="card-tools">
                      @if(helper::roleAccess('hrm.employee.restorelist'))
                      <a class="btn btn-default" href="{{route('hrm.employee.restorelist')}}">Restore</a>
                      @endif
                    @if(helper::roleAccess('hrm.employee.create'))
                    <a class="btn btn-default" href="{{ route('hrm.employee.create') }}"><i class="fas fa-plus"></i>Add
                        New</a>
                    @endif
                    <span id="buttons"></span>
                    <a class="btn btn-tool btn-default" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </a>
                    <a class="btn btn-tool btn-default" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </a>
                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <div class="table-responsive">
                    <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>SL</th>
                                <th>Name</th>
                                <th >Date of Birth</th>
                                <th>Gender</th>
                                <th>Personal Phone</th>
                                <th>Office Phone</th>
                                <th>Nid</th>
                                <th>Email</th>
                                <th>Department</th>
                                <th>Present Address</th>
                                <th>Salary</th>
                                <th>Overtime</th>
                                <th>Join Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                        <tfoot>
                            <tr>
                                <th>SL</th>
                                <th>Name</th>
                                <th>Date of Birth</th>
                                <th>Gender</th>
                                <th>Personal Phone</th>
                                <th>Office Phone</th>
                                <th>Nid</th>
                                <th>Email</th>
                                <th>Department</th>
                                <th>Present Address</th>
                                <th>Salary</th>
                                <th>Join Date</th>
                                <th>Overtime</th>
                                <th>Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
     
        </div>
    </div>
</div>
@endsection
@section('scripts')
@include('backend.pages.hrm.employee.script')
@endsection