@extends('backend.layouts.master')
@section('title')
    Hrm - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }

        .payslip-container {
            width: 100%;
            margin: auto;
            /* border: 1px solid #000; */
            padding: 20px;
        }

        h2,
        h4 {
            text-align: center;
            margin: 0;
        }

        .company-info {
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }

        td,
        th {
            border: 1px solid #000;
            padding: 8px;
        }

        .no-border {
            border: none;
        }

        .bold {
            font-weight: bold;
        }

        .right-align {
            text-align: right;
        }

        .summary {
            display: flex;
            justify-content: space-between;
        }

        .net-salary {
            font-weight: bold;
            text-align: center;
            padding: 10px;
            border: 1px solid #000;
        }


    </style>
@endsection

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        HRM </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        {{-- @if (helper::roleAccess('inventorySetup.adjust.index'))
                            <li class="breadcrumb-item"><a href="{{ route('hrm.attendance.index') }}">Hrm</a>
                            </li>
                        @endif --}}
                        <li class="breadcrumb-item active"><span>{{ $title }}</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-body">
                    <div class="card-header">
                        <h4 class="card-title">Salary Payshit </h4>
                        <div class="card-tools">
                            <button class="btn btn-primary mb-2 text-right" onclick="printPayslip()">Print Payslip</button>
                            <span id="buttons"></span>
                            <a class="btn btn-tool btn-default" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </a>
                            <a class="btn btn-tool btn-default" data-card-widget="remove">
                                <i class="fas fa-times"></i>
                            </a>
                        </div>
                    </div>
                    <div class="card card-body">
                        <div class="payslip-container">

                            @php
                                $deduction = $pay->salary - $payable_Salary;
                            @endphp
                            <div>
                                <table border="1">
                                    <tr>
                                        <th colspan="5">
                                            <div class="company-info">
                                                <h2 class="company_name"> <b>Illumine Smart Technology Company Limited</b>
                                                </h2>
                                                <p class="address"> House-308, Road-04, Baridhara DOHS, Dhaka-1206. Contact:
                                                    +88028412266</p>
                                                <p class="email_url"> E-mail: info@illumine.com.bd | www.illumine.com.bd
                                                </p>
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th colspan="4" class="text-center">
                                            <h4> <b> Payslip for month of {{ date('F', strtotime($date)) }} </b></h4>
                                        </th>
                                        <th>Received By </th>
                                    </tr>
                                    <tr>
                                        <th colspan="2" width="50%"> <b> Pay Summary </b></th>
                                        <td colspan="2" rowspan="7" width="30%"> <b> Employee Net Salary:
                                                TK.{{ $pay->salary }} </b></td>
                                    </tr>
                                    <tr>
                                        <td>Employee Name:</td>
                                        <td>{{ $pay->name }}</td>
                                    </tr>
                                    <tr>
                                        <td>Designation:</td>
                                        <td>{{ $pay->position->name ?? '' }}</td>
                                    </tr>
                                    <tr>
                                        <td>Date of Joining:</td>
                                        <td>{{ $pay->join_date }}</td>
                                    </tr>
                                    <tr>
                                        <td>Pay Period:</td>
                                        <td>{{ date('M-y', strtotime($date)) }}</td>
                                    </tr>

                                    <tr>
                                        <td>Pay Date:</td>
                                        <td>{{ date('10/m/Y', strtotime($date)) }}</td>
                                    </tr>
                                    <tr>
                                        <td colspan="4"></td>
                                    </tr>
                                    <tr>
                                        <th>Earning</th>
                                        <th>Amount</th>
                                        <th>Deduction</th>
                                        <th>Amount</th>
                                    </tr>
                                    <tr>
                                        <td>Basic</td>
                                        <td style="text-align:right">{{ number_format($pay->salary * (60 / 100)) }} </td>
                                        <td>Professional Tax</td>
                                        <td style="text-align:right">0</td>
                                    </tr>
                                    <tr>
                                        <td>House Rent Allowance</td>
                                        <td style="text-align:right">{{ number_format($pay->salary * (28.57 / 100)) }}</td>
                                        <td>Income Tax</td>
                                        <td style="text-align:right">0</td>
                                    </tr>
                                    <tr>
                                        <td>Medical Allowance</td>
                                        <td style="text-align:right">{{ number_format($pay->salary * (7.14 / 100)) }}</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td>Other allowance</td>
                                        <td style="text-align:right">{{ number_format($pay->salary * (4.29 / 100)) }}</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr class="bold">
                                        <td>Gross Salary</td>
                                        <td style="text-align:right">{{ number_format($pay->salary) }}</td>
                                        <td>Total Deduction</td>
                                        <td style="text-align:right">{{ $deduction }}</td>
                                    </tr>
                                    <tr>
                                        <td colspan="4"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="color:#000"> <b> Net Pay :
                                                {{ ucfirst(numberToWords($payable_Salary)) }} Only ! </b></td>
                                        <td style="text-align:right"> {{ $payable_Salary }} </td>
                                    </tr>
                                </table>
                                {{-- <div class="net-salary">Employee Net Salary: TK.{{$pay->salary}}</div> --}}
                            </div>

                        </div>
                    </div>


                </div>
                <!-- /.card-body -->
            </div>
        </div>
        <!-- /.col-->
    </div>

    <script>
        function printPayslip() {
            const payslip = document.querySelector('.payslip-container');
            if (!payslip) {
                alert('Payslip content not found!');
                return;
            }

            const printWindow = window.open('', '_blank');

            if (!printWindow) {
                alert('Popup blocked! Please allow popups for this site.');
                return;
            }

            const content = `
            <html>
            <head>
                <title>Payslip</title>
                <style>
                    .bootstrap-switch-large {
            width: 200px;
        }

        .payslip-container {
            width: 100%;
            margin: auto;
            /* border: 1px solid #000; */
            padding: 20px;
        }

        h2,
        h4 {
            text-align: center;
            margin: 0;
        }

        .company-info {
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }

        td,
        th {
            border: 1px solid #000;
            padding: 8px;
        }

        .no-border {
            border: none;
        }

        .bold {
            font-weight: bold;
        }

        .right-align {
            text-align: right;
        }

        .summary {
            display: flex;
            justify-content: space-between;
        }

        .net-salary {
            font-weight: bold;
            text-align: center;
            padding: 10px;
            border: 1px solid #000;
        }
                td, th {
    border: 1px solid #000;
    padding: 1px 2px !important;
}
     .company_name {
            padding: 0px;
            margin: 0px;
        }

        .address {
            padding: 0px;
            margin: 0px;

        }

        .email_url {
            padding: 0px;
            margin: 0px;

        }
                </style>
            </head>
            <body onload="window.print(); window.close();">
                ${payslip.innerHTML}
            </body>
            </html>
            `;

            printWindow.document.open();
            printWindow.document.write(content);
            printWindow.document.close();
        }
    </script>
@endsection
