<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddExtraColumnsToEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->string('am_name')->nullable()->after('employee_status');
            $table->string('area')->nullable()->after('am_name');
            $table->string('device_id')->nullable()->after('area');
            $table->decimal('attendanceBonus', 10, 2)->default(0)->after('device_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
         Schema::table('employees', function (Blueprint $table) {
            $table->dropColumn(['am_name', 'area', 'device_id', 'attendanceBonus']);
        });
    }
}
