<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRecognitionDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('recognition_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('recognition_id'); // Foreign key to the recognition table
            $table->unsignedBigInteger('warehouse_id'); // Warehouse ID
            $table->unsignedBigInteger('goods_id'); // Product ID
            $table->unsignedBigInteger('production_id'); // Product ID
            $table->integer('requested_qty');
            $table->integer('qty');
            $table->integer('received_qty')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recognition_details');
    }
}
