<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductionRequsitionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('production_requsitions', function (Blueprint $table) {
            $table->id();
            $table->string("invoice");
            $table->foreignId("production_setup_id");
            $table->foreignId("created_by");
            $table->enum("status",["Pending","Approve","Cancel"]);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('production_requsitions');
    }
}
