<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGoodsPurchasesDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('goods_purchases_details', function (Blueprint $table) {
            $table->id();
            $table->integer('purchases_goods_id')->unsigned()->index();
            $table->foreignId('project_id')->nullable();
            $table->integer('branch_id')->unsigned()->index();
            $table->integer('product_id')->unsigned()->index();
            $table->date('date')->nullable();
            $table->float('unit_price', 12, 2)->nullable();
            $table->float('total_price', 12, 2)->nullable();
            $table->integer('quantity')->nullable();
            $table->enum('status', ['Active', 'Inactive', 'Pending', 'Cancel'])->default('Pending')->comment('default status set active , penidng status waiting for approbal');
            $table->integer('updated_by')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->integer('category_id')->nullable()->unsigned();
            $table->foreignId('supplier_id');
            $table->enum('purchasetype', ['local', 'imported'])->comment('Product purchase local or imported');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('goods_purchases_details');
    }
}
