<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

class ZktecoService
{
    protected $baseUrl;
    protected $username;
    protected $password;
    protected $token = null;

    public function __construct()
    {

        $this->baseUrl  = rtrim(env('ZKTECO_IP'), '/');
        $this->username = env('ZKTECO_USERNAME');
        $this->password = env('ZKTECO_PASSWORD');
    }

    /**
     * 
     */
    public function getToken()
    {

        if ($this->token) {
            return $this->token;
        }

        try {
            $response = Http::post($this->baseUrl . '/api-token-auth/', [
                'username' => $this->username,
                'password' => $this->password
            ]);

            if ($response->successful()) {
                $this->token = $response->json()['token'];
                return $this->token;
            }
        } catch (\Exception $e) {

            Log::error("ZKTeco Login Error: " . $e->getMessage());
        }

        return null;
    }

    /**
     * 
     * @param string $date (Format: Y-m-d)
     * @return array
     */
    public function getAttendanceLogs($date)
    {
        $token = $this->getToken();

        if (!$token) {
            return [];
        }

        try {
            $response = Http::timeout(60)
                ->withHeaders(['Authorization' => 'Token ' . $token])
                ->get($this->baseUrl . '/iclock/api/transactions/', [
                    'page_size'  => 5000,
                    'start_time' => $date . ' 00:00:00',
                    'end_time'   => $date . ' 23:59:59'
                ]);

            if ($response->successful()) {
                return $response->json()['data'];
            }
        } catch (\Exception $e) {
            Log::error("ZKTeco Fetch Error: " . $e->getMessage());
        }

        return [];
    }
}
