<?php

namespace App\Services\Sale;

use App\Repositories\Sale\SaleReturnRepositories;
use App\Rules\PhoneNumberValidationRules;
use Illuminate\Support\Facades\Validator;

class SaleReturnService
{

    /**
     * @var SaleRepositories
     */
    private $systemRepositories;

    /**
     * AdminCourseService constructor.
     * @param SaleRepositories $branchRepositories
     */
    public function __construct(SaleReturnRepositories $systemRepositories)
    {
        $this->systemRepositories = $systemRepositories;
    }

    /**
     * @param $request
     * @return mixed
     */
    public function getList($request)
    {
        return $this->systemRepositories->getList($request);
    }

    /**

      /**
     * @param $request
     * @return mixed
     */
    public function statusUpdate($request, $id)
    {
        return $this->systemRepositories->statusUpdate($request, $id);
    }

    public function statusValidation($request)
    {
        return [
            'id' => 'required',
            'status' => 'required',
        ];
    }

    /**
     * @param $request
     * @return array
     */
    public function storeValidation($request)
    {
        if ($request->payment_type == "Cash") {
            return [
                'date' => 'required',
                'invoice_no' => 'required',
                'branch_id' => 'required',
                'sub_warehouse_id' => 'nullable',
                'ledger_id' => 'required',
                'qty' => 'required',
                'proName' => 'required',
                'catName' => 'required',
                'payment_type' => 'nullable',
                'account_id' => 'nullable',
                'status' => 'nullable',
            ];
        } else {
            return [
                'date' => 'required',
                'invoice_no' => 'required',
                'branch_id' => 'required',
                'sub_warehouse_id' => 'nullable',
                'ledger_id' => 'required',
                'qty' => 'required',
                'proName' => 'required',
                'catName' => 'required',
                'payment_type' => 'nullable',
                'status' => 'nullable',
            ];
        }
    }

    /**
     * @param $id
     * @return array
     */
    public function updateValidation($request, $id)
    {
        if ($request->payment_type == "Cash") {
            return [
                'date' => 'required',
                'invoice_no' => 'required',
                'branch_id' => 'required',
                'sub_warehouse_id' => 'nullable',
                'customer_id' => 'required',
                'qty' => 'required',
                'proName' => 'required',
                'catName' => 'required',
                'payment_type' => 'required',
                'account_id' => 'required',
                'status' => 'nullable',
            ];
        } else {
            return [
                'date' => 'required',
                'invoice_no' => 'required',
                'branch_id' => 'required',
                'sub_warehouse_id' => 'nullable',
                'ledger_id' => 'required',
                'qty' => 'required',
                'proName' => 'required',
                'catName' => 'required',
                'payment_type' => 'nullable',
                'status' => 'nullable',
            ];
        }
    }

    /**
     * @param $request
     * @return \App\Models\Currency
     */
    public function store($request)
    {
        //dd($request->all());
        return $this->systemRepositories->store($request);
    }

    /**
     * @param $request
     * @return \App\Models\Currency
     */
    public function details($id)
    {

        return $this->systemRepositories->details($id);
    }

    /**
     * @param $request
     * @param $id
     */
    public function update($request, $id)
    {
        return $this->systemRepositories->update($request, $id);
    }

    /**
     * @param $request
     * @param $id
     */
    public function destroy($id)
    {
        return $this->systemRepositories->destroy($id);
    }
}
