<?php

namespace App\Services\Production;

use App\Repositories\Production\ProductionRepositories;
use App\Repositories\Production\ProductionRequsitionRepositories;

class ProductionRequsitionService

{

    /**
     * @var ProductionRepositories
     */
    private $systemRepositories;

    /**
     * AdminCourseService constructor.
     * @param ProductionRepositories $branchRepositories
     */
    public function __construct(ProductionRequsitionRepositories $systemRepositories)
    {

        $this->systemRepositories = $systemRepositories;
    }

    /**
     * @param $request
     * @return mixed
     */
    public function getList($request)
    {
        return $this->systemRepositories->getList($request);
    }


    public function statusUpdate($request, $id)
    {
        return $this->systemRepositories->statusUpdate($request, $id);
    }

    public function statusValidation($request)
    {
        return [
            'id' => 'required',
            'status' => 'required',
        ];
    }

    /**
     * @param $request
     * @return array
     */
    public function storeValidation($request)
    {
        return [
            'production_id' => 'required',
            'products' => 'required|array',
            'products.*.goods.*.good_id' => 'required',
            'products.*.goods.*.qty' => 'required',
        ];
    }

    /**
     * @param $id
     * @return array
     */
    public function updateValidation($request, $id)
    {
        return [
            'production_id' => 'required|exists:productions,id',
            'products' => 'required|array',
            'products.*.product_id' => 'required|exists:products,id',
            'products.*.goods' => 'required|array|min:1',
            'products.*.goods.*.good_id' => 'required|exists:goods,id',
            'products.*.goods.*.qty' => 'required|integer|min:1',
        ];
    }

    /**
     * @param $request
     * @return \App\Models\Currency
     */
    public function store($request)
    {
        // dd($request->all());
        return $this->systemRepositories->store($request);
    }

    /**
     * @param $request
     * @return \App\Models\Currency
     */
    public function details($id)
    {

        return $this->systemRepositories->details($id);
    }

    /**
     * @param $request
     * @param $id
     */
    public function update($request, $id)
    {
        return $this->systemRepositories->update($request, $id);
    }

    /**
     * @param $request
     * @param $id
     */
    public function destroy($id)
    {
        return $this->systemRepositories->destroy($id);
    }
}
