<?php

namespace App\Services\Production;

use App\Repositories\Production\ProductionRepositories;
use App\Repositories\Production\ProductionRequsitionApprovalRepositories;
use App\Repositories\Production\ProductionRequsitionRepositories;

class ProductionRequsitionApprovalService

{

    /**
     * @var ProductionRequsitionApprovalRepositories
     */
    private $systemRepositories;

    /**
     * AdminCourseService constructor.
     * @param ProductionRequsitionApprovalRepositories $branchRepositories
     */
    public function __construct(ProductionRequsitionApprovalRepositories $systemRepositories)
    {

        $this->systemRepositories = $systemRepositories;
    }

    /**
     * @param $request
     * @return mixed
     */
    public function getList($request)
    {
        return $this->systemRepositories->getList($request);
    }


    public function statusUpdate($request, $id)
    {
        return $this->systemRepositories->statusUpdate($request, $id);
    }

    public function statusValidation($request)
    {
        return [
            'id' => 'required',
            'status' => 'required',
        ];
    }

    /**
     * @param $request
     * @return array
     */
    public function storeValidation($request)
    {
        return [
            'production_requsition_id' => 'required',
            'production_setup_id' => 'required',
            'goods_id.*' => 'required',
            'qty.*' => 'required',
        ];
    }

    /**
     * @param $id
     * @return array
     */
    public function updateValidation($request, $id)
    {
        return [
            'production_requsition_id' => 'required',
            'warehouse.*' => 'required',
            'goods_id.*' => 'required',
            'qty.*' => 'required',
        ];
    }

    /**
     * @param $request
     * @return \App\Models\Currency
     */
    public function store($request)
    {
        // dd($request->all());
        return $this->systemRepositories->store($request);
    }

    /**
     * @param $request
     * @return \App\Models\Currency
     */
    public function details($id)
    {

        return $this->systemRepositories->details($id);
    }

    /**
     * @param $request
     * @param $id
     */
    public function update($request, $id)
    {
        return $this->systemRepositories->update($request, $id);
    }

    /**
     * @param $request
     * @param $id
     */
    public function destroy($id)
    {
        return $this->systemRepositories->destroy($id);
    }
}
