<?php

namespace App\Repositories\Sale;

use App\Helpers\Helper;
use App\Models\AccountTransaction;
use App\Models\Brand;
use App\Models\Commission;
use App\Models\CommissionRule;
use App\Models\customerLedger;
use App\Models\Sale;
use App\Models\sales_Details;
use App\Models\Stock;
use App\Models\StockSummary;
use App\Models\Transection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class SaleRepositories
{

    /**
     * @var user_id
     */
    private $user_id;

    /**
     * @var Brand
     */
    private $Sale;

    /**
     * CourseRepository constructor.
     * @param brand $esale
     */
    public function __construct(Sale $sales)
    {
        $this->Sale = $sales;
        //$this->middleware(function ($request, $next) {
        $this->user_id = 1; //auth()->user()->id;
        //  return $next($request);
        //});
    }

    /**
     * @param $request
     * @return mixed
     */
    public function getAllList()
    {
        $result = $this->Sale::latest()->get();
        return $result;
    }

    /**
     * @param $request
     * @return mixed
     */
    public function getList($request)
    {
        $columns = array(
            0 => 'id',
            1 => 'invoice_no',
        );

        $edit = Helper::roleAccess('sale.sale.edit') ? 1 : 0;
        $delete = Helper::roleAccess('sale.sale.destroy') ? 1 : 0;
        $view = Helper::roleAccess('sale.sale.show') ? 1 : 0;
        $chalan = Helper::roleAccess('sale.sale.challan') ? 1 : 0;
        $ced = $edit + $delete + $view + $chalan;

        $totalData = $this->Sale::count();

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        $auth = Auth::user();
        if (empty($request->input('search.value'))) {
            $Sale = $this->Sale::offset($start);

            $Sale = $Sale->limit($limit)
                ->orderBy("id", "desc");

            if ($request->date) {
                $Sale = $Sale->whereDate('date', $request->date);
            }
            if (auth()->user()->type == "Employee") {
                $Sale = $Sale->where('created_by', auth()->user()->id);
            }

            $Sale = $Sale->get();
            $totalFiltered = $this->Sale::count();
        } else {
            $search = $request->input('search.value');
            $Sale = $this->Sale::where('invoice_no', 'like', "%{$search}%")
                ->orWhereHas("details.product", function ($q) use ($search) {
                    $q->where("name", 'like', "%{$search}%");
                })->orWhereHas('customer', function ($q) use ($search) {
                    $q->where("account_name", 'like', "%{$search}%");
                });

            $Sale = $Sale->offset($start)
                ->limit($limit)
                ->orderBy("id", "desc")
                ->get();
            $totalFiltered = $this->Sale::where('invoice_no', 'like', "%{$search}%")->count();
        }

        $data = array();
        if ($Sale) {
            foreach ($Sale as $key => $esale) {
                $nestedData['id'] = $key + 1;
                $nestedData['invoice_no'] = $esale->invoice_no;
                $nestedData['po_invoice'] = $esale->po_invoice;
                $nestedData['date'] = $esale->date;
                $nestedData['branch_id'] = $esale->branch->branchCode . ' - ' . $esale->branch->name;
                $nestedData['customer_id'] = $esale->customer->account_name ?? "";



                $nestedData['qty'] = $esale->qty;
                $nestedData['sub_total'] = $esale->sub_total;
                $nestedData['discount'] = $esale->discount;
                $nestedData['net_total'] = $esale->net_total;
                $nestedData['partialPayment'] = $esale->partialPayment;
                $nestedData['grand_total'] = $esale->grand_total;
                // if ($esale->sale_type == 'Regular') {
                //     $nestedData['sale_type'] = '<span class="btn btn-info">' . $esale->sale_type . '</span>';
                // } else {
                //     $nestedData['sale_type'] = '<span class="btn btn-success">' . $esale->sale_type . '</span>';
                // }

                //  $nestedData['sale_type'] = $esale->sale_type;

                if ($ced != 0 && $esale->sale_type == 'Regular') :
                    if ($edit != 0) {
                        $edit_data = '<a href="' . route('sale.sale.edit', $esale->id) . '" class="btn btn-xs btn-default"><i class="fa fa-edit" aria-hidden="true"></i></a>';
                    } else {
                        $edit_data = '';
                    }

                    if ($view != 0) {
                        $view_data = '<a href="' . route('sale.sale.show', $esale->id) . '" class="btn btn-xs btn-default"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                    } else {
                        $view_data = '';
                    }
                    if ($chalan != 0) {
                        $deliChalan = '<a href="' . route('sale.sale.challan', $esale->id) . '" class="btn btn-xs btn-default"><i class="fas fa-truck" aria-hidden="true"></i></a>';
                    } else {
                        $deliChalan = '';
                    }

                    if ($delete != 0) {
                        $delete_data = '<a delete_route="' . route('sale.sale.destroy', $esale->id) . '" delete_id="' . $esale->id . '" title="Delete" class="btn btn-xs btn-default delete_row uniqueid' . $esale->id . '"><i class="fa fa-times"></i></a>';
                    } else {
                        $delete_data = '';
                    }
                    $nestedData['action'] = $edit_data . ' ' . $view_data . ' ' . $deliChalan . ' ' . $delete_data;
                else :
                    $nestedData['action'] = '';
                endif;
                $data[] = $nestedData;
            }
        }
        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data,
        );

        return $json_data;
    }

    /**
     * @param $request
     * @return mixed
     */
    public function details($id)
    {
        $result = $this->Sale::find($id);
        return $result;
    }

    public function store($request)
    {
        // dd($request->all());
        $finalprice = (array_sum($request->total) + $request->carrying_cost + $request->labor_bill);
        if ($request->discounttype == "percentage") {
            $request->discount =  ($request->discount /  100) * $finalprice;
        } else {
            $request->discount =  $request->discount;
        }
        $finalprice -= $request->discount;


        $accountbranch = $request->branch_id ?? 0;
        $request->branch_id = $request->sub_warehouse_id ?? $request->branch_id;

        $esale = new $this->Sale();
        $esale->invoice_no = $request->invoice_no;
        $esale->date = $request->date;
        $esale->po_invoice = $request->po_invoice;
        $esale->po_date = $request->po_date;
        $esale->branch_id =  $request->branch_id;
        $esale->ledger_id = $request->ledger_id;
        $esale->project_name = $request->project_name;
        $esale->project_address = $request->project_address;
        $esale->customer_id = $request->customer_id ?? 0;
        $esale->payment_type = $request->payment_type;
        $esale->qty = array_sum($request->qty);
        $esale->sub_total = array_sum($request->total);
        $esale->discount = $request->discount;
        $esale->vat = ($request->vat /  100) * $finalprice;

        if ($request->vat) {
            $finalprice +=  ($request->vat /  100) * $finalprice;
        }
        $esale->carrying_cost = $request->carrying_cost;
        $esale->labor_bill = $request->labor_bill;
        $esale->net_total = $finalprice;
        $esale->partialPayment = $request->partialPayment;
        $esale->grand_total = $finalprice;
        $esale->narration = $request->narration;
        $esale->created_by = Auth::user()->id;
        $esale->save();

        $Sale_id = $esale->id;

        $category_id = $request->catName;
        $proName = $request->proName;
        $subtotal = $request->unitprice;
        $grand_total = $request->total;
        $qty = $request->qty;
        $vat = $request->vat;

        for ($i = 0; $i < count($category_id); $i++) {
            $esaleDetail = new sales_Details();
            $esaleDetail->product_id = $proName[$i];
            $esaleDetail->qty = $qty[$i];
            $esaleDetail->purchasetype = 'imported';
            $esaleDetail->cct = $request->cct[$i];
            $esaleDetail->wattage = $request->wattage[$i];
            $esaleDetail->body_color = $request->bodyColor[$i];
            $esaleDetail->category_id = $category_id[$i];
            $esaleDetail->branch_id = $request->branch_id;
            $esaleDetail->rate = $subtotal[$i];
            $esaleDetail->vat = $vat[$i] ?? "";
            $esaleDetail->price = $grand_total[$i];
            $esaleDetail->Sale_id = $Sale_id;
            $esaleDetail->date = $request->date;
            $esaleDetail->save();

            $stock = new Stock();
            $stock->product_id = $proName[$i];
            $stock->quantity = $qty[$i];
            $stock->branch_id = $request->branch_id;
            $stock->unit_price = $subtotal[$i];
            $stock->total_price = $grand_total[$i];
            $stock->general_id = $Sale_id;
            $stock->date = $request->date;
            $stock->status = 'Sale';
            $stock->save();

            $existingCheck = StockSummary::where('product_id', $proName[$i])
                ->where('type', 'Branch')
                ->where('branch_id', $request->branch_id)
                ->where('purchasetype', 'imported')
                ->where('cct', $request->cct[$i] == "0" ? "null" : $request->cct[$i])
                ->where('body_color', $request->bodyColor[$i]  == "0" ? "null" : $request->bodyColor[$i])
                ->where('wattage', $request->wattage[$i] == "0" ? "null" : $request->wattage[$i])
                ->first();

            if (!empty($existingCheck) && $existingCheck->quantity > 0) {
                $newQty = $existingCheck->quantity - $qty[$i];

                StockSummary::where('product_id', $proName[$i])
                    ->where('type', 'Branch')
                    ->where('branch_id', $request->branch_id)
                    ->where('purchasetype', 'imported')
                    ->where('cct', $request->cct[$i] == "0" ? "null" : $request->cct[$i])
                    ->where('body_color', $request->bodyColor[$i]  == "0" ? "null" : $request->bodyColor[$i])
                    ->where('wattage', $request->wattage[$i] == "0" ? "null" : $request->wattage[$i])
                    ->update(['quantity' => $newQty]);
            }
        }

        $transaction['payment_invoice'] = $request->invoice_no;
        $transaction['invoice'] = $request->invoice_no;
        $transaction['table_id'] = $Sale_id;
        $transaction['account_id'] = getAccountByUniqueID(18)->id; // sale
        $transaction['type'] = 2;
        $transaction['branch_id'] = $accountbranch;
        $transaction['credit'] = $finalprice;
        $transaction['remark'] = $request->narration;
        $transaction['created_by'] = Auth::id();
        $transaction['created_at'] = $request->date;
        AccountTransaction::create($transaction);

        $transactionPay['payment_invoice'] = $request->invoice_no;
        $transactionPay['invoice'] = $request->invoice_no;
        $transactionPay['table_id'] = $Sale_id;
        $transactionPay['account_id'] = $request->ledger_id; // Account Receivable;
        $transactionPay['type'] = 2;
        $transactionPay['branch_id'] = $accountbranch;
        $transactionPay['debit'] =  $finalprice;
        $transactionPay['remark'] = $request->narration;
        $transactionPay['created_by'] = Auth::id();
        $transactionPay['created_at'] = $request->date;
        AccountTransaction::create($transactionPay);

        if ($request->payment_type == 'Cash') {
            $transection = new Transection();
            $transection->date = $request->date;
            $transection->account_id = $request->account_id;
            $transection->payment_id = $Sale_id;
            $transection->branch_id = $request->branch_id;
            $transection->type = 10;
            $transection->note = $request->narration;
            $transection->amount = array_sum($request->total) - $request->discount;
            $transection->debit = array_sum($request->total) - $request->discount;
            $transection->save();
        }

        return $esale;
    }


public function update($request, $id)
{
    try {
        DB::beginTransaction();

        // Calculate final price properly
        $finalprice = (array_sum($request->price) + ($request->carrying_cost ?? 0) + ($request->labor_bill ?? 0));

        // Handle discount calculation
        if ($request->discounttype == "percentage") {
            $discount = ($request->discount / 100) * $finalprice;
        } else {
            $discount = $request->discount ?? 0;
        }
        $finalprice -= $discount;

        // Handle VAT calculation
        $vatAmount = 0;
        if ($request->vat_percentage) {
            $vatAmount = ($request->vat_percentage / 100) * $finalprice;
            $finalprice += $vatAmount;
        }

        $accountbranch = $request->branch_id ?? 0;
        $request->branch_id = $request->sub_warehouse_id ?? $request->branch_id;

        // Update main sale record
        $esale = $this->Sale::find($id);
        $esale->invoice_no = $request->invoice_no;
        $esale->date = $request->date;
        $esale->po_date = $request->po_date;
        $esale->po_invoice = $request->po_invoice;
        $esale->branch_id = $request->branch_id;
        $esale->carrying_cost = $request->carrying_cost ?? 0;
        $esale->labor_bill = $request->labor_bill ?? 0;
        $esale->ledger_id = $request->ledger_id;
        $esale->project_name = $request->project_name;
        $esale->project_address = $request->project_address;
        $esale->payment_type = $request->payment_type;
        $esale->qty = array_sum($request->qty);
        $esale->sub_total = array_sum($request->price);
        $esale->discount = $discount;
        $esale->vat = $vatAmount;
        $esale->net_total = $finalprice;
        $esale->partialPayment = $request->partialPayment;
        $esale->grand_total = $finalprice;
        $esale->narration = $request->narration;
        $esale->updated_by = Auth::user()->id;
        $esale->save();

        $Sale_id = $esale->id;

        // FIRST: Restore stock for old items (before deleting)
        $slDetails = sales_Details::where('sale_id', $id)->get();
        foreach ($slDetails as $slDetail) {
            // Find the existing stock summary record with all matching criteria
            $existingStock = StockSummary::where('product_id', $slDetail->product_id)
                ->where('type', 'Branch')
                ->where('branch_id', $slDetail->branch_id)
                ->where('purchasetype', "imported")
                ->where('cct', $slDetail->cct == "0" ? "null" : $slDetail->cct)
                ->where('body_color', $slDetail->body_color == "0" ? "null" : $slDetail->body_color)
                ->where('wattage', $slDetail->wattage == "0" ? "null" : $slDetail->wattage)
                ->first();

            if ($existingStock) {
                // Restore the quantity by adding back the sold quantity
                $restoredQty = $existingStock->quantity + $slDetail->qty;
                $existingStock->update(['quantity' => $restoredQty]);
            }
        }

        // Delete old records
        Stock::where('general_id', $id)->where('status', 'Sale')->forceDelete();
        sales_Details::where('sale_id', $id)->delete();

        // Get request arrays
        $category_id = $request->catName;
        $proName = $request->proName;
        $subtotal = $request->unitprice;
        $grand_total = $request->price;
        $qty = $request->qty;
        $vat = $request->vat ?? [];

        // Remove the dd() statement - it was stopping execution
        // dd($request->all());

        // SECOND: Create new sale details and update stock
        for ($i = 0; $i < count($category_id); $i++) {
            // Create new sale detail
            $esaleDetail = new sales_Details();
            $esaleDetail->product_id = $proName[$i];
            $esaleDetail->qty = $qty[$i];
            $esaleDetail->cct = $request->cct[$i] ?? "0";
            $esaleDetail->wattage = $request->wattage[$i] ?? "0";
            $esaleDetail->body_color = $request->body_color[$i] ?? "0";
            $esaleDetail->category_id = $category_id[$i];
            $esaleDetail->branch_id = $request->branch_id;
            $esaleDetail->rate = $subtotal[$i];
            $esaleDetail->vat = $vat[$i] ?? "0";
            $esaleDetail->price = $grand_total[$i];
            $esaleDetail->Sale_id = $Sale_id;
            $esaleDetail->date = $request->date;
            $esaleDetail->save();

            // Create stock record
            $stock = new Stock();
            $stock->product_id = $proName[$i];
            $stock->quantity = $qty[$i];
            $stock->branch_id = $request->branch_id;
            $stock->unit_price = $subtotal[$i];
            $stock->total_price = $grand_total[$i];
            $stock->general_id = $Sale_id;
            $stock->date = $request->date;
            $stock->status = 'Sale';
            $stock->save();

            // Update stock summary (deduct new quantities)
            $existingCheck = StockSummary::where('product_id', $proName[$i])
                ->where('type', 'Branch')
                ->where('branch_id', $request->branch_id)
                ->where('purchasetype', "imported")
                ->where('cct', ($request->cct[$i] ?? "0") == "0" ? "null" : ($request->cct[$i] ?? "0"))
                ->where('body_color', ($request->body_color[$i] ?? "0") == "0" ? "null" : ($request->body_color[$i] ?? "0"))
                ->where('wattage', ($request->wattage[$i] ?? "0") == "0" ? "null" : ($request->wattage[$i] ?? "0"))
                ->first();

            if ($existingCheck && $existingCheck->quantity >= $qty[$i]) {
                $newQty = $existingCheck->quantity - $qty[$i];
                $existingCheck->update(['quantity' => $newQty]);
            } else {
                // Handle insufficient stock case
                throw new \Exception("Insufficient stock for product ID: " . $proName[$i]);
            }
        }

        // Delete old transactions
        AccountTransaction::where('table_id', $id)->where('type', 2)->delete();

        // Create new account transactions
        $transaction = [
            'payment_invoice' => $request->invoice_no,
            'invoice' => $request->invoice_no,
            'table_id' => $Sale_id,
            'account_id' => getAccountByUniqueID(18)->id, // sale
            'type' => 2,
            'branch_id' => $accountbranch,
            'credit' => $finalprice,
            'remark' => $request->narration,
            'created_by' => Auth::id(),
            'created_at' => $request->date,
        ];
        AccountTransaction::create($transaction);

        $transactionPay = [
            'payment_invoice' => $request->invoice_no,
            'invoice' => $request->invoice_no,
            'table_id' => $Sale_id,
            'account_id' => $request->ledger_id, // Account Receivable
            'type' => 2,
            'branch_id' => $accountbranch,
            'debit' => $finalprice,
            'remark' => $request->narration,
            'created_by' => Auth::id(),
            'created_at' => $request->date,
        ];
        AccountTransaction::create($transactionPay);

        // Handle cash transactions if needed
        if ($request->payment_type == 'Cash') {
            $transection = new Transection();
            $transection->date = $request->date;
            $transection->account_id = $request->account_id;
            $transection->payment_id = $Sale_id;
            $transection->branch_id = $request->branch_id;
            $transection->type = 10;
            $transection->note = $request->narration;
            $transection->amount = $finalprice;
            $transection->debit = $finalprice;
            $transection->save();
        }

        DB::commit();
        return $esale;

    } catch (\Throwable $th) {
        DB::rollBack();
        \Log::error('Sale update error: ' . $th->getMessage());
        throw $th; // Re-throw to handle in controller
    }
}
    public function statusUpdate($id, $status)
    {
        $esale = $this->Sale::find($id);
        $esale->status = $status;
        $esale->save();
        return $esale;
    }

    public function destroy($id)
    {
        try {
            DB::beginTransaction();
            $esale = $this->Sale::find($id);
            $slDetails = sales_Details::where('sale_id', $id)->get();
            foreach ($slDetails as $slDetail) {
                $quantitys =  StockSummary::where('product_id', $slDetail->product_id)->where('type', "Branch")->where('branch_id', $slDetail->branch_id)->where('purchasetype', $slDetail->purchasetype)->pluck('quantity')->first();
                $stocksum['quantity'] = abs($quantitys + $slDetail->qty);
                StockSummary::where('product_id', $slDetail->product_id)->where('type', "Branch")->where('branch_id', $slDetail->branch_id)->where('purchasetype', $slDetail->purchasetype)->update($stocksum);
            }
            Stock::where('general_id', $id)->Where('status', 'Sale')->forceDelete();
            sales_Details::where('sale_id', $id)->delete();

            customerLedger::where('sale_id', $id)->delete();
            AccountTransaction::where('table_id', $id)->where('type', 2)->delete();

            $esale->delete();
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
        }

        return true;
    }
    public function calculateCommission($saleId)
    {
        $sale = Sale::findOrFail($saleId);
        $commissionRule = CommissionRule::where('employee_id', ($sale->user->employee_id ?? 0))->first();

        if (!$commissionRule) {
            return false;
        }

        // Default commission amount calculation based on the rule's type
        switch ($commissionRule->commission_type) {
            case 'fixed':
                // Fixed percentage commission
                $commissionAmount = ($sale->total_amount * $commissionRule->fixed_percentage) / 100;
                break;

            case 'tiered':
                // Tiered commission
                $commissionAmount = $this->calculateTieredCommission($sale->total_amount, $commissionRule);
                break;

            case 'product_based':
                // Product-based commission
                $commissionAmount = $this->calculateProductBasedCommission($sale->products, $commissionRule);
                break;

            default:
                return false; // If no valid commission type, return false
        }

        // Create commission entry
        $commission = Commission::create([
            'employee_id' => $sale->user->employee_id,
            'sale_id' => $sale->id,
            'commission_amount' => $commissionAmount,
            'status' => 'pending'
        ]);
    }

    public function calculateTieredCommission($saleAmount, $commissionRule)
    {
        // Example: You can define the tiers in the commission rule or directly here
        $tiers = [
            100 => 5,    // 5% for the first $100
            500 => 10,   // 10% for $101 to $500
            1000 => 15   // 15% for amounts over $500
        ];

        $commissionAmount = 0;
        $remainingAmount = $saleAmount;

        foreach ($tiers as $limit => $percentage) {
            if ($remainingAmount > $limit) {
                $amountInTier = $remainingAmount - $limit;
                $commissionAmount += ($amountInTier * $percentage) / 100;
                $remainingAmount = $limit;
            }
        }

        // Add commission for the remaining amount
        if ($remainingAmount > 0) {
            $commissionAmount += ($remainingAmount * $commissionRule->fixed_percentage) / 100;
        }

        return $commissionAmount;
    }

    public function calculateProductBasedCommission($products, $commissionRule)
    {
        $commissionAmount = 0;

        foreach ($products as $product) {
            // Assuming each product has a commission_percentage field for the salesperson
            $commissionAmount += ($product->price * $product->commission_percentage) / 100;
        }

        return $commissionAmount;
    }
}
