<?php

namespace App\Repositories\Production;

use App\Helpers\Helper;
use App\Models\Conversion;
use App\Models\Product;
use App\Models\Production;
use App\Models\Transection;
use App\Models\customerLedger;
use App\Models\GoodsStockSummary;
use App\Models\ProductionRequsition;
use App\Models\ProductionSetup;
use App\Models\ProductionStock;
use App\Models\Recognition;
use App\Models\RecognitionDetail;
use App\Models\Stock;
use App\Models\StockSummary;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ProductionRequsitionApprovalRepositories
{

    /**
     * @var user_id
     */
    private $user_id;

    /**
     * @var Production
     */
    private $Production;

    /**
     * CourseRepository constructor.
     * @param Production $eProduction
     */
    public function __construct(Recognition $Productions)
    {
        $this->Production = $Productions;
        //$this->middleware(function ($request, $next) {
        $this->user_id = 1; //auth()->user()->id;
        //  return $next($request);
        //});
    }

    /**
     * @param $request
     * @return mixed
     */
    public function getAllList()
    {
        $result = $this->Production::latest()->get();
        return $result;
    }

    /**
     * @param $request
     * @return mixed
     */
    public function getList($request)
    {
        $columns = array(
            0 => 'id',
            1 => 'ProductionCode',
        );

        $edit = Helper::roleAccess('production.requsition.approval.edit') ? 0 : 0;
        $delete = Helper::roleAccess('production.requsition.approval.destroy') ? 1 : 0;
        $ced = $edit + $delete;

        $totalData = $this->Production::count();

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');

        if (empty($request->input('search.value'))) {
            $Production = $this->Production::offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                //->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->Production::count();
        } else {
            $search = $request->input('search.value');
            $Production = $this->Production::offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();
            $totalFiltered = $this->Production::count();
        }

        $data = array();
        if ($Production) {
            foreach ($Production as $key => $eProduction) {
                $nestedData['id'] = $key + 1;
                $nestedData['invoice'] = "RQA" . $eProduction->id;
                $nestedData['requisition_invoice'] = $eProduction->requsition->invoice ?? "";
                $nestedData['create_by'] = $eProduction->createBy->name ?? "";

                if ($ced != 0) :
                    if ($edit != 0) {
                        $edit_data = '<a href="' . route('production.requsition.approval.show', $eProduction->id) . '" class="btn btn-xs btn-default"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                    } else {
                        $edit_data = '';
                    }
                    if ($delete != 0) {
                        $delete_data = '<a delete_route="' . route('production.requsition.approval.destroy', $eProduction->id) . '" delete_id="' . $eProduction->id . '" title="Delete" class="btn btn-xs btn-default delete_row uniqueid' . $eProduction->id . '"><i class="fa fa-times"></i></a>';
                    } else {
                        $delete_data = '';
                    }
                    $nestedData['action'] = $edit_data . '' . '' . $delete_data;
                else :
                    $nestedData['action'] = '';
                endif;
                $data[] = $nestedData;
            }
        }
        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data,
        );

        return $json_data;
    }

    /**
     * @param $request
     * @return mixed
     */
    public function details($id)
    {
        $result = $this->Production::find($id);
        return $result;
    }

    public function store($request)
    {
        try {
            DB::beginTransaction();

            $recognition = new Recognition();
            $recognition->date = now();
            $recognition->production_requisition_id = auth()->user()->id;
            $recognition->production_requisition_id = $request->production_requsition_id;
            $recognition->save();

            foreach ($request->warehouse as $key => $branch) {

                $goods = GoodsStockSummary::where("branch_id", $branch)
                    ->where("product_id", $request->goods_id[$key])
                    ->first();
                if (isset($goods) && $goods->quantity >= $request->qty[$key]) {
                    $recognitionDetail = new RecognitionDetail();
                    $recognitionDetail->recognition_id = $recognition->id;
                    $recognitionDetail->warehouse_id = $branch;
                    $recognitionDetail->goods_id = $request->goods_id[$key];
                    $recognitionDetail->requested_qty = $request->requested_qty[$key];
                    $recognitionDetail->production_id = $request->production_setup_id;
                    $recognitionDetail->qty = $request->qty[$key];  // Correct usage of $qty
                    $recognitionDetail->received_qty = 0; // Default to 0
                    $recognitionDetail->save();
                    $branchs = GoodsStockSummary::where('branch_id', $branch)
                        ->where('product_id', $request->goods_id[$key])
                        ->first();

                        $branchs->quantity -= $request->qty[$key];
                        $branchs->save(); // Moved inside the loop ✅

                    $productstock = ProductionStock::where("production_id" , $request->production_setup_id)->where("goods_id",$request->goods_id[$key])->first();

                    if(!$productstock){
                        $productstock = new ProductionStock();
                    }

                    $productstock->production_id = $request->production_setup_id;
                    $productstock->production_requsiton_id = $request->production_requsition_id;
                    $productstock->goods_id = $request->goods_id[$key];
                    $productstock->qty += $request->qty[$key];
                    $productstock->save();
                }
            }


            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e->getMessage());
        }

        return redirect()->route('production.setup.index')->with('success', 'Production setup saved successfully!');
    }

    public function update($request, $id)
    {
        $setup = ProductionSetup::findOrFail($id);
        $setup->update([
            'name' => $request->name,
            'setup_date' => $request->setup_date,
        ]);

        // Delete old products and re-add them
        $setup->details()->delete();

        foreach ($request->products as $product) {
            $setup->products()->attach($product['product_id'], ['quantity' => $product['quantity']]);
        }

        return $setup;
    }

    public function statusUpdate($id, $status)
    {
        $eProduction = $this->Production::find($id);
        $eProduction->status = $status;
        $eProduction->save();
        return $eProduction;
    }

    public function destroy($id)
    {
        $eProduction = $this->Production::find($id);
        $eProduction->delete();
        return true;
    }
}
