<?php

namespace App\Repositories\InventorySetup;

use App\Helpers\Helper;
use App\Models\AccountTransaction;
use Illuminate\Support\Facades\Auth;
use App\Models\Brand;
use App\Models\GoodsPurchases;
use App\Models\GoodsPurchasesDetails;
use App\Models\GoodsStockSummary;
use App\Models\PurchaseOrder;
use App\Models\Purchases;
use App\Models\PurchasesDetails;
use App\Models\Stock;
use App\Models\StockSummary;
use App\Models\Supplier;
use App\Models\supplierLedger;
use App\Models\Transection;
use Illuminate\Support\Facades\DB;

class PurchaseGoodsRepositories
{
    /**
     * @var user_id
     */
    private $user_id;

    /**
     * @var Brand
     */
    private $purchases;

    /**
     * CourseRepository constructor.
     * @param brand $purchase
     */
    public function __construct(GoodsPurchases $purchases)
    {
        $this->purchases = $purchases;
        //$this->middleware(function ($request, $next) {
        $this->user_id = 1; //auth()->user()->id;
        //  return $next($request);
        //});
    }

    /**
     * @param $request
     * @return mixed
     */
    public function getAllList()
    {
        $result = $this->purchases::latest()->get();
        return $result;
    }

    /**
     * @param $request
     * @return mixed
     */
    public function getList($request)
    {
        $columns = array(
            0 => 'id',
            1 => 'invoice_no',
        );

        $edit = Helper::roleAccess('inventorySetup.goods.purchase.edit') ? 0 : 0;
        $delete = Helper::roleAccess('inventorySetup.goods.purchase.destroy') ? 1 : 0;
        $view = Helper::roleAccess('inventorySetup.goods.purchase.show') ? 1 : 0;
        $ced = $edit + $delete + $view;

        $totalData = $this->purchases::count();

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');

        $auth = Auth::user();

        if (empty($request->input('search.value'))) {
            $purchases = $this->purchases::offset($start);

            $purchases =  $purchases->limit($limit)
                ->orderBy($order, $dir);
            if ($request->date) {
                $purchases = $purchases->whereDate('date', $request->date);
            }
            $purchases = $purchases->get();
            $totalFiltered = $this->purchases::count();
        } else {
            $search = $request->input('search.value');
            $purchases = $this->purchases::where(function ($query) use ($search) {
                    $query->where('invoice_no', 'like', "%{$search}%")
                          ->orWhereHas("supplier", function ($q) use ($search) {
                              $q->where("account_name", 'like', "%{$search}%");
                          });
                });

            $purchases = $purchases
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();

            $totalFiltered = $this->purchases::where('invoice_no', 'like', "%{$search}%")->count();
        }


        $data = array();
        if ($purchases) {
            foreach ($purchases as $key => $purchase) {
                // dd($purchase->branch);
                $nestedData['id'] = $key + 1;
                $nestedData['invoice_no'] = $purchase->invoice_no;
                $nestedData['date'] = $purchase->date;
                $nestedData['branch'] = $purchase->branch->name ?? 'N/A';
                $nestedData['supplier'] = $purchase->supplier->account_name ?? 'N/A';
                $nestedData['payment_type'] = $purchase->payment_type;
                $nestedData['quantity'] = $purchase->quantity;
                $nestedData['subtotal'] = $purchase->subtotal;
                $nestedData['discount'] = $purchase->discount;
                $nestedData['grand_total'] = $purchase->grand_total;
                if ($purchase->status == 'Active') :
                    $status = '<input class="status_row" status_route="' . route('inventorySetup.goods.purchase.status', [$purchase->id, 'Inactive']) . '"   id="toggle-demo" type="checkbox" name="my-checkbox" checked data-bootstrap-switch data-off-color="danger" data-on-color="success">';
                else :
                    $status = '<input  class="status_row" status_route="' . route('inventorySetup.goods.purchase.status', [$purchase->id, 'Active']) . '"  id="toggle-demo" type="checkbox" name="my-checkbox"  data-bootstrap-switch data-off-color="danger" data-on-color="success">';
                endif;
                $nestedData['status'] = $status;
                if ($ced != 0) :
                    if ($edit != 0)
                        $edit_data = '<a href="' . route('inventorySetup.goods.purchase.edit', $purchase->id) . '" class="btn btn-xs btn-default"><i class="fa fa-edit" aria-hidden="true"></i></a>';
                    else
                        $edit_data = '';
                    if ($view = !0)
                        $view_data = '<a href="' . route('inventorySetup.goods.purchase.show', $purchase->id) . '" class="btn btn-xs btn-default"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                    else
                        $view_data = '';
                    if ($delete != 0)
                        $delete_data = '<a delete_route="' . route('inventorySetup.goods.purchase.destroy', $purchase->id) . '" delete_id="' . $purchase->id . '" title="Delete" class="btn btn-xs btn-default delete_row uniqueid' . $purchase->id . '"><i class="fa fa-times"></i></a>';
                    else
                        $delete_data = '';
                    $nestedData['action'] = $edit_data . ' ' . $view_data . ' ' . $delete_data;
                else :
                    $nestedData['action'] = '';
                endif;
                $data[] = $nestedData;
            }
        }
        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        return $json_data;
    }

    /**
     * @param $request
     * @return mixed
     */
    public function details($id)
    {
        $result = $this->purchases::find($id);
        return $result;
    }

    public function store($request)
    {

        DB::beginTransaction();
        try {
            $branch_id = $request->branch_id;
            $request->branch_id = $request->sub_warehouse_id ?? $request->branch_id;
            $purchase = new $this->purchases();
            $purchase->invoice_no = $request->invoice_no;
            $purchase->custom_invoice = $request->custom_invoice;
            $purchase->date = $request->date;
            $purchase->ledger_id = $request->ledger_id ?? 0;
            $purchase->branch_id = $request->branch_id ?? 0;
            $purchase->supplier_id = $request->supplier_id ?? 0;
            $purchase->quantity = array_sum($request->qty);
            $purchase->purchase_type = 'Direct';
            $purchase->subtotal = 0; //array_sum($request->unitprice)
            $purchase->grand_total = 0; //array_sum($request->total)
            $purchase->status = 'Active';
            $purchase->payment_type = $request->payment_type;
            $purchase->discount = $request->discount;
            $purchase->paid_amount = $request->paid_amount;
            $purchase->due_amount = $request->cart_due;
            $purchase->created_by = Auth::user()->id;
            $purchase->narration = $request->narration;

            if ($request->has('chart_of_account_id')) {
                $purchase->chart_of_account_id = $request->chart_of_account_id;
            }
            if ($request->has('account_number')) {
                $purchase->account_number = $request->account_number;
            }
            if ($request->has('check_number')) {
                $purchase->check_number = $request->check_number;
            }
            if ($request->has('bank')) {
                $purchase->bank = $request->bank;
            }
            if ($request->has('bank_branch')) {
                $purchase->bank_branch = $request->bank_branch;
            }
            if ($request->has('input_net_total')) {
                $purchase->net_total = $request->input_net_total;
            }
            $purchase->save();

            $purchases_id = $purchase->id;

            $category_id = $request->catName;
            $proName = $request->proName;
            $subtotal = $request->unitprice;
            $grand_total = $request->total;
            $qty = $request->qty;


            for ($i = 0; $i < count($proName); $i++) {
                $purchaseDetail = new GoodsPurchasesDetails();
                $purchaseDetail->product_id = $proName[$i];
                $purchaseDetail->category_id = $category_id[$i] ?? 0;
                $purchaseDetail->quantity = $qty[$i];


                $purchaseDetail->branch_id = $request->branch_id ?? 0;
                $purchaseDetail->unit_price = $subtotal[$i] ?? 0;
                $purchaseDetail->total_price = $grand_total[$i] ?? 0;
                $purchaseDetail->purchases_goods_id = $purchases_id;
                $purchaseDetail->date = $request->date;
                $purchaseDetail->created_by = Auth::user()->id;
                $purchaseDetail->save();

                // $stock = new Stock();
                // $stock->product_id = $proName[$i];
                // $stock->quantity = $qty[$i];
                // $stock->branch_id = $request->branch_id;
                // $stock->unit_price = $subtotal[$i];
                // $stock->total_price = $grand_total[$i];
                // $stock->general_id = $purchases_id;
                // $stock->date = $request->date;
                // $stock->status = 'Purchase';
                // $stock->created_by = Auth::user()->id;
                // $stock->save();

                $existingCheck = GoodsStockSummary::where('product_id', $proName[$i])->where('branch_id', $request->branch_id)->where('type', "Branch")->first();
                if (!empty($existingCheck)) :
                    $newQty = $existingCheck->quantity + $qty[$i];
                    GoodsStockSummary::where('product_id', $proName[$i])->where('branch_id', $request->branch_id)->where('type', "Branch")->update(array('quantity' => $newQty));
                else :
                    $stockSummary = new GoodsStockSummary();
                    $stockSummary->branch_id = $request->branch_id;
                    $stockSummary->product_id = $proName[$i];
                    $stockSummary->quantity = $qty[$i];
                    $stockSummary->type = "Branch";
                    $stockSummary->save();
                endif;
            }


            // $invoice = AccountTransaction::accountInvoice();
            // $transactionPay['payment_invoice'] = $request->invoice_no;
            // $transactionPay['invoice'] = $request->invoice_no;
            // $transactionPay['table_id'] = $purchases_id;
            // $transactionPay['account_id'] = getAccountByUniqueID(22)->id; // ->purchase
            // $transactionPay['type'] = 1;
            // $transactionPay['branch_id'] = $branch_id ?? 0;
            // $transactionPay['debit'] =  array_sum($request->total);
            // $transactionPay['remark'] = $request->narration;
            // $transactionPay['created_by'] = Auth::id();
            // $transactionPay['supplier_id'] = $request->supplier_id ?? 0;
            // $transactionPay['created_at'] = $request->date;
            // AccountTransaction::create($transactionPay);

            // $transaction['payment_invoice'] = $request->invoice_no;
            // $transaction['invoice'] = $request->invoice_no;
            // $transaction['table_id'] = $purchases_id;
            // $transaction['account_id'] = $request->ledger_id; // account payable
            // $transaction['type'] = 1;
            // $transaction['branch_id'] = $branch_id ?? 0;
            // $transaction['credit'] = (array_sum($request->total));
            // $transaction['remark'] = $request->narration;
            // $transaction['created_by'] = Auth::id();
            // $transaction['supplier_id'] = $request->supplier_id ?? 0;
            // $transaction['created_at'] = $request->date;
            // AccountTransaction::create($transaction);

            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e->getMessage());
            redirect('inventory-goods-purchase-create')->with('error', 'Something Wrong Please try again');
        }
        return $purchase;
    }





    public function update($request, $id)
    {
        DB::beginTransaction();
        try {
            $purchase = $this->purchases::findOrFail($id);
            $purchase->date = $request->date;
            $purchase->branch_id = $request->branch_id;
            $purchase->ledger_id = $request->ledger_id;
            $purchase->supplier_id = $request->supplier_id;
            $purchase->quantity = array_sum($request->qty);
            $purchase->subtotal = array_sum($request->unitprice);
            $purchase->grand_total = array_sum($request->total);
            $purchase->payment_type = $request->payment_type;
            $purchase->discount = $request->discount;
            $purchase->paid_amount = $request->paid_amount;
            $purchase->due_amount = $request->cart_due;
            $purchase->created_by = Auth::user()->id;
            $purchase->narration = $request->narration;

            if ($request->has('chart_of_account_id')) {
                $purchase->chart_of_account_id = $request->chart_of_account_id;
            }
            if ($request->has('account_number')) {
                $purchase->account_number = $request->account_number;
            }
            if ($request->has('check_number')) {
                $purchase->check_number = $request->check_number;
            }
            if ($request->has('bank')) {
                $purchase->bank = $request->bank;
            }
            if ($request->has('bank_branch')) {
                $purchase->bank_branch = $request->bank_branch;
            }
            if ($request->has('input_net_total')) {
                $purchase->net_total = $request->input_net_total;
            }
            $purchase->save();
            $purchases_id = $purchase->id;


            $category_id = $request->catName;
            $oldproName =  $request->oldproName;
            $oldqty =  $request->oldqty;
            $proName = $request->proName;
            $subtotal = $request->unitprice;
            $grand_total = $request->total;
            $qty = $request->qty;

            for ($w = 0; $w < count($oldproName); $w++) {
                // echo $oldproName[$i];
                $mywhereCondition = array(
                    'branch_id' => $request->old_branch_id,
                    'product_id' => $oldproName[$w],
                    'type' => 'Branch',
                );

                $oldstockupdate = StockSummary::where($mywhereCondition)->first();
                // dd($oldstockupdate);
                if($oldstockupdate){

                DB::table('stock_summaries')
                    ->where($mywhereCondition)
                    ->update(
                        ['quantity' => $oldstockupdate->quantity - $oldqty[$w]],
                    );
                }

            }

            PurchasesDetails::where('purchases_id', $purchase->id)->forceDelete();
            Stock::where('general_id', $purchase->id)->where('status', 'Purchase')->forceDelete();

            for ($i = 0; $i < count($category_id); $i++) {
                $purchaseDetail = new PurchasesDetails();
                $purchaseDetail->product_id = $proName[$i];
                $purchaseDetail->quantity = $qty[$i];
                $purchaseDetail->purchasetype = $request->purchasetype[$i];


                $purchaseDetail->cct = $request->cct[$i];
                $purchaseDetail->power = $request->power[$i];
                $purchaseDetail->cri = $request->cri[$i];
                $purchaseDetail->size = $request->size[$i];

                $purchaseDetail->branch_id = $request->branch_id;
                $purchaseDetail->unit_price = $subtotal[$i];
                $purchaseDetail->total_price = $grand_total[$i];
                $purchaseDetail->purchases_id = $purchases_id;
                $purchaseDetail->date = $request->date;
                $purchaseDetail->created_by = Auth::user()->id;
                $purchaseDetail->save();

                $stock = new Stock();
                $stock->product_id = $proName[$i];
                $stock->quantity = $qty[$i];
                $stock->branch_id = $request->branch_id;
                $stock->unit_price = $subtotal[$i];
                $stock->total_price = $grand_total[$i];
                $stock->general_id = $purchases_id;
                $stock->date = $request->date;
                $stock->status = 'Purchase';
                $stock->created_by = Auth::user()->id;
                $stock->save();

                $existingCheck = StockSummary::where('product_id', $proName[$i])->where('branch_id', $request->branch_id)->where('purchasetype', $request->purchasetype[$i])->where('type', 'Branch')->first();

                if (!empty($existingCheck) && $existingCheck->quantity >= 0) :
                    $newQty = $existingCheck->quantity + $qty[$i];
                    StockSummary::where('product_id', $proName[$i])->where('branch_id', $request->branch_id)->where('purchasetype', $request->purchasetype[$i])->where('type', 'Branch')->update(array('quantity' => $newQty));
                else :
                    $stockSummary = new StockSummary();
                    $stockSummary->branch_id = $request->branch_id;
                    $stockSummary->product_id = $proName[$i];
                    $stockSummary->purchasetype = $request->purchasetype[$i];
                    $stockSummary->quantity = $qty[$i];
                    $stockSummary->type = 'Branch';
                    $stockSummary->save();
                endif;
            }

            supplierLedger::where('purchase_id', $purchases_id)->delete();
            AccountTransaction::where('table_id', $purchases_id)->where('type', 1)->delete();

            $invoice = AccountTransaction::accountInvoice();
            $transactionPay['payment_invoice'] = $request->invoice_no;
            $transactionPay['invoice'] = $purchase->invoice_no;
            $transactionPay['table_id'] = $purchases_id;
            $transactionPay['account_id'] = getAccountByUniqueID(22)->id; // ->purchase
            $transactionPay['type'] = 1;
            $transactionPay['branch_id'] = $request->branch_id ?? 0;
            $transactionPay['debit'] =  array_sum($request->total);
            $transactionPay['remark'] = $request->narration;
            $transactionPay['created_by'] = Auth::id();
            $transactionPay['supplier_id'] = $request->supplier_id ?? 0;
            $transactionPay['created_at'] = $request->date;
            AccountTransaction::create($transactionPay);

            $transaction['payment_invoice'] = $request->invoice_no;
            $transaction['invoice'] = $purchase->invoice_no;
            $transaction['table_id'] = $purchases_id;
            $transaction['account_id'] = $request->ledger_id; // account payable
            $transaction['type'] = 1;
            $transaction['branch_id'] = $request->branch_id ?? 0;
            $transaction['credit'] = (array_sum($request->total));
            $transaction['remark'] = $request->narration;
            $transaction['created_by'] = Auth::id();
            $transaction['supplier_id'] = $request->supplier_id ?? 0;
            $transaction['created_at'] = $request->date;
            AccountTransaction::create($transaction);

            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();

            redirect('inventory-purchase-create')->with('error', 'Something Wrong Please try again' . $e->getMessage());
        }
        return $purchase;
    }

    public function statusUpdate($id, $status)
    {
        $purchase = $this->purchases::find($id);
        $purchase->status = $status;
        $purchase->save();
        return $purchase;
    }

    public function destroy($id)
    {
        DB::beginTransaction();
        try {
            $purchase = $this->purchases::find($id);
            if ($purchase->status == "Accepted") {
                session()->flash('error', "Sorry, you couldn't delete!!");
                DB::commit();
                return false;
            } else {
                $purchase->forceDelete();
                AccountTransaction::where('table_id', $id)->where('type', 1)->delete();
                $purchasedetails =  PurchasesDetails::where('purchases_id', $id)->get();

                foreach ($purchasedetails as  $val) {
                    $mywhereCondition = array(
                        'branch_id' => $val->branch_id,
                        'product_id' => $val->product_id,
                        'type' => 'Branch',
                    );

                    $oldstockupdate = StockSummary::where($mywhereCondition)->first();

                    DB::table('stock_summaries')
                        ->where($mywhereCondition)
                        ->update(
                            ['quantity' => $oldstockupdate->quantity - $val->quantity],
                        );

                    $val->forceDelete();
                }

                SupplierLedger::where('purchase_id', $id)->delete();
                Transection::where('payment_id', $id)->where('type', 11)->forceDelete();
                Stock::where('general_id', $purchase->id)->where('status', 'Purchase')->forceDelete();
                $purchaseorder['status'] = "Pending";
                PurchaseOrder::where('id', $purchase->purchase_order_id)->update($purchaseorder);
                DB::commit();
                return true;
            }
        } catch (\Throwable $e) {
            DB::rollBack();
            redirect('inventory-purchase-create')->with('error', 'Something Wrong Please try again' . $e->getMessage());
        }
        return true;
    }
}
