<?php

namespace App\Repositories\InventorySetup;

use App\Helpers\Helper;
use Illuminate\Support\Facades\Auth;
use App\Models\Goods;
use Illuminate\Support\Facades\DB;
use phpDocumentor\Reflection\PseudoTypes\False_;

class GoodsRepositories {
    /**
     * @var user_id
     */
    private $user_id;

    /**
     * @var Goods
     */
    private $goods;

    /**
     * CourseRepository constructor.
     * @param goods $goods
     */
    public function __construct(Goods $goods) {
        $this->goods = $goods;
        //$this->middleware(function ($request, $next) {
        $this->user_id = 1; //auth()->user()->id;
        //  return $next($request);
        //});
    }

    /**
     * @param $request
     * @return mixed
     */

    public function getList($request) {
        $columns = array(
            0 => 'id',
            1 => 'name',
            2 => 'goodsCode',
        );

        $edit = Helper::roleAccess('inventorySetup.goods.edit') ? 1 : 0;
        $delete = Helper::roleAccess('inventorySetup.goods.destroy') ? 1 : 0;
        $view = Helper::roleAccess('inventorySetup.goods.show') ? 0 : 0;
        $ced = $edit + $delete + $view;

        $totalData = $this->goods::count();

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');

        if (empty($request->input('search.value'))) {
            // $goodses = $this->goods::with('genre', 'unit')->offset($start)
            $goodses = $this->goods::with('genre')->offset($start)
                ->limit($limit)
                // ->where('parent_id',0)
                ->orderBy($order, $dir)
                //->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->goods::count();
        } else {
            $search = $request->input('search.value');
            // $goodses = $this->goods::with('genre', 'unit')->where('name', 'like', "%{$search}%")->orWhere('goodsCode', 'like', "%{$search}%")
            $goodses = $this->goods::with('genre')->where('name', 'like', "%{$search}%")->orWhere('goodsCode', 'like', "%{$search}%")
                ->offset($start)
                ->limit($limit)
                // ->where('parent_id',0)
                ->orderBy($order, $dir)
                // ->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->goods::where('name', 'like', "%{$search}%")->count();
        }



        $data = array();
        if ($goodses) {
            foreach ($goodses as $key => $goods) {
                $goods->attributeSkip = true;
                $nestedData['id'] = $key + 1;
                $nestedData['name'] =  $goods->name;
                $nestedData['goodsCode'] = $goods->goodsCode;
                $nestedData['genre'] = $goods->genre->name ?? "N/A";
                // $nestedData['unit'] = $goods->unit ? $goods->unit->name : "N/A";
                $nestedData['purchases_price'] = $goods->purchases_price ? number_format($goods->purchases_price, 2) . '/-' : "N/A";
                $nestedData['sale_price'] = number_format($goods->sale_price, 2) . '/-';
                if ($goods->status == 'Active') :
                    $status = '<input class="status_row" status_route="' . route('inventorySetup.goods.status', [$goods->id, 'Inactive']) . '"   id="toggle-demo" type="checkbox" name="my-checkbox" checked data-bootstrap-switch data-off-color="danger" data-on-color="success">';
                else :
                    $status = '<input  class="status_row" status_route="' . route('inventorySetup.goods.status', [$goods->id, 'Active']) . '"  id="toggle-demo" type="checkbox" name="my-checkbox"  data-bootstrap-switch data-off-color="danger" data-on-color="success">';
                endif;
                $nestedData['status'] = $status;
                if ($ced != 0) :
                    if ($edit != 0)
                        $edit_data = '<a href="' . route('inventorySetup.goods.edit', $goods->id) . '" class="btn btn-xs btn-default"><i class="fa fa-edit" aria-hidden="true"></i></a>';
                    else
                        $edit_data = '';
                    if ($view != 0)
                        $view_data = '<a href="' . route('inventorySetup.goods.show', $goods->id) . '" class="btn btn-xs btn-default"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                    else
                        $view_data = '';
                    if ($delete != 0)
                        $delete_data = '<a delete_route="' . route('inventorySetup.goods.destroy', $goods->id) . '" delete_id="' . $goods->id . '" title="Delete" class="btn btn-xs btn-default delete_row uniqueid' . $goods->id . '"><i class="fa fa-times"></i></a>';
                    else
                        $delete_data = '';
                    $nestedData['action'] = $edit_data . ' ' . $view_data . ' ' . $delete_data;
                else :
                    $nestedData['action'] = '';
                endif;
                $data[] = $nestedData;
            }
        }
        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        return $json_data;
    }
    /**
     * @param $request
     * @return mixed
     */
    public function details($id) {
        // $result = $this->goods::with('subproduct')->find($id);
        $result = $this->goods::find($id);
        return $result;
    }

    public function store($request) {
        // dd($request->all());
    //    try {
    //     DB::beginTransaction();
        $goods = new $this->goods();
        $goods->name = $request->name;
        $goods->goodsCode = $request->goodsCode;
        $goods->genre_id = $request->genre_id;
        $goods->purchases_price = $request->purchases_price;
        $goods->sale_price = $request->sale_price;
        $goods->status = 'Active';

        $thumbnail = $request->file('thumbnail');
        if($thumbnail != null) {
            $imgThumbnail = 'thumbnail_' . time() . '.' . $thumbnail->getClientOriginalExtension();
            $thumbnail->move(public_path('/uploads/goods/'), $imgThumbnail);
            $goods->thumbnail = $imgThumbnail;
        }

        $goods->created_by = Auth::user()->id;
        $goods->save();
    //    } catch (\Throwable $th) {
    //     DB::rollBack();
    //     dd($th->getMessage());
    //    }

        return $goods;
    }

    public function update($request, $id) {
        // dd($request->all());
        $goods = $this->goods::findOrFail($id);
        $goods->goodsCode = $request->goodsCode;
        $goods->name = $request->name;
        $goods->genre_id = $request->genre_id;
        // $goods->unit_id = $request->unit_id;
        $goods->purchases_price = $request->purchases_price;
        $goods->sale_price = $request->sale_price;
        $goods->status = 'Active';

        $thumbnail = $request->file('thumbnail');
        if($thumbnail != null) {
            // $imgThumbnail = pathinfo($thumbnail->getClientOriginalName(), PATHINFO_FILENAME) . '-' . time() . '.' . $thumbnail->getClientOriginalExtension();
            $imgThumbnail = 'thumbnail_' . time() . '.' . $thumbnail->getClientOriginalExtension();
            $thumbnail->move(public_path('/uploads/goods/'), $imgThumbnail);
            $goods->thumbnail = $imgThumbnail;
        }

        $goods->updated_by = Auth::user()->id;
        $goods->save();

        // DB::table('supplier_sale_prices')->where('product_id', $id)->delete();

        return $goods;
    }

    public function statusUpdate($id, $status) {
        $good = $this->goods::find($id);
        $good->status = $status;
        $good->save();
        return $good;
    }

    public function destroy($id) {
        $good = $this->goods::find($id);
        $good->delete();
        return true;
    }

    public function deleteThumbnail($id) {
        $good = $this->goods::find($id);
        if ($good->thumbnail) {
            $thumbnailPath = public_path('/uploads/goods/') . $good->thumbnail;
            if (file_exists($thumbnailPath)) {
                unlink($thumbnailPath);
                $good->thumbnail = null;
                $good->save();
                return true;
            }
        }
        return false;
    }
}
