<?php

namespace App\Repositories\InventorySetup;

use App\Helpers\Helper;
use Illuminate\Support\Facades\Auth;
use App\Models\Genre;
use phpDocumentor\Reflection\PseudoTypes\False_;

class GenreRepositories {
    /**
     * @var user_id
     */
    private $user_id;
    /**
     * @var Genre
     */
    private $genre;
    /**
     * CourseRepository constructor.
     * @param genre $genre
     */
    public function __construct(Genre $genre) {
        $this->genre = $genre;
        //$this->middleware(function ($request, $next) {
        $this->user_id = 1; //auth()->user()->id;
        //  return $next($request);
        //});
    }
    /**
     * @param $request
     * @return mixed
     */

    public function getAllList() {
        $result = $this->genre::with('parent')->latest()->get();
        return $result;
    }

    /**
     * @param $request
     * @return mixed
     */

    public function getList($request) {
        $columns = array(
            0 => 'id',
            1 => 'name',
        );

        $edit = Helper::roleAccess('inventorySetup.genre.edit') ? 1 : 0;
        $delete = Helper::roleAccess('inventorySetup.genre.destroy') ? 1 : 0;
        $view = Helper::roleAccess('inventorySetup.genre.show') ? 0 : 0;
        $ced = $edit + $delete + $view;

        $totalData = $this->genre::count();

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');

        if (empty($request->input('search.value'))) {
            $genres = $this->genre::offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                // ->orderBy('created_at', 'DESC')
                ->get();
            $totalFiltered = $this->genre::count();
        } else {
            $search = $request->input('search.value');
            $genres = $this->genre::where('name', 'like', "%{$search}%")
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                // ->orderBy('created_at', 'DESC')
                ->get();
            $totalFiltered = $this->genre::where('name', 'like', "%{$search}%")->count();
        }



        $data = array();
        if ($genres) {
            foreach ($genres as $key => $genre) {
                $nestedData['id'] = $key + 1;
                $nestedData['parent_id'] = $genre->parent->name ?? "Root";
                $nestedData['name'] = $genre->name;
                if ($genre->status == 'Active') :
                    $status = '<input class="status_row" status_route="' . route('inventorySetup.genre.status', [$genre->id, 'Inactive']) . '"   id="toggle-demo" type="checkbox" name="my-checkbox" checked data-bootstrap-switch data-off-color="danger" data-on-color="success">';
                else :
                    $status = '<input  class="status_row" status_route="' . route('inventorySetup.genre.status', [$genre->id, 'Active']) . '"  id="toggle-demo" type="checkbox" name="my-checkbox"  data-bootstrap-switch data-off-color="danger" data-on-color="success">';
                endif;
                $nestedData['status'] = $status;
                if ($ced != 0) :
                    if ($edit != 0)
                        $edit_data = '<a href="' . route('inventorySetup.genre.edit', $genre->id) . '" class="btn btn-xs btn-default"><i class="fa fa-edit" aria-hidden="true"></i></a>';
                    else
                        $edit_data = '';
                    if ($view != 0)
                        $view_data = '<a href="' . route('inventorySetup.genre.show', $genre->id) . '" class="btn btn-xs btn-default"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                    else
                        $view_data = '';
                    if ($delete != 0)
                        $delete_data = '<a delete_route="' . route('inventorySetup.genre.destroy', $genre->id) . '" delete_id="' . $genre->id . '" title="Delete" class="btn btn-xs btn-default delete_row uniqueid' . $genre->id . '"><i class="fa fa-times"></i></a>';
                    else
                        $delete_data = '';
                    $nestedData['action'] = $edit_data . ' ' . $view_data . ' ' . $delete_data;
                else :
                    $nestedData['action'] = '';
                endif;
                $data[] = $nestedData;
            }
        }
        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        return $json_data;
    }

    /**
     * @param $request
     * @return mixed
     */

    public function details($id)
    {
        $result = $this->genre::find($id);
        return $result;
    }

    public function store($request)
    {
        $genre = new $this->genre();
        $genre->name = $request->name;
        $genre->parent_id = $request->parent_id;
        $genre->status = 'Active';
        $genre->created_by = Auth::user()->id;
        $genre->save();
        return $genre;
    }

    public function update($request, $id)
    {
        $genre = $this->genre::findOrFail($id);
        $genre->name = $request->name;
        $genre->parent_id = $request->parent_id;
        $genre->status = 'Active';
        $genre->updated_by = Auth::user()->id;
        $genre->save();
        return $genre;
    }

    public function statusUpdate($id, $status)
    {
        $genre = $this->genre::find($id);
        $genre->status = $status;
        $genre->save();
        return $genre;
    }

    public function destroy($id)
    {
        $genre = $this->genre::find($id);
        $genre->delete();
        return true;
    }
}
