<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaleReturn extends Model
{
    use HasFactory;

      public function products()
    {
        return $this->hasMany(Product::class, 'category_id', 'id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function customer()
    {
        return $this->belongsTo(Accounts::class, 'ledger_id', 'id');
    }

    public function details()
    {
        return $this->hasMany(SaleReturnDetail::class, 'sale_return_id', 'id');
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }
}
