<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductionSetup extends Model
{
    use HasFactory;

    protected $guarded = ["id"];

    public function products()
    {
        return $this->belongsToMany(Product::class, 'production_setup_products')
            ->withPivot('quantity')
            ->withPivot('wattage')
            ->withPivot('body_color')
            ->withPivot('cct')
            ->withTimestamps();
    }

    function details(){
       return $this->hasMany(ProductionSetupProduct::class);
    }
}
