<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GoodsPurchases extends Model
{
    use HasFactory;

    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id', 'id');
    }

    public function products()
    {
        return $this->hasMany(Product::class, 'category_id', 'id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function supplier()
    {
        return $this->belongsTo(Accounts::class, 'ledger_id', 'id');
    }

    public function category()
    {
        return $this->belongsTo(Supplier::class, 'category_id', 'id');
    }

    public function details()
    {
        return $this->hasMany(GoodsPurchasesDetails::class, 'purchases_goods_id', 'id');
    }
}
