<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DabitVoucher extends Model
{
    use HasFactory;

    function account()
    {
        return $this->belongsTo(ChartOfAccount::class, 'account_id');
    }

    function project()
    {
        return $this->belongsTo(Project::class, 'project_id');
    }
    function supplier()
    {
        return $this->belongsTo(Supplier::class, 'supplier_id');
    }
    function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }
    function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }

    function details()
    {
        return $this->hasMany(DabitVoucherDetails::class, 'dabit_voucher_id');
    }

    function user()
    {
        return $this->belongsTo(User::class, 'approved_by', 'id');
    }
    function createBy()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }
    function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by', 'id');
    }
}
