<?php

namespace App\Http\Controllers;

use App\Jobs\ZktecoSetUser;
use App\Models\Attendance;
use App\Models\Branch;
use App\Models\Employee;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Rats\Zkteco\Lib\ZKTeco;

class ZktecoController extends Controller
{

    protected $baseUrl;
    protected $username;
    protected $password;
    protected $token = null;

    public function __construct()
    {
        $this->baseUrl  = rtrim(env('ZKTECO_IP'), '/');
        $this->username = env('ZKTECO_USERNAME');
        $this->password = env('ZKTECO_PASSWORD');
    }

    private function getToken()
    {


        if ($this->token) {
            return $this->token;
        }

        $response = Http::post($this->baseUrl . '/api-token-auth/', [
            'username' => $this->username,
            'password' => $this->password
        ]);

        if ($response->successful()) {
            $this->token = $response->json()['token']; // টোকেন সেভ করে রাখলাম
            return $this->token;
        }

        return null;
    }

    public function getDailyAttendance()
    {

        $token = $this->getToken();

        if (!$token) {
            return response()->json(['error' => 'Login Failed! Check Credentials.'], 401);
        }

        
        try {
            $today = date('Y-m-d');

            $response = Http::timeout(20)
                ->withHeaders(['Authorization' => 'Token ' . $token])
                ->get($this->baseUrl . '/iclock/api/transactions/', [
                    'page_size'  => 100,
                    'start_time' => $today . ' 00:00:00',
                    'end_time'   => $today . ' 23:59:59'
                ]);

            if ($response->successful()) {
                return response()->json([
                    'status' => 'success',
                    'data'   => $response->json()['data']
                ]);
            }

            return response()->json(['status' => 'error'], 500);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }





    public function zktectoAttendance()
    {

        $zkteco = new ZKTeco('192.168.0.109');
        $conn = $zkteco->connect();
        if ($conn) {
            $zktecoUsers = $zkteco->getUser();
            $collectData = collect($zktecoUsers);
            $zktecoUserId = $collectData->pluck('userid')->toArray();
            $employees = Employee::WhereNotIn('id', $zktecoUserId)->get();
        }

        if (count($employees) != 0) {
            foreach ($employees as $key => $employee) {
                dispatch(new ZktecoSetUser($employee));
            }
        }
    }




    public function storeAtten()
    {
        $zkteco = new ZKTeco('192.168.0.109');
        $conn = $zkteco->connect();
        if ($conn) {
            $zktecoAtten = $zkteco->getAttendance();
            $attendances = collect($zktecoAtten);
            $todayDate = date('Y-m-d');
            $attendances = $attendances->filter(function ($item) use ($todayDate) {
                return substr($item['timestamp'], 0, 10) == $todayDate;
            });

            foreach ($attendances as $key => $atten) {
                $branch_id = Employee::findOrFail($atten['id']);
                $createDate = date_create($atten['timestamp']);
                $date = date_format($createDate, 'Y-m-d');

                $employee = Attendance::Where('emplyee_id', $atten['id'])->whereDate('date', $date)->first();
                if ($employee) {
                    $attend = $attendances->filter(function ($item) use ($date, $atten) {
                        return substr($item['timestamp'], 0, 10) == $date && $item['id'] == $atten['id'];
                    });

                    $endTime = $attend->SortByDesc('timestamp')->first();
                    $endTime = date_create($endTime['timestamp']);
                    $endTime = date_format($endTime, 'H:i');

                    $employee->update([
                        'date'          => $date,
                        'sign_out'      => $endTime,
                    ]);
                } else {
                    $attend = $attendances->filter(function ($item) use ($date, $atten) {
                        return substr($item['timestamp'], 0, 10) == $date && $item['id'] == $atten['id'];
                    });
                    $entryTime = $attend->SortBy('timestamp')->first();
                    $entryTime = date_create($entryTime['timestamp']);
                    $entryTime = date_format($entryTime, 'H:i');

                    Attendance::create([
                        'emplyee_id'    => $atten['id'],
                        'branch_id'     => $branch_id->branch_id,
                        'date'          => $date,
                        'sign_in'       => $entryTime,
                        'sign_out'      => '00.00',
                    ]);
                }
            }
            return redirect()->route('hrm.attendancelog.index');
        }
    }

    public function checkConnection()
    {

        $baseUrl = rtrim(env('ZKTECO_IP'), '/');
        $username = env('ZKTECO_USERNAME');
        $password = env('ZKTECO_PASSWORD');
        $loginUrl = $baseUrl . '/api-token-auth/';

        // dd($baseUrl, $password,   $username,  $loginUrl);
        try {

            $response = Http::timeout(10)->post($loginUrl, [
                'username' => $username,
                'password' => $password
            ]);
            // dd($response->json());
            if ($response->successful()) {
                $data = $response->json();

                if (isset($data['token'])) {
                    return response()->json([
                        'status' => 'success',
                        'message' => 'Connection Established & Token Received!',
                        'token'   => $data['token']
                    ]);
                } else {
                    return response()->json([
                        'status' => 'error',
                        'message' => 'Connected to Server but No Token Found.',
                        'response' => $data
                    ], 400);
                }
            } else {

                return response()->json([
                    'status' => 'error',
                    'message' => 'Connection Failed / Invalid Credentials',
                    'details' => $response->json(),
                    'status_code' => $response->status()
                ], $response->status());
            }
        } catch (\Exception $e) {
            // যদি আইপি ভুল হয় বা ইন্টারনেট না থাকে
            return response()->json([
                'status' => 'critical_error',
                'message' => 'Server is Unreachable. Check IP or Internet Connection.',
                'error' => $e->getMessage()
            ], 500);
        }
    }
}
