<?php

namespace App\Http\Controllers\Backend\Sale;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Sale;
use App\Models\Category;
use App\Models\Customer;
use App\Models\Branch;
use App\Models\ChartOfAccount;
use App\Models\Company;
use App\Models\CustomerGroup;
use App\Models\SaleReturn;
use App\Services\Sale\SaleReturnService;
use App\Transformers\SalesTransformer;
use Illuminate\Validation\ValidationException;

class SaleReturnController extends Controller
{
      /**
     * @var SaleReturnService
     */
    private $systemService;

    /**
     * @var SalesTransformer
     */
    private $systemTransformer;

    /**
     * SaleController constructor.
     * @param SaleReturnService $systemService
     * @param SaleReturnService $systemTransformer
     */

    public function __construct(SaleReturnService $saleService, SalesTransformer $saleTransformer)
    {
        $this->systemService = $saleService;
        $this->systemTransformer = $saleTransformer;
    }

      public function index(Request $request)
    {
        $title = 'Sale List';
        return view('backend.pages.salereturn.index', get_defined_vars());
    }

    public function dataProcessingSaleReturn(Request $request)
    {
        $json_data = $this->systemService->getList($request);
        return json_encode($this->systemTransformer->dataTable($json_data));
    }

    public function create()
    {
        $title = 'Add New sale return';
        $sales = Sale::orderBy('id','desc')->get();
        $category_info = Category::get()->where('status', 'Active');
        $customer = Customer::get()->where('status', 'Active');
        $ledgers = ChartOfAccount::whereIn('id', [getAccountByUniqueID(5)->id, getAccountByUniqueID(16)->id])->get();

        // $branch = Branch::get()->where('status', 'Active');
        $user = auth()->user();
        $branch = Branch::where("parent_id", 0)->where('status', 'Active');
        if ($user->branch_id) {
            $branch = $branch->where('id', $user->branch_id);
        }
        $branch = $branch->get();
        $customerGroup = CustomerGroup::all();

        $wearhouses = Branch::where("parent_id", "!=", 0)->where('status', 'Active')->get();

        if ($user->type == "Admin" || $user->branch_id) {
            $account = ChartOfAccount::whereIn('id', [16, 17])->get()->where('status', 'Active');
        } elseif ($user->type == "Admin" || !$user->branch_id) {
            $account = ChartOfAccount::whereIn('id', [16, 17])->get()->where('status', 'Active')->where('branch_id', $user->branch_id);
        }

        $saleLastData = Sale::latest('id')->first();
        if ($saleLastData) :
            $saleData = $saleLastData->id + 1;
        else :
            $saleData = 1;
        endif;

        $invoice_no = 'SV' . str_pad($saleData, 5, "0", STR_PAD_LEFT);
        return view('backend.pages.salereturn.create', get_defined_vars());
    }

    public function saleInfo($invoiceId=null){
        $user = auth()->user();
        $saleInfo = Sale::with(['details.product.category', 'branch', 'customer'])->where('id',$invoiceId)->first();
        $saleReturn = SaleReturn::with(['details.product.category', 'branch', 'customer'])->where('sale_id',$invoiceId)->first();
       $ledger = ChartOfAccount::where('id', $saleInfo->ledger_id)->first();
     if ($user->type == "Admin" || $user->branch_id) {
            $account = ChartOfAccount::whereIn('id', [16, 17])->get()->where('status', 'Active');
        } elseif ($user->type == "Admin" || !$user->branch_id) {
            $account = ChartOfAccount::whereIn('id', [16, 17])->get()->where('status', 'Active')->where('branch_id', $user->branch_id);
        }
        $htmlData = view('backend.pages.salereturn.partial-data',compact('saleInfo','saleReturn','account'))->render();
       $htmlDataFooter = view('backend.pages.salereturn.sale-return-table',compact('saleInfo','saleReturn','account'))->render();
        $htmlDataSubtotal = view('backend.pages.salereturn.sale-return-subtotal',compact('saleInfo','account','saleReturn'))->render();
        return response()->json([
            'saleInfo'=> $saleInfo,
            'saleReturn' =>$saleReturn,
            'htmlData'=>$htmlData,
            'ledger'=> $ledger,
            'htmlDataFooter' =>$htmlDataFooter,
            'htmlDataSubtotal'=>$htmlDataSubtotal,
        ]);
    }

    public function store(Request $request)
    {
    //    dd($request->all());
        try {
            $this->validate($request, $this->systemService->storeValidation($request));
        } catch (ValidationException $e) {
            session()->flash('error', 'Validation error !!');
            return redirect()->back()->withErrors($e->errors())->withInput();
        }
        $this->systemService->store($request);
        session()->flash('success', 'Data successfully save!!');
        return redirect()->route('sale.salereturn.index');
    }

     public function show(Request $request, $id)
    {
        $title = 'Sale Return Invoice';

        $invoice = SaleReturn::with(['details.product.category', 'branch', 'customer'])->findOrFail($id);

        $companyInfo = Company::latest('id')->first();
        return view('backend.pages.salereturn.invoice', get_defined_vars());
    }
}
