<?php

namespace App\Http\Controllers\Backend\Production;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Branch;

use App\Models\User;
use App\Models\Product;
use App\Models\Navigation;
use App\Models\StockSummary;
use App\Models\Company;
use App\Models\Conversion;
use App\Models\Production;
use App\Models\ProductUnit;
use App\Models\Adjust;
use App\Models\Goods;
use App\Models\ProductionRequsition;
use App\Models\ProductionSetup;
use App\Models\ProductionStock;
use App\Models\Purchases;
use App\Models\PurchasesDetails;
use App\Services\Production\ProductionRequsitionApprovalService;
use DB;
use App\Transformers\ProductionTransformer;
use Illuminate\Validation\ValidationException;

class ProductionRequsitionApprovalController extends Controller
{

    /**
     * @var ProductionRequsitionApprovalService
     */
    private $systemService;

    /**
     * @var ProductionTransformer
     */
    private $systemTransformer;
    /**
     * ProductionController constructor.
     * @param ProductionRequsitionApprovalService $systemService
     * @param ProductionRequsitionApprovalService $systemTransformer
     */
    public function __construct(ProductionRequsitionApprovalService $ProductionSetupService, ProductionTransformer $ProductionTransformer)
    {
        $this->systemService = $ProductionSetupService;
        $this->systemTransformer = $ProductionTransformer;
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */

    public function index(Request $request)
    {
        $title = 'Production List';
        return view('backend.pages.production_requsition_approval.index', get_defined_vars());
    }

    public function dataProcessin(Request $request)
    {
        $json_data = $this->systemService->getList($request);
        return json_encode($this->systemTransformer->dataTable($json_data));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */

     public function create()
     {
         $title = 'Add New Production';

         // Get all productions and filter them based on total quantity > 0
         $productions = ProductionRequsition::with('details') // Ensure to eager load details
             ->get()
             ->filter(function ($production) {
                 // Loop through each production's details
                 $totalQty = 0;

                 foreach ($production->details as $details) {
                     // Retrieve stock based on production details (good_id, production_requsition_id)
                     $stock = ProductionStock::where("production_requsiton_id", $details->production_requsition_id)
                         ->where("goods_id", $details->good_id)
                         ->first();

                     // Calculate total quantity for the production
                     $stockQty = $stock ? $stock->qty : 0;
                     $totalQty += $details->qty - $stockQty;
                 }

                 // Only keep productions with a total quantity greater than 0
                 return $totalQty > 0;
             });

         return view('backend.pages.production_requsition_approval.create', compact('title', 'productions'));
     }


    public function show(Request $request, $id)
    {
        $title = 'Production Invoice';
        $invoice = ProductionRequsition::find($id);
        $companyInfo = Company::latest('id')->first();
        return view('backend.pages.production_requsition_approval.invoice', get_defined_vars());
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {
        try {
            $this->validate($request, $this->systemService->storeValidation($request));
        } catch (ValidationException $e) {
            session()->flash('error', 'Validation error !!');
            return redirect()->back()->withErrors($e->errors())->withInput();
        }
        $this->systemService->store($request);
        session()->flash('success', 'Data successfully save!!');
        return redirect()->route('production.requsition.approval.index');
    }

    /**
     * @param $slug
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit($id)
    {
        if (!is_numeric($id)) {
            session()->flash('error', 'Edit id must be numeric!!');
            return redirect()->back();
        }
        $editInfo = $this->systemService->details($id);
        if (!$editInfo) {
            session()->flash('error', 'Edit info is invalid!!');
            return redirect()->back();
        }
        $title = 'Edit Production';
        $productionSetup = ProductionSetup::with('products')->findOrFail($id);
        $products = Product::all(); // Assuming you have a Product model
        return view('backend.pages.production_requsition_approval.edit', get_defined_vars());
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request, $id)
    {
        if (!is_numeric($id)) {
            session()->flash('error', 'Edit id must be numeric!!');
            return redirect()->back();
        }
        $editInfo = $this->systemService->details($id);
        if (!$editInfo) {
            session()->flash('error', 'Edit info is invalid!!');
            return redirect()->back();
        }
        try {
            $this->validate($request, $this->systemService->updateValidation($request, $id));
        } catch (ValidationException $e) {
            session()->flash('error', 'Validation error !!');
            return redirect()->back()->withErrors($e->errors())->withInput();
        }
        $this->systemService->update($request, $id);
        session()->flash('success', 'Data successfully updated!!');
        return redirect()->route('production.setup.index');
    }

    /**
     * @param $slug
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function statusUpdate($id, $status)
    {
        if (!is_numeric($id)) {
            return response()->json($this->systemTransformer->invalidId($id), 200);
        }
        $detailsInfo = $this->systemService->details($id);
        if (!$detailsInfo) {
            return response()->json($this->systemTransformer->notFound($detailsInfo), 200);
        }
        $statusInfo = $this->systemService->statusUpdate($id, $status);
        if ($statusInfo) {
            return response()->json($this->systemTransformer->statusUpdate($statusInfo), 200);
        }
    }

    /**
     * @param $slug
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function destroy($id)
    {
        if (!is_numeric($id)) {
            return response()->json($this->systemTransformer->invalidId($id), 200);
        }
        $detailsInfo = $this->systemService->details($id);
        if (!$detailsInfo) {
            return response()->json($this->systemTransformer->notFound($detailsInfo), 200);
        }
        $deleteInfo = $this->systemService->destroy($id);
        if ($deleteInfo) {
            return response()->json($this->systemTransformer->delete($deleteInfo), 200);
        }
    }

    public function getProductListForProduction(Request $request)
    {
        $cat_id = $request->cat_id;
        $productList = Product::get()->where('category_id', $cat_id);
        //   dd($productList);
        $add = '';
        if (!empty($productList)) :
            $add .= "<option value=''>Select Product</option>";
            foreach ($productList as $key => $value) :
                $add .= "<option proName='" . $value->name . "'   value='" . $value->id . "'>$value->productCode - $value->name</option>";
            endforeach;
            echo $add;
            die;
        else :
            echo "<option value='' selected disabled>No Product Available</option>";
            die;
        endif;
    }

    public function getCustomerBalance(Request $request)
    {

        $finalValue = 0;
        $conditionalArray = array(
            'customer_id' => $request->customer_id,
            'payment_type' => $request->payment_type,
        );

        $debit = Adjust::where($conditionalArray)->sum('debit');
        $credit = Adjust::where($conditionalArray)->sum('credit');

        $adjustArray = array(
            'customer_id' => $request->customer_id,
            'payment_type' => 'Credit',
        );

        $expireData = Adjust::where($adjustArray)->orderBy('id', 'desc')->first();
        $finalValue = $debit - $credit;
        echo json_encode(array('finalBalance' => $finalValue, 'expireData' => $expireData['expire_date']));
    }

    public function unitPiceForProduction(Request $request)
    {
        $proid = $request->productId;
        $productPrice = Product::get()->where('id', $proid)->first();

        echo json_encode(array('purchases_price' => $productPrice->purchases_price, 'Production_price' => $productPrice->Production_price));
    }

    function getProductStock(Request $request)
    {

        $product_id = $request->productId;
        $productStock = StockSummary::get()->where('product_id', $product_id)->first();
        if (!empty($productStock->quantity) && $productStock->quantity > 0) :
            echo $productStock->quantity;
        endif;
    }


    function getProductListForThisBranchWise(Request $request)
    {
        $branch_id = $request->branch_id;
        $productList = StockSummary::where('branch_id', $branch_id)
            ->join('products', 'products.id', '=', 'stock_summaries.product_id')
            ->get();
        // pops($productList);

        $html = '';
        if ($productList->isNotEmpty()) {
            $html .= "<option value='' selected disabled>--Select Product--</option>";
            foreach ($productList as $key => $pro) {
                $html .= "<option value='" . $pro->id . "'>$pro->productCode - $pro->name</option>";
            }
        } else {
            $html .= "<option value='' selected disabled>--No Stock Products Available--</option>";
        }
        return $html;
    }

    function getCurrentStockAndRateofThisProduct(Request $request)
    {
        $whereCond = array(
            'product_id' => $request->product_id,
            'branch_id' => $request->branch_id,
        );
        return  $productDetails = StockSummary::where($whereCond)->first();
    }
    function getToProPrice(Request $request)
    {
        $whereCond = array(
            'id' => $request->product_id,
        );
        return  $productDetails = Product::where($whereCond)->first();
    }

    function purchaseDetailsByProduct(Request $request)
    {

        $pid = $request->pid;
        $priceDetails = PurchasesDetails::select(
            'products.sale_price',
            \DB::raw('avg(unit_price) as avg'),
            \DB::raw('sum(quantity) as ttlqty')
        )
            ->join('products', 'products.id', '=', 'purchases_details.product_id')
            ->groupBy('product_id')->orderBy('avg', 'DESC')
            ->where('product_id', $pid)
            ->first();
        // pops($priceDetails);
        return $priceDetails;
    }

    public function getProductionDetails(Request $request)
    {
        $productionId = $request->input('id');
        // Fetch the data you want to display based on the selected production
        $production = ProductionRequsition::find($productionId);
        $warehouse = Branch::where('parent_id', "!=", 0)->get();
        return response()->view('backend.pages.production_requsition_approval.details', get_defined_vars());
    }

    public function checkStock(Request $request)
    {
        $request->validate([
            'warehouse_id' => 'required',
            'good_id' => 'required',
            'required_qty' => 'required|integer|min:1',
        ]);

        $stockQty = \DB::table('goods_stock_summaries')
            ->where('branch_id', $request->warehouse_id)
            ->where('product_id', $request->good_id)
            ->value('quantity') ?? 0;

        if ($stockQty >= $request->required_qty) {
            return response()->json(['status' => 'available']);
        } else {
            return response()->json([
                'status' => 'unavailable',
                'available_qty' => $stockQty,
                'missing_qty' => $request->required_qty - $stockQty
            ]);
        }
    }
}
