<?php

namespace App\Console\Commands;

use App\Models\Attendance;
use App\Models\Employee;
use Illuminate\Console\Command;
use Rats\Zkteco\Lib\ZKTeco;
use App\Services\ZktecoService;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;

class AutoStoreAttendance extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'attendance:store';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';
    protected $zkService;
    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(ZktecoService $zkService)
    {
        parent::__construct();
        $this->zkService = $zkService;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $this->info('Starting Attendance Sync...');
        Log::info('Attendance Command Started via Cron Job');

        $today = Carbon::today()->format('Y-m-d');
        $transactions = $this->zkService->getAttendanceLogs($today);
        $attendances = collect($transactions);


        foreach ($attendances as $atten) {

            $empCode   = $atten['emp_code'];

            $punchTime = Carbon::parse($atten['punch_time']);

            $date = $punchTime->format('Y-m-d');
            $time = $punchTime->format('H:i:s'); // অথবা 'H:i'

            $employee = Employee::find($empCode);


            // $employee = Employee::where('code', $empCode)->first();

            if (!$employee) {

                $this->warn("Employee ID $empCode not found locally. Skipping...");
                continue;
            }


            $attendance = Attendance::where('emplyee_id', $empCode) // আপনার কলামের নাম অনুযায়ী
                ->where('date', $date)
                ->first();

            if ($attendance) {

                if ($time > $attendance->sign_out) {
                    $attendance->update([
                        'sign_out' => $time
                    ]);
                    $this->line("Updated OUT: $empCode at $time");
                }
            } else {

                Attendance::create([
                    'emplyee_id' => $empCode,
                    'branch_id'  => $employee->branch_id,
                    'date'       => $date,
                    'sign_in'    => $time,
                    'sign_out'   => $time,
                ]);
                $this->line("Created IN: $empCode at $time");
            }
        }

        $this->info('Attendance Sync Completed Successfully!');
        return 1;



        // $zkteco = new ZKTeco('103.206.231.50');
        // $conn = $zkteco->connect();

        // if ($conn) {
        //     $zktecoAtten = $zkteco->getAttendance();
        //     $attendances = collect($zktecoAtten);
        //     $todayDate = date('Y-m-d');
        //     $attendances = $attendances->filter(function ($item) use ($todayDate) {
        //         return substr($item['timestamp'], 0, 10) == $todayDate;
        //     });

        //     foreach ($attendances as $key => $atten) {
        //         $branch_id = Employee::findOrFail($atten['id']);
        //         $createDate = date_create($atten['timestamp']);
        //         $date = date_format($createDate, 'Y-m-d');

        //         $employee = Attendance::Where('emplyee_id', $atten['id'])->whereDate('date', $date)->first();
        //         if ($employee) {
        //             $attend = $attendances->filter(function ($item) use ($date, $atten) {
        //                 return substr($item['timestamp'], 0, 10) == $date && $item['id'] == $atten['id'];
        //             });

        //             $endTime = $attend->SortByDesc('timestamp')->first();
        //             $endTime = date_create($endTime['timestamp']);
        //             $endTime = date_format($endTime, 'H:i');

        //             $employee->update([
        //                 'date'          => $date,
        //                 'sign_out'      => $endTime,
        //             ]);
        //         } else {
        //             $attend = $attendances->filter(function ($item) use ($date, $atten) {
        //                 return substr($item['timestamp'], 0, 10) == $date && $item['id'] == $atten['id'];
        //             });
        //             $entryTime = $attend->SortBy('timestamp')->first();
        //             $entryTime = date_create($entryTime['timestamp']);
        //             $entryTime = date_format($entryTime, 'H:i');

        //             Attendance::create([
        //                 'emplyee_id'    => $atten['id'],
        //                 'branch_id'     => $branch_id->branch_id,
        //                 'date'          => $date,
        //                 'sign_in'       => $entryTime,
        //                 'sign_out'      => '00.00',
        //             ]);
        //         }
        //     }
        //     return 1;
        // }
    }
}
